@extends('layouts.master')
@section('title', 'Simplified Tax Invoice')

@section('css')
    <style>
        .invoice {

            padding: 40px 50px;
            border-radius: 8px;
            border: 1px solid #e3e3e3;
            max-width: 900px;
            margin: auto;
            box-shadow: 0 0 8px rgba(0, 0, 0, 0.05);
            color: #222;
        }

        .invoice-header {
            border-bottom: 2px solid #dee2e6;
            padding-bottom: 15px;
            margin-bottom: 20px;
        }

        .invoice-header h3 {
            font-weight: 700;
            margin: 0;
        }

        .invoice-header small {
            color: #777;
        }

        .invoice-meta {
            font-size: 14px;
            color: #555;
        }

        .table th {
            background: #f9f9f9;
            color: #333;
            font-weight: 600;
            border-color: #e0e0e0 !important;
        }

        .table td {
            border-color: #e0e0e0 !important;
            vertical-align: middle !important;
        }

        .total-section {
            background: #f9f9f9;
            border-radius: 8px;
            padding: 15px;
            border: 1px solid #e0e0e0;
        }

        .total-section h5 {
            margin: 0;
            font-weight: 700;
            color: #198754;
        }

        .footer {
            text-align: center;
            font-size: 13px;
            color: #666;
            margin-top: 30px;
        }

        @media print {
            .no-print {
                display: none !important;
            }

            body {
                background: #fff;
            }

            .invoice {
                box-shadow: none;
                border: none;
                margin: 0;
                padding: 0;
            }
        }
    </style>
@endsection

@section('content')
    <div class="container my-4">
        <div class="invoice" id="invoiceArea">
            {{-- ===== HEADER ===== --}}
            <div class="d-flex justify-content-between align-items-start invoice-header">
                <div>
                    <h3>فاتورة ضريبية مبسطة<br><small>Simplified Tax Invoice</small></h3>
                </div>
                <div class="text-end">
                    <div id="qrcode"></div>
                </div>
            </div>

            {{-- ===== BASIC INFO ===== --}}
            <div class="row mb-4">
                <div class="col-md-6">
                    <p><strong>Invoice No / رقم الفاتورة:</strong> {{ $sub->invoice_no }}</p>
                    <p><strong>Date / التاريخ:</strong> {{ $sub->created_at->format('Y-m-d') }}</p>
                    <p><strong>VAT Number / الرقم الضريبي:</strong> 314133750400003</p>
                </div>
                <div class="col-md-6 text-md-end">
                    <p><strong> العضو:</strong> {{ $sub->member->name ?? '—' }}</p>
                    <p><strong>Branch / الفرع:</strong> {{ $sub->branch->name ?? '—' }}</p>
                    <p><strong>Status / الحالة:</strong>
                        @if ($sub->status === 'approved')
                            <span class="text-success">معتمد ✅</span>
                        @elseif($sub->status === 'rejected')
                            <span class="text-danger">مرفوض ❌</span>
                        @else
                            <span class="text-warning">تحت المراجعة</span>
                        @endif
                    </p>
                </div>
            </div>

            {{-- ===== DATES ===== --}}
            <div class="row mt-4 mb-3 text-center small bg-secondary rounded-3 py-3">
                <div class="col-md-6">
                    <p><b>📅 بداية الاشتراك:</b> {{ $sub->start_date->format('Y-m-d') }}</p>
                </div>
                <div class="col-md-6">
                    <p><b>⏳ نهاية الاشتراك:</b> {{ $sub->end_date->format('Y-m-d') }}</p>
                </div>
            </div>



            {{-- ===== ITEMS TABLE ===== --}}
            @php
                $base_price = $sub->price; // السعر الأساسي
                $extra_discount = $sub->discount; // الخصم الإضافي فقط
                $tax = $sub->tax; // الضريبة المحفوظة
                $total = $sub->total; // الإجمالي النهائي
                $net_amount = $total - $tax; // الصافي قبل الضريبة (الحقيقي)
            @endphp

            <table class="table table-bordered text-center align-middle">
                <thead>
                    <tr>
                        <th>الوصف / Description</th>
                        <th>الكمية / Qty</th>
                        <th>السعر الأساسي / Base Price</th>
                        <th>الخصم الإضافي / Extra Discount</th>
                        <th>الصافي قبل الضريبة / Net Before VAT</th>
                        <th>الضريبة / VAT (15%)</th>
                        <th>الإجمالي / Total</th>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td>{{ $sub->item_name }}</td>
                        <td>1</td>
                        <td>{{ number_format($base_price, 2) }}</td>
                        <td>{{ number_format($extra_discount, 2) }}</td>
                        <td class="fw-bold text-info">{{ number_format($net_amount, 2) }}</td>
                        <td>{{ number_format($tax, 2) }}</td>
                        <td class="fw-bold text-success">{{ number_format($total, 2) }}</td>
                    </tr>
                </tbody>
            </table>


            {{-- ===== PAYMENTS ===== --}}
            @php
                $payments = is_array($sub->payment_methods)
                    ? $sub->payment_methods
                    : json_decode($sub->payment_methods, true);
            @endphp

            @if (!empty($payments))
                <h6 class="fw-bold mt-4 mb-2">💳 تفاصيل الدفع / Payment Details</h6>
                <table class="table table-sm table-bordered text-center align-middle">
                    <thead>
                        <tr>
                            <th>طريقة الدفع / Method</th>
                            <th>المبلغ / Amount</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($payments as $p)
                            @php
                                $method = \App\Models\PaymentMethod::find($p['method_id'] ?? null);
                            @endphp
                            <tr>
                                <td>{{ $method->name_ar ?? '—' }}</td>
                                <td>{{ number_format($p['amount'] ?? 0, 2) }}</td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            @endif

            {{-- ===== TOTAL ===== --}}
            <div class="total-section mt-4">
                <div class="d-flex justify-content-between align-items-center">
                    <div><strong>الإجمالي شامل الضريبة / Total incl. VAT</strong></div>
                    <h5>{{ number_format($sub->total, 2) }} </h5>
                </div>
            </div>



            {{-- ===== FOOTER ===== --}}
            <div class="footer">
                <p>شكراً لاختياركم خدمتنا ❤️<br>Thank you for choosing our service</p>
            </div>

            <div class="text-end mt-3 no-print">
                <button class="btn btn-outline-secondary" onclick="window.print()">🖨️ طباعة</button>
            </div>
        </div>
    </div>
@endsection

@section('js')
    <script>
        // ✅ دالة لتوليد TLV + تحويله إلى Base64
        function toTLV(tag, value) {
            const textEncoder = new TextEncoder();
            const valueBytes = textEncoder.encode(value);
            return new Uint8Array([tag, valueBytes.length, ...valueBytes]);
        }

        function generateZATCAQRCode() {
            const sellerName = "Smart Fitness Sports Company"; // 👈 غيّرها لاسم شركتك
            const vatNumber = "314133750400003"; // 👈 الرقم الضريبي
            const invoiceDate = "{{ $sub->created_at->format('Y-m-d\TH:i:s') }}";
            const totalAmount = "{{ number_format($sub->total, 2, '.', '') }}";
            const vatAmount = "{{ number_format($sub->tax, 2, '.', '') }}";

            // 🔹 بناء TLV
            const tlv = [
                toTLV(1, sellerName),
                toTLV(2, vatNumber),
                toTLV(3, invoiceDate),
                toTLV(4, totalAmount),
                toTLV(5, vatAmount)
            ];

            // 🔹 دمج كل البايتات
            const merged = new Uint8Array(tlv.reduce((acc, curr) => [...acc, ...curr], []));
            const base64 = btoa(String.fromCharCode(...merged));

            // 🔹 إنشاء كود QR متوافق مع ZATCA
            const qrUrl = `https://api.qrserver.com/v1/create-qr-code/?data=${encodeURIComponent(base64)}&size=130x130`;
            document.getElementById("qrcode").innerHTML = `
                <img src="${qrUrl}" alt="QR Code" width="130" height="130" style="border:1px solid #ddd;border-radius:8px;">
            `;
        }

        // 🚀 عند تحميل الصفحة
        document.addEventListener("DOMContentLoaded", generateZATCAQRCode);
    </script>
@endsection
