@extends('layouts.master')
@section('title', 'تفاصيل الاشتراك')

@section('content')
    <div class="container-fluid">
        <div class="card shadow p-4">
            <div class="d-flex justify-content-between mb-3">
                <h4><i class="fas fa-user me-2"></i> تفاصيل الاشتراك</h4>
                <a href="{{ route('subscriptions.invoice', $sub->id) }}" target="_blank" class="btn btn-success">
                    <i class="fas fa-print me-1"></i> طباعة الفاتورة
                </a>
            </div>

            <table class="table table-bordered">
                <tr>
                    <th>رقم الفاتورة</th>
                    <td>{{ $sub->invoice_code }}</td>
                </tr>
                <tr>
                    <th>العضو</th>
                    <td>{{ $sub->member->name ?? '—' }}</td>
                </tr>
                <tr>
                    <th>الفرع</th>
                    <td>{{ $sub->branch->name ?? '—' }}</td>
                </tr>
                <tr>
                    <th>نوع الاشتراك</th>
                    <td>{{ $sub->subscription_type === 'service' ? 'خدمة' : 'عرض' }}</td>
                </tr>
                <tr>
                    <th>العنصر</th>
                    <td>{{ $sub->item_name }}</td>
                </tr>
                <tr>
                    <th>طريقة الدفع</th>
                    <td>{{ $sub->paymentMethod->name_ar ?? '—' }}</td>
                </tr>
                <tr>
                    <th>السعر</th>
                    <td>{{ number_format($sub->price, 2) }}</td>
                </tr>
                <tr>
                    <th>الخصم</th>
                    <td>{{ number_format($sub->discount, 2) }}</td>
                </tr>
                <tr>
                    <th>الضريبة</th>
                    <td>{{ number_format($sub->tax, 2) }}</td>
                </tr>
                <tr>
                    <th>الإجمالي</th>
                    <td class="text-success fw-bold">{{ number_format($sub->total, 2) }}</td>
                </tr>
                <tr>
                    <th>الفترة</th>
                    <td>{{ $sub->start_date }} → {{ $sub->end_date }}</td>
                </tr>
            </table>
        </div>
    </div>
@endsection
