@extends('frontEnd.layouts.Fmaster')

@section('FrontCss')
    <style>
        .about-section {
            background: #1a1a1a;
            color: #e9e9e9;
            padding: 70px 0;
        }

        .about-title {
            font-size: 34px;
            font-weight: 800;
            color: #d8c1a0;
            margin-bottom: 15px;
        }

        .about-subtitle {
            font-size: 17px;
            color: #cccccc;
            line-height: 1.9;
            max-width: 800px;
            margin: 0 auto 40px;
        }

        .about-img {
            border-radius: 15px;
            box-shadow: 0 0 15px rgba(0, 0, 0, .4);
            transition: .3s ease-in-out;
            max-width: 100% !important;
        }

        .about-img:hover {
            transform: scale(1.03);
            box-shadow: 0 0 25px rgba(216, 193, 160, .3);
        }

        .section-title {
            font-size: 28px;
            font-weight: 700;
            color: #d8c1a0;
            margin-bottom: 20px;
        }

        .section-text {
            font-size: 16px;
            color: #cfcfcf;
            line-height: 1.9;
        }

        .about-block {
            margin-bottom: 80px;
        }
    </style>
@endsection



@section('FrontContent')
    <main class="aboutus">

        <!-- ============================= SECTION 1 ============================= -->
        <section class="about-section text-center">
            <div class="container">

                <h2 class="about-title">{{ __('about.title') }}</h2>

                <p class="about-subtitle">
                    {!! nl2br(e(__('about.subtitle'))) !!}
                </p>

                <img src="{{ asset('front_assets/imge/1.png') }}" class="img-fluid about-img mt-4" alt="About Gym"
                    style="max-width: 650px">

            </div>
        </section>

        <!-- ============================= SECTION 2 ============================= -->
        <section class="about-section">
            <div class="container about-block">
                <div class="row align-items-center">

                    <div class="col-lg-6 text-center">
                        <img src="{{ asset('front_assets/imge/2.png') }}" class="img-fluid about-img" alt="">
                    </div>

                    <div class="col-lg-6 text-center  mt-4 mt-lg-0">
                        <h3 class="section-title">{{ __('about.block1_title') }}</h3>

                        <p class="section-text">{{ __('about.block1_p1') }}</p>
                        <p class="section-text">{{ __('about.block1_p2') }}</p>
                    </div>

                </div>
            </div>
        </section>

        <!-- ============================= SECTION 3 ============================= -->
        <section class="about-section">
            <div class="container about-block">
                <div class="row align-items-center flex-lg-row-reverse">

                    <div class="col-lg-6 text-center">
                        <img src="{{ asset('front_assets/imge/1.png') }}" class="img-fluid about-img" alt="">
                    </div>

                    <div class="col-lg-6 text-center  mt-4 mt-lg-0">
                        <h3 class="section-title">{{ __('about.block2_title') }}</h3>

                        <p class="section-text">{{ __('about.block2_p1') }}</p>
                        <p class="section-text">{{ __('about.block2_p2') }}</p>
                    </div>

                </div>
            </div>
        </section>

    </main>
@endsection

@section('FrontJs')
@endsection
