@extends('frontEnd.layouts.Fmaster')

@section('FrontCss')
    <style>
        .section-title,
        .section-titlee,
        .vision-title,
        .testimonials-title,
        .title {
            color: #d8c1a0;
            font-weight: 800;
            text-align: center;
        }

        .section-titlee span {
            color: #fff;
        }

        .why-choose-us {
            background: #151515;
            padding: 80px 0;
        }

        .feature-card {
            background: #1f1f1f;
            border: 1px solid #333;
            padding: 25px;
            border-radius: 16px;
            transition: .3s;
            position: relative;
        }

        .feature-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 0 20px rgba(216, 193, 160, 0.18);
        }

        .feature-number {
            background: #d8c1a0;
            color: #000;
            padding: 6px 15px;
            border-radius: 10px;
            position: absolute;
            top: -8px;
            right: 15px;
            font-weight: bold;

        }

        .feature-title {
            color: wheat;
        }

        .feature-description {
            color: #dcdcdc;
            font-size: 1rem;
        }

        .custom-hero-section {
            background: #0e0e0e;
            padding: 80px 0;
        }

        /* الصور */
        .custom-image {
            width: 48%;
            max-width: 420px;
            /* تكبير الصورة على الشاشات الكبيرة */
            border-radius: 18px;
            transition: .4s ease;
            object-fit: cover;
        }

        /* Hover */
        .custom-image:hover {
            transform: scale(1.07);
        }

        /* الموبايل */
        @media (max-width: 768px) {
            .custom-hero-section .d-flex {
                flex-direction: column !important;
                gap: 25px !important;
            }

            .custom-image {
                width: 90% !important;
                max-width: 90% !important;
                /* أقصى حجم على الموبايل */
            }
        }

        /* الشاشات الصغيرة جداً */
        @media (max-width: 480px) {
            .custom-image {
                width: 100% !important;
                max-width: 100% !important;
                border-radius: 12px;
            }
        }


        .mission-vision-section {
            padding: 90px 0;
            background: #141414;
        }

        .section-text {
            color: #dcdcdc;
            font-size: 1.1rem;
            line-height: 1.9;
        }

        .vision-box {
            position: relative;
            text-align: center;
        }

        .vision-img {
            width: 100%;
            border-radius: 16px;
            opacity: .25;
        }

        .vision-text {
            position: absolute;
            width: 100%;
            /* top: 50%; */
            /* left: 50%; */

        }

        @media (max-width: 768px) {
            .vision-text {
                /* bottom: 15px; */
                right: 11px !important;
            }
        }

        /* العنوان */
        .vision-title {
            color: #d8c1a0;
            font-size: 32px;
            font-weight: 800;
        }

        /* النص */
        .vision-desc {
            color: #ffffff;
            font-size: 18px;
            line-height: 1.8;
        }

        /* تناسق كامل على الشاشات الصغيرة */
        @media (max-width: 576px) {


            .vision-title {
                font-size: 26px;
            }

            .vision-desc {
                font-size: 16px;
            }
        }


        .testimonials-section {
            position: relative;
            padding: 100px 0;
        }

        .overlay {
            position: absolute;
            inset: 0;
            background: rgba(0, 0, 0, .75);
        }

        .testimonial-card {
            background: #202020;
            padding: 28px;
            border-radius: 16px;
            width: 80%;
        }

        .stars {
            color: #d8c1a0;
            font-size: 22px;
        }

        .client-img {
            width: 120px;
            height: 120px;
            object-fit: contain;
            border-radius: 50%;
            border: 3px solid #d8c1a0;
        }

        .gym-section {
            background: linear-gradient(135deg, #0d0d0d, #1d1d1d);
            padding: 90px 0;
        }

        .custom-input {
            background: #232323;
            border: 1px solid #444;
            padding: 12px;
            border-radius: 12px;
            color: #eee;
        }

        .submit-btn {
            background: #d8c1a0;
            padding: 12px;
            border-radius: 12px;
            font-weight: bold;
            color: #000;
            transition: .3s;
        }

        .submit-btn:hover {
            background: #c5ad85;
        }
    </style>
@endsection


@section('FrontContent')
    {{-- WHY CHOOSE US --}}
    <section class="why-choose-us">
        <div class="container">
            <h2 class="section-titlee text-center">
                {{ __('home.why_title') }}
            </h2>

            <p class="text-center fs-5 mb-5">
                {{ __('home.why_desc') }}
            </p>

            <div class="row">

                @foreach ([['id' => 1, 'title' => __('home.card1_title'), 'desc' => __('home.card1_desc')], ['id' => 2, 'title' => __('home.card2_title'), 'desc' => __('home.card2_desc')], ['id' => 3, 'title' => __('home.card3_title'), 'desc' => __('home.card3_desc')], ['id' => 4, 'title' => __('home.card4_title'), 'desc' => __('home.card4_desc')]] as $card)
                    <div class="col-lg-6 col-md-6 mb-4">
                        <div class="feature-card">
                            <div class="feature-number">{{ $card['id'] }}</div>
                            <h3 class="feature-title">{{ $card['title'] }}</h3>
                            <p class="feature-description">{{ $card['desc'] }}</p>
                        </div>
                    </div>
                @endforeach

            </div>
        </div>
    </section>


    {{-- HERO --}}
    <section class="custom-hero-section">
        <div class="container text-center">
            <div class="d-flex justify-content-center gap-3 align-items-center">
                <img src="{{ asset('front_assets/imge/right.png') }}" class="custom-image">
                <img src="{{ asset('front_assets/imge/lift.png') }}" class="custom-image">
            </div>
        </div>
    </section>


    {{-- MISSION & VISION --}}
    <section class="mission-vision-section">
        <div class="container">

            <div class="row align-items-center mb-5">
                <div class="col-lg-6">

                    <h2 class="section-title">{{ __('home.mission_title') }}</h2>

                    <p class="section-text">
                        {{ __('home.mission_text') }}
                    </p>

                </div>

                <div class="col-lg-6 text-center">
                    <img src="{{ asset('front_assets/imge/2.png') }}" class="img-fluid rounded shadow">
                </div>
            </div>


            <div class="row justify-content-center">
                <div class="col-12 col-md-12 col-sm-12 col-lg-12 col-xl-12 ">

                    <div class="vision-box">
                        <img src="{{ asset('front_assets/imge/1.png') }}" class="vision-img">

                        <div class="vision-text">
                            <h2 class="vision-title">{{ __('home.vision_title') }}</h2>
                            <p class="vision-desc">
                                {{ __('home.vision_text') }}
                            </p>
                        </div>

                    </div>

                </div>
            </div>

        </div>
    </section>


    {{-- TESTIMONIALS --}}
    <section class="testimonials-section">
        <div class="overlay"></div>

        <div class="container text-center position-relative">

            <h2 class="testimonials-title mb-3">
                {{ __('home.testimonials_title') }}
            </h2>

            <p class="mb-4 fs-5 text-light">
                {{ __('home.testimonials_text') }}
            </p>

            <div id="testimonialCarousel" class="carousel slide" data-bs-ride="carousel">

                <div class="carousel-inner">

                    <div class="carousel-item active">
                        <div class="testimonial-card mx-auto">
                            <div class="stars mb-2">★★★★★</div>
                            <h4 class="client-name">{{ __('home.client1') }}</h4>
                            <img src="{{ asset('front_assets/imge/logo 1.png') }}" class="client-img">
                        </div>
                    </div>

                    <div class="carousel-item">
                        <div class="testimonial-card mx-auto">
                            <div class="stars mb-2">★★★★★</div>
                            <h4 class="client-name">{{ __('home.client2') }}</h4>
                            <img src="{{ asset('front_assets/imge/logo 1.png') }}" class="client-img">
                        </div>
                    </div>

                </div>

            </div>

        </div>
    </section>


    {{-- JOIN GYM --}}
    <section class="gym-section">
        <div class="container">

            <div class="row align-items-center">

                <div class="col-md-5 text-center">
                    <img src="{{ asset('front_assets/imge/logo 2.png') }}" class="gym-illustration">
                </div>

                <div class="col-md-7 text-light">

                    <h2 class="title">
                        {{ __('home.join_title') }}
                    </h2>

                    <p class="subtitle mb-4">
                        {{ __('home.join_desc') }}
                    </p>

                    <form>
                        <div class="row g-3">

                            <div class="col-md-6">
                                <input type="text" class="form-control custom-input"
                                    placeholder="{{ __('home.name') }}">
                            </div>

                            <div class="col-md-6">
                                <input type="text" class="form-control custom-input"
                                    placeholder="{{ __('home.phone') }}">
                            </div>

                            <div class="col-12">
                                <input type="email" class="form-control custom-input"
                                    placeholder="{{ __('home.email') }}">
                            </div>

                            <div class="col-12">
                                <button class="submit-btn w-100">
                                    {{ __('home.submit') }}
                                </button>
                            </div>

                        </div>
                    </form>

                </div>

            </div>

        </div>
    </section>
@endsection


@section('FrontJs')
@endsection
