@extends('frontEnd.layouts.Fmaster')

@section('FrontCss')
    <style>
        .service-card {
            background: #1f1f1f;
            border: 1px solid #333;
            border-radius: 15px;
            padding: 22px;
            text-align: center;
            color: #f5f5f5;
            transition: 0.3s ease;
            animation: fadeIn 0.5s ease forwards;
            opacity: 0;
        }

        .service-card:hover {
            transform: translateY(-6px);
            box-shadow: 0 0 12px rgba(255, 255, 255, 0.08);
        }

        .service-logo {
            width: 80px;
            margin: 0 auto 12px;
            display: block;
            object-fit: contain;
        }

        .service-name {
            font-size: 20px;
            font-weight: bold;
            color: #d8c1a0;
            margin-bottom: 8px;
        }

        .service-price {
            font-size: 24px;
            font-weight: bold;
            color: #fff;
        }

        .service-meta {
            color: #cfcfcf;
            font-size: 14px;
            margin-top: 5px;
        }

        .custom-badge {
            display: inline-flex;
            align-items: center;
            gap: 6px;
            background: linear-gradient(135deg, #c27912, #c5ad85);
            color: #000;
            font-weight: bold;
            padding: 6px 14px;
            border-radius: 12px;
            font-size: 14px;
            box-shadow: 0 0 8px rgba(216, 193, 160, 0.3);
            margin: 8px auto;
        }

        .custom-badge i {
            font-size: 16px;
        }

        @keyframes fadeIn {
            from {
                opacity: 0;
                transform: translateY(15px);
            }

            to {
                opacity: 1;
                transform: translateY(0);
            }
        }
    </style>
@endsection


@section('FrontContent')
    <section class="pricing-section py-5">
        <div class="container text-center">

            <h2 class="pricing-title fw-bold mb-2">{{ __('services.title') }}</h2>

            <p class="pricing-subtitle mb-5">
                {{ __('services.subtitle') }}
            </p>

            <div class="row g-4 justify-content-center">

                @foreach ($services as $service)
                    @php
                        $locale = app()->getLocale();

                        // لو الخدمة مستخدمة Spatie Translatable:
                        if (method_exists($service, 'getTranslation')) {
                            // اسم الخدمة حسب اللغة الحالية
                            $serviceName =
                                $service->getTranslation('name', $locale) ?:
                                $service->getTranslation('name', 'ar') ?:
                                'Service';

                            // الملاحظات (لو مترجمة) – لو فاضية هنجيب النص الافتراضي من ملف الترجمة
                            $serviceNotes = $service->getTranslation('notes', $locale) ?: __('services.default_notes');
                        } else {
                            // fallback لو مش Spatie (لو مجرد JSON عادي)
                            $rawName = $service->name;
                            $name = is_string($rawName) ? json_decode($rawName, true) : (array) $rawName;

                            $serviceName = $name[$locale] ?? ($name['ar'] ?? ($name['en'] ?? 'Service'));

                            $rawNotes = $service->notes;
                            $notes = is_string($rawNotes) ? json_decode($rawNotes, true) : (array) $rawNotes;
                            $serviceNotes = $notes[$locale] ?? __('services.default_notes');
                        }
                    @endphp

                    <div class="col-md-4">
                        <div class="service-card">

                            <img src="{{ asset('front_assets/imge/logo 1.png') }}" class="service-logo">

                            <div class="service-name">{{ $serviceName }}</div>

                            <div class="service-price">${{ $service->price }}</div>

                            <div class="service-meta">
                                <i class="bi bi-hourglass-split"></i>
                                {{ __('services.duration') }}:
                                {{ $service->duration_value }} {{ $service->duration_unit }}
                            </div>

                            <div class="custom-badge">
                                <i class="bi bi-star-fill"></i>
                                {{ __('services.featured_badge') }}
                            </div>

                            <p class="service-meta mt-2">
                                {{ $serviceNotes }}
                            </p>

                        </div>
                    </div>
                @endforeach


            </div>

        </div>
    </section>
@endsection


@section('FrontJs')
@endsection
