<header class="page-header row">
    <div class="logo-wrapper d-flex align-items-center col-auto">
        <!-- Logo -->
        <a href="#">
            <img class="light-logo img-fluid " src="{{ asset('assets/images/card/admin.png') }}" alt="logo">
            <img class="dark-logo img-fluid " src="{{ asset('assets/images/card/admin.png') }}" alt="logo">
        </a>
        <!-- Close Button -->
        <a class="close-btn toggle-sidebar" href="javascript:void(0)">
            <i class="fas fa-bars colored"></i> <!-- FontAwesome Menu Icon -->
        </a>
    </div>
    <div class="page-main-header col">
        <div class="header-left">
            @if (auth()->check() && auth()->user()?->branch)
                <span class="badge bg-primary px-3 py-2 shadow-sm">
                    <i class="fas fa-building me-1"></i>
                    {{ optional(auth()->user()?->branch)->getTranslation('name', app()->getLocale()) ?? '' }}
                </span>
            @else
            @endif
        </div>

        <div class="nav-right">
            <ul class="header-right">
                <!-- Language Dropdown -->
                <li class="custom-dropdown">
                    <div class="translate_wrapper">
                        <div class="current_lang">
                            <a class="lang" href="javascript:void(0)" id="languageDropdown" role="button"
                                data-bs-toggle="dropdown" aria-expanded="false">
                                <span class="lang-txt f-w-900 text-uppercase "> <i
                                        class="fas fa-globe  mx-2 "></i>{{ app()->getLocale() }} </span>
                            </a>

                        </div>
                        <ul class="custom-menu profile-menu language-menu py-0 more_lang">

                            @foreach (LaravelLocalization::getSupportedLocales() as $localeCode => $properties)
                                @if ($localeCode !== app()->getLocale())
                                    <li class="d-block"><a class="lang d-flex align-middle"
                                            href="{{ LaravelLocalization::getLocalizedURL($localeCode, null, [], true) }}"
                                            data-value="{{ $properties['name'] }}">
                                            <i class="fas fa-globe mx-1 colored"></i>
                                            <span class="lang-txt f-w-700 "> {{ $properties['name'] }}</span>

                                        </a></li>
                                @endif
                            @endforeach

                        </ul>
                    </div>
                </li>
                <!-- Search (Mobile) -->

                <!-- Dark Mode -->
                <li>
                    <a class="dark-mode" href="javascript:void(0)">

                        <i class="fas fa-moon colored"></i> <!-- FontAwesome Moon Icon -->
                    </a>
                </li>
                <!-- Cart -->

                <!-- Notifications -->
                {{-- <li class="custom-dropdown">
                    <a href="javascript:void(0)">
                        <i class="fas fa-bell"></i> <!-- FontAwesome Notification Bell -->
                    </a>
                    <span class="badge rounded-pill badge-primary">4</span>
                    <!-- Notification Dropdown -->
                    <div class="custom-menu notification-dropdown py-0 overflow-hidden">
                        <h3 class="title bg-primary-light dropdown-title">
                            Notification <span class="font-primary">View all</span>
                        </h3>
                        <ul class="activity-timeline">
                            <!-- Notification Items -->
                            <li class="d-flex align-items-start">
                                <div class="activity-dot-primary"></div>
                                <div class="flex-grow-1">
                                    <h6 class="f-w-600 font-primary">30-04-2024<span>Today</span></h6>
                                    <h5>Alice Goodwin</h5>
                                    <p>Fashion should be fun.</p>
                                </div>
                            </li>
                        </ul>
                    </div>
                </li> --}}
                <!-- Full Screen -->
                <li>
                    <a class="full-screen" href="javascript:void(0)">
                        <i class="fas fa-expand colored"></i> <!-- FontAwesome Expand Icon -->
                    </a>
                </li>
                <!-- User Profile -->
                <li class="profile-nav custom-dropdown">
                    <div class="user-wrap">
                        <div class="user-img"><img src="{{ asset('assets/images/profile.png') }}" alt="user"></div>
                        <div class="user-content">
                            <h6>{{ auth()->user()->name ?? '' }}</h6>
                            <p class="mb-0">{{ auth()->user()->name ?? '' }}<i
                                    class="fas fa-chevron-down colored"></i></p>
                            <!-- FontAwesome Dropdown Icon -->
                        </div>
                    </div>


                    <div class="custom-menu overflow-hidden">
                        <ul class="profile-body">
                            {{-- <li class="d-flex"><i class="fas fa-user text-primary"></i><a class="ms-2"
                                    href="">{{ __('dashboard.profile') }}</a>
                            </li> --}}

                            <li class="d-flex align-items-center">
                                <i class="fas fa-sign-out-alt text-danger me-2"></i>

                                @if (auth('web')->check())
                                    <form method="POST" action="{{ route('admin.logout') }}" id="logout-form"
                                        class="d-inline">
                                        @csrf
                                        <button type="submit" class="btn btn-link dropdown-item text-danger p-0">
                                            {{ __('messages.log_out') }}
                                        </button>
                                    </form>
                                @endif
                            </li>

                        </ul>
                    </div>
                </li>
            </ul>
        </div>
    </div>
</header>
