<!DOCTYPE html>
<html lang="{{ app()->getLocale() }}" dir="{{ app()->getLocale() == 'ar' ? 'rtl' : 'ltr' }}">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Pioneer Gym</title>

    <link rel="shortcut icon" href="{{ asset('gym-bg.jpg') }}" type="image/x-icon">
    <link href="https://fonts.googleapis.com/css2?family=Changa:wght@300;600;800&display=swap" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/animate.css/4.1.1/animate.min.css" rel="stylesheet">

    <style>
        body {
            margin: 0;
            font-family: "Changa", sans-serif;
            overflow: hidden;
        }

        /* خلفية الفيديو */
        .video-container {
            position: fixed;
            inset: 0;
            width: 100%;
            height: 100%;
            overflow: hidden;
            z-index: -2;
        }

        video {
            width: 100%;
            height: 100%;
            object-fit: cover;
            filter: brightness(60%);
        }

        /* الطبقة الشفافة */
        .overlay {
            position: fixed;
            inset: 0;
            background: rgba(0, 0, 0, 0.6);
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
            color: #fff;
            text-align: center;
            padding: 20px;
        }

        /* الشعار */
        .overlay img {
            width: 150px;
            border-radius: 50%;
            margin-bottom: 20px;
            box-shadow: 0 0 20px rgba(255, 255, 255, 0.3);
            animation: pulse 2.5s infinite;
        }

        /* العنوان */
        .overlay h1 {
            font-size: 2.5rem;
            font-weight: 800;
            line-height: 1.4;
            margin-bottom: 25px;
            text-shadow: 0 0 15px rgba(0, 0, 0, 0.5);
            animation: fadeInDown 1.2s ease;
        }

        /* الزر */
        .overlay a {
            padding: 14px 40px;
            font-size: 1.2rem;
            font-weight: 600;
            color: #fff;
            background: linear-gradient(45deg, #007bff, #00c6ff);
            border: none;
            border-radius: 8px;
            text-decoration: none;
            letter-spacing: 1px;
            transition: all 0.3s ease;
            box-shadow: 0 0 10px rgba(0, 198, 255, 0.5);
            animation: fadeInUp 1.4s ease;
        }

        .overlay a:hover {
            background: linear-gradient(45deg, #00c6ff, #007bff);
            transform: scale(1.05);
            box-shadow: 0 0 15px rgba(0, 198, 255, 0.8);
        }

        /* مبدّل اللغة */
        .language-switcher {
            position: fixed;
            top: 20px;
            {{ app()->getLocale() == 'ar' ? 'left' : 'right' }}: 20px;
            z-index: 10000;
        }

        .language-switcher img {
            width: 35px;
            height: 25px;
            border-radius: 6px;
            cursor: pointer;
            box-shadow: 0 0 10px rgba(255, 255, 255, 0.4);
            transition: transform 0.3s;
        }

        .language-switcher img:hover {
            transform: scale(1.1);
        }

        /* حركة نبض الشعار */
        @keyframes pulse {
            0% {
                transform: scale(1);
            }

            50% {
                transform: scale(1.05);
            }

            100% {
                transform: scale(1);
            }
        }

        @media (max-width: 768px) {
            .overlay h1 {
                font-size: 1.8rem;
            }

            .overlay a {
                font-size: 1rem;
                padding: 12px 30px;
            }
        }
    </style>
</head>

<body>

    <!-- 🌍 Language Switcher -->
    @php
        $currentLocale = LaravelLocalization::getCurrentLocale();
        $newLocale = $currentLocale === 'en' ? 'ar' : 'en';
        $currentUrl = request()->path();

        if (str_contains($currentUrl, 'admin/login')) {
            $localizedUrl = LaravelLocalization::getLocalizedURL($newLocale, '/admin/login');
        } else {
            $localizedUrl = LaravelLocalization::getLocalizedURL($newLocale, '/');
        }
    @endphp

    <div class="language-switcher">
        <a href="{{ $localizedUrl }}">
            @if ($currentLocale === 'en')
                <img src="{{ asset('flags/ar_flag.jpg') }}" alt="العربية">
            @else
                <img src="{{ asset('flags/en_flag.jpg') }}" alt="English">
            @endif
        </a>
    </div>

    <!-- 🎥 خلفية فيديو -->
    <div class="video-container">
        <video autoplay muted loop playsinline>
            <source src="{{ asset('gym.mp4') }}" type="video/mp4">
        </video>
    </div>

    
    <!-- 🌟 المحتوى -->
    <div class="overlay">
        <img src="{{ asset('gym-bg.jpg') }}" alt="Logo">
        <h1 class="animate__animated animate__fadeInDown">
            {{ app()->getLocale() == 'ar' ? 'ابدأ رحلتك نحو اللياقة والقوة' : 'Start Your Fitness & Strength Journey' }}
        </h1>
        <a href="{{ route('admin.loginForm') }}" class="animate__animated animate__fadeInUp">
            {{ __('messages.Enter') }}
        </a>
    </div>

</body>

</html>
