<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\AdminAuthController;
use App\Http\Controllers\Api\Student\CartController;
use App\Http\Controllers\Api\Student\GradeController;
use App\Http\Controllers\Api\Student\CountryController;
use App\Http\Controllers\Api\Student\StudentAuthController;
use Mcamara\LaravelLocalization\Facades\LaravelLocalization;

Route::group([
    'prefix' => '{lang}',            // ar أو en
    'middleware' => ['checkLang']    // يقوم بتعيين اللغة بناءً على {lang}
], function () {

    Route::prefix('student')->group(function () {

        Route::post('/login', [StudentAuthController::class, 'login']);
        Route::post('/register', [StudentAuthController::class, 'register']);

        Route::get('/getCountries', [CountryController::class, 'getCountries']);
        Route::get('/getStates', [CountryController::class, 'getStates']);
        Route::get('/getCities', [CountryController::class, 'getCities']);
        Route::get('/getState/{id}', [CountryController::class, 'getState']);
        Route::get('/getCity/{id}', [CountryController::class, 'getCity']);
        Route::get('/getHeards', [CountryController::class, 'getHeards']);
        Route::get('/getGrades', [GradeController::class, 'getGrades']);
        Route::get('/classrooms/by-grade/{grade_id}', [GradeController::class, 'getByGrade']);



        // auth routes 
        Route::middleware('auth:student')->group(function () {
            Route::get('/student_home', [StudentAuthController::class, 'studentHome']);
            Route::post('/logout', [StudentAuthController::class, 'logout']);
            Route::post('/add_cart', [CartController::class, 'addToCart']);
            Route::get('/getCart', [CartController::class, 'getCart']);
            Route::delete('/removeFromCart/{id}', [CartController::class, 'removeFromCart']);
            Route::post('/cart/pay', [CartController::class, 'payCart']);
        });
    });
});