<!DOCTYPE html>
<html lang="<?php echo e(app()->getLocale()); ?>" dir="<?php echo e(app()->getLocale() == 'ar' ? 'rtl' : 'ltr'); ?>">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Pioneer Gym | <?php echo e(__('messages.login')); ?></title>

    <link rel="icon" href="<?php echo e(asset('assets/images/login/icon.png')); ?>" type="image/x-icon">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;500;700&display=swap" rel="stylesheet">

    <style>
        body {
            background: linear-gradient(rgba(110, 110, 110, 0.7), rgba(119, 100, 100, 0.7)),
                url(<?php echo e(asset('assets/images/banner/1.jpg')); ?>) center center/cover no-repeat;
            font-family: 'Poppins', sans-serif;
            height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            color: #fff;
        }

        .login-box {
            background: rgba(255, 255, 255, 0.05);
            border: 1px solid rgba(255, 255, 255, 0.1);
            backdrop-filter: blur(10px);
            border-radius: 15px;
            padding: 40px 35px;
            width: 100%;
            max-width: 420px;
            box-shadow: 0 0 20px rgba(0, 0, 0, 0.4);
        }

        .login-box h3 {
            font-weight: 700;
            font-size: 28px;
            text-transform: uppercase;
            letter-spacing: 1px;
            margin-bottom: 25px;
            color: #23a2f6;
        }

        .form-control {
            background: rgba(255, 255, 255, 0.1);
            border: none;
            border-radius: 10px;
            color: #fff;
            font-size: 14px;
            padding: 12px;
        }

        .form-control:focus {
            box-shadow: 0 0 0 2px #23a2f6;
            background: rgba(255, 255, 255, 0.15);
        }

        .form-control::placeholder {
            color: #ccc;
        }

        .btn-login {
            background: #23a2f6;
            border: none;
            border-radius: 8px;
            padding: 10px 0;
            width: 100%;
            font-weight: 600;
            letter-spacing: 0.5px;
            color: #fff;
            transition: all 0.3s ease-in-out;
        }

        .btn-login:hover {
            background: #1d8ae5;
            transform: translateY(-2px);
        }

        .language-switcher {
            position: absolute;
            top: 20px;
            <?php echo e(app()->getLocale() == 'ar' ? 'left' : 'right'); ?>: 20px;
        }

        .language-switcher img {
            width: 35px;
            height: 25px;
            border-radius: 5px;
            cursor: pointer;
            transition: all 0.3s;
        }

        .language-switcher img:hover {
            transform: scale(1.1);
        }

        .brand-logo {
            width: 80px;
            margin-bottom: 15px;
        }

        .error-text {
            font-size: 12px;
            color: #ff4b5c;
            font-weight: 500;
            margin-top: 3px;
        }

        .footer-text {
            font-size: 12px;
            margin-top: 20px;
            color: #bbb;
        }

        @media (max-width: 600px) {
            .login-box {
                padding: 25px 20px;
            }
        }
    </style>
</head>

<body>

    <!-- 🌐 Language Switcher -->
    <div class="language-switcher">
        <?php
            use Mcamara\LaravelLocalization\Facades\LaravelLocalization;

            $currentLocale = LaravelLocalization::getCurrentLocale();
            $newLocale = $currentLocale === 'en' ? 'ar' : 'en';

            // نجيب المسار الحالي بدون بادئة اللغة
            $path = request()->path();
            $path = preg_replace('/^(ar|en)\//', '', $path);

            // لو الصفحة الحالية login، ثبّت المسار الصحيح
            if ($path === 'login' || $path === 'admin/login') {
                $localizedUrl = LaravelLocalization::getLocalizedURL($newLocale, '/admin/login');
            } else {
                $localizedUrl = LaravelLocalization::getLocalizedURL($newLocale, '/' . $path);
            }
        ?>

        <a href="<?php echo e($localizedUrl); ?>">
            <?php if($currentLocale === 'en'): ?>
                <img src="<?php echo e(asset('flags/ar_flag.jpg')); ?>" alt="العربية">
            <?php else: ?>
                <img src="<?php echo e(asset('flags/en_flag.jpg')); ?>" alt="English">
            <?php endif; ?>
        </a>
    </div>






    <!-- 🔒 Login Form -->
    <div class="login-box text-center">
        <img src="<?php echo e(asset('assets/images/login/icon.png')); ?>" alt="Logo" class="brand-logo">
        <h3><?php echo e(__('messages.login')); ?></h3>

        <form method="POST" action="<?php echo e(route('admin.login')); ?>">
            <?php echo csrf_field(); ?>

            <div class="mb-3 text-start">
                <label for="email" class="form-label"><?php echo e(__('messages.username')); ?></label>
                <input type="email" name="email" id="email" class="form-control"
                    placeholder="<?php echo e(__('messages.username')); ?>" required value="<?php echo e(old('email')); ?>">
                <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <div class="error-text"><?php echo e($message); ?></div>
                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </div>

            <div class="mb-3 text-start">
                <label for="password" class="form-label"><?php echo e(__('messages.password')); ?></label>
                <input type="password" name="password" id="password" class="form-control"
                    placeholder="<?php echo e(__('messages.password')); ?>" required>
                <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <div class="error-text"><?php echo e($message); ?></div>
                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </div>

            <button type="submit" class="btn btn-login">
                <i class="fa fa-sign-in-alt me-2"></i> <?php echo e(__('messages.login')); ?>

            </button>

            <p class="footer-text mt-3 mb-0">
                © <?php echo e(date('Y')); ?> Pioneer Gym — Elkady.all_rights_reserved
            </p>
        </form>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
</body>

</html>
<?php /**PATH E:\xampp\htdocs\Pioneer\resources\views/auth/login.blade.php ENDPATH**/ ?>