

<?php $__env->startSection('title', 'الأدوار'); ?>
<?php $__env->startSection('pages'); ?> <?php echo e(__('dashboard.home')); ?> <?php $__env->stopSection(); ?>

<?php $__env->startSection('css'); ?>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="container-fluid">
        <div class="d-flex align-items-center justify-content-between mb-3 flex-wrap gap-2">
            <h5 class="mb-0">إدارة الأدوار</h5>
            <button class="btn btn-primary" id="addRoleBtn"><i class="fas fa-plus mx-2"></i>إضافة دور</button>
        </div>

        <div class="card p-3 mb-3">
            <div class="row g-2">
                <div class="col-md-4">
                    <input type="text" id="f_name" class="form-control" placeholder="ابحث بالاسم...">
                </div>
                <div class="col-md-4 d-grid d-md-flex gap-2">
                    <button class="btn btn-secondary" id="f_reset">إعادة تعيين</button>
                </div>
            </div>
        </div>

        <div class="table-responsive">
            <table id="roles-table" class="table table-bordered text-center w-100">
                <thead>
                    <tr>
                        <th>#</th>
                        <th>اسم الدور</th>
                        <th>الصلاحيات</th>
                        <th>إجراءات</th>
                    </tr>
                </thead>
            </table>
        </div>
    </div>

    <!-- 🔽 Modal -->
    <div class="modal fade" id="roleModal" tabindex="-1">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <form id="roleForm">
                    <?php echo csrf_field(); ?>
                    <input type="hidden" id="role_id">
                    <div class="modal-header bg-primary text-white">
                        <h5 class="modal-title">إضافة / تعديل دور</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                    </div>
                    <div class="modal-body">
                        <div class="mb-3">
                            <label>اسم الدور</label>
                            <input type="text" id="role_name" class="form-control" required>
                        </div>

                        <hr>
                        <label class="mb-2">الصلاحيات:</label>
                        <div class="row">
                            <?php $__currentLoopData = $permissions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $perm): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="col-md-3 mb-2">
                                    <div class="form-check">
                                        <input type="checkbox" class="form-check-input perm-check"
                                            value="<?php echo e($perm->id); ?>" id="perm<?php echo e($perm->id); ?>">
                                        <label class="form-check-label"
                                            for="perm<?php echo e($perm->id); ?>"><?php echo e($perm->name); ?></label>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button class="btn btn-success" type="submit">حفظ</button>
                        <button class="btn btn-secondary" data-bs-dismiss="modal">إغلاق</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- Modal عرض الصلاحيات -->
    <div class="modal fade" id="permissionsModal" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog modal-lg modal-dialog-centered">
            <div class="modal-content shadow-lg">
                <div class="modal-header bg-primary text-white">
                    <h5 class="modal-title">صلاحيات الدور: <span id="roleName"></span></h5>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <div id="permissionsContainer" class="row g-2"></div>
                </div>
                <div class="modal-footer">
                    <button class="btn btn-secondary" data-bs-dismiss="modal">إغلاق</button>
                </div>
            </div>
        </div>
    </div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>

    <script>
        $(function() {
            // ✅ DataTable بدون أخطاء
            const table = $('#roles-table').DataTable({
                processing: true,
                serverSide: true,
                ajax: {
                    url: "<?php echo e(route('roles.list')); ?>",
                    data: d => {
                        d.name = $('#f_name').val();
                    }
                },
                language: <?php echo json_encode(__('datatable')); ?>,
                columns: [{
                        data: 'DT_RowIndex',
                        name: 'DT_RowIndex',
                        orderable: false,
                        searchable: false,
                        defaultContent: ''
                    },
                    {
                        data: 'name',
                        name: 'name'
                    },
                    {
                        data: 'permissions',
                        name: 'permissions',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'actions',
                        orderable: false,
                        searchable: false
                    },
                ]
            });

            $(document).on('mouseenter', '[data-bs-toggle="tooltip"]', function() {
                const tooltip = new bootstrap.Tooltip(this);
                tooltip.show();
            });


            // ✅ الفلاتر
            $('#f_name').on('keyup', () => table.ajax.reload());
            $('#f_reset').on('click', () => {
                $('#f_name').val('');
                table.ajax.reload();
            });

            // ✅ المودال
            let modal = new bootstrap.Modal($('#roleModal')[0]);
            $('#addRoleBtn').click(() => {
                $('#roleForm')[0].reset();
                $('#role_id').val('');
                $('.perm-check').prop('checked', false);
                modal.show();
            });

            // ✅ حفظ (إضافة / تعديل)
            $('#roleForm').submit(function(e) {
                e.preventDefault();

                const id = $('#role_id').val();
                const url = id ? `/roles/${id}` : `/roles`;
                const method = id ? 'POST' : 'POST'; // ✅ POST فقط (هنرسل _method=PUT لو تعديل)
                const perms = [];

                $('.perm-check:checked').each(function() {
                    perms.push($(this).val());
                });

                const payload = {
                    name: $('#role_name').val(),
                    permissions: perms,
                    _method: id ? 'PUT' : 'POST', // ✅ Laravel هيعرف إنها تحديث
                    _token: '<?php echo e(csrf_token()); ?>'
                };

                $.ajax({
                    url,
                    method,
                    data: payload,
                    success: function() {
                        $('#roleModal').modal('hide');
                        $('#roles-table').DataTable().ajax.reload();
                        toastr.success('تم حفظ الدور بنجاح');
                    },
                    error: function(xhr) {
                        toastr.error('حدث خطأ أثناء الحفظ');
                        console.error(xhr.responseText);
                    }
                });
            });


            // ✅ تعديل
            $(document).on('click', '.editRole', function() {
                let id = $(this).data('id');
                fetch(`/roles/${id}/edit`)
                    .then(r => r.json())
                    .then(d => {
                        $('#role_id').val(d.role.id);
                        $('#role_name').val(d.role.name);
                        $('.perm-check').prop('checked', false);
                        d.permissions.forEach(pid => $(`#perm${pid}`).prop('checked', true));
                        modal.show();
                    });
            });

            // ✅ حذف
            $(document).on('click', '.deleteRole', function() {
                if (!confirm('هل تريد حذف هذا الدور؟')) return;
                let id = $(this).data('id');
                fetch(`/roles/${id}`, {
                        method: 'DELETE',
                        headers: {
                            'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>'
                        }
                    })
                    .then(() => {
                        table.ajax.reload();
                        toastr.warning('تم الحذف بنجاح');
                    });
            });
        });

        // ✅ عند الضغط على زر "عرض الصلاحيات"
        $(document).on('click', '.viewPerms', function() {
            const roleId = $(this).data('role');
            const roleName = $(this).data('name');
            $('#roleName').text(roleName);
            const container = $('#permissionsContainer');
            container.empty();

            fetch(`/roles/${roleId}/edit`)
                .then(r => r.json())
                .then(d => {
                    const perms = d.permissions_details ?? d.permissions ?? [];

                    if (!perms.length) {
                        container.html(
                            '<div class="text-center text-muted py-4">لا توجد صلاحيات لهذا الدور</div>');
                        new bootstrap.Modal(document.getElementById('permissionsModal')).show();
                        return;
                    }

                    perms.forEach(p => {
                        let color = 'secondary';
                        if (p.name.includes('user')) color = 'info';
                        else if (p.name.includes('role')) color = 'warning';
                        else if (p.name.includes('branch')) color = 'primary';
                        else if (p.name.includes('report')) color = 'danger';
                        else color = 'success';

                        container.append(`
                    <div class="col-md-3 col-sm-4 col-6">
                        <div class=" p-2 text-center ">
                            <span class="badge bg-${color} text-white w-100 py-2 shadow-sm">
                                <i class="fas fa-lock me-1"></i> ${p.name}
                            </span>
                        </div>
                    </div>
                `);
                    });

                    new bootstrap.Modal(document.getElementById('permissionsModal')).show();
                })
                .catch(() => toastr.error('تعذر تحميل الصلاحيات'));
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\xampp\htdocs\Pioneer\resources\views/roles/index.blade.php ENDPATH**/ ?>