

<?php
    $isEdit = isset($customer);
    $action = $isEdit ? route('customers.update', $customer) : route('customers.store');
    $method = $isEdit ? 'PUT' : 'POST';
?>

<?php $__env->startSection('title', $isEdit ? 'تعديل عميل' : 'إضافة عميل'); ?>
<?php $__env->startSection('pages'); ?> <?php echo e(__('dashboard.home')); ?> <?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="container-fluid">
        <?php if($errors->any()): ?>
            <div class="alert alert-danger">
                <ul class="mb-0">
                    <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $e): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li><?php echo e($e); ?></li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </ul>
            </div>
        <?php endif; ?>

        <form action="<?php echo e($action); ?>" method="POST">
            <?php echo csrf_field(); ?> <?php if($isEdit): ?>
                <?php echo method_field('PUT'); ?>
            <?php endif; ?>

            <div class="d-flex align-items-center justify-content-between mb-3 flex-wrap gap-2">
                <h5 class="mb-0"><?php echo e($isEdit ? 'تعديل عميل' : 'إضافة عميل'); ?></h5>
                <div class="d-flex gap-2">
                    <button class="btn btn-primary"><i class="fas fa-save mx-2"></i><?php echo e($isEdit ? 'تحديث' : 'حفظ'); ?></button>
                    <a href="<?php echo e(route('customers.index')); ?>" class="btn btn-secondary">رجوع</a>
                </div>
            </div>

            <div class="card p-3">
                <div class="row g-3">

                    <div class="col-md-12">
                        <?php if($userBranchId && $userBranch): ?>
                            
                            <div class="alert d-flex justify-content-between align-items-center">
                                <div>
                                    <strong>🔸  الفرع الحالي : </strong>
                                    <?php echo e(is_array($userBranch->name)
                                        ? $userBranch->name[app()->getLocale()] ?? ($userBranch->name['en'] ?? '')
                                        : (method_exists($userBranch, 'getTranslation')
                                            ? $userBranch->getTranslation('name', app()->getLocale())
                                            : $userBranch->name)); ?>

                                    <span class="text-muted">(<?php echo e($userBranch->branch_code); ?>)</span>
                                </div>
                                <input type="hidden" name="branch_id" id="branch_id" value="<?php echo e($userBranch->id); ?>">
                            </div>
                        <?php else: ?>
                            
                            <div class="col-md-12">
                                <label class="form-label">الفرع <span class="text-danger">*</span></label>
                                <select name="branch_id" id="branch_id" class="form-select" required>
                                    <option value="">— اختر —</option>
                                    <?php $__currentLoopData = $branches; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $b): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($b->id); ?>" <?php if((int) old('branch_id', $isEdit ? $customer->branch_id : null) === (int) $b->id): echo 'selected'; endif; ?>>
                                            <?php echo e(method_exists($b, 'getTranslation')
                                                ? $b->getTranslation('name', app()->getLocale())
                                                : (is_array($b->name)
                                                    ? $b->name[app()->getLocale()] ?? ($b->name['en'] ?? '')
                                                    : $b->name)); ?>

                                        </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                        <?php endif; ?>
                    </div>


                    <div class="col-md-6">
                        <label class="form-label">كود العميل</label>
                        <input type="text" id="code_preview" class="form-control"
                            value="<?php echo e($isEdit ? $customer->customer_code : '— جاري توليد الكود —'); ?>" readonly>
                        
                    </div>


                    <div class="col-md-6">
                        <label class="form-label">اسم العميل <span class="text-danger">*</span></label>
                        <input type="text" name="name" class="form-control"
                            value="<?php echo e(old('name', $isEdit ? $customer->name : '')); ?>" required>
                    </div>

                </div>
            </div>
        </form>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const branchSel = document.getElementById('branch_id');
            const codePrev = document.getElementById('code_preview');

            function loadPreview() {
                const bid = branchSel?.value;
                if (!bid) {
                    codePrev.value = '— حدّد الفرع لعرض الكود المقترح —';
                    return;
                }

                fetch(`<?php echo e(route('customers.predict')); ?>?branch_id=${bid}`)
                    .then(r => r.json())
                    .then(res => codePrev.value = res.code || '—')
                    .catch(() => codePrev.value = '—');
            }

            // ✅ الحالة 1: المستخدم له فرع (مخفي من الاختيار)
            if (branchSel && branchSel.tagName === 'INPUT') {
                loadPreview(); // توليد الكود فورًا
            }

            // ✅ الحالة 2: المستخدم يختار يدويًا (السوبر أدمن)
            if (branchSel && branchSel.tagName === 'SELECT') {
                branchSel.addEventListener('change', loadPreview);
            }
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\xampp\htdocs\Pioneer\resources\views/admin/customers/form.blade.php ENDPATH**/ ?>