<?php $__env->startSection('title', __('dashboard.dashboard')); ?>
<?php $__env->startSection('pages', __('dashboard.home')); ?>

<?php $__env->startSection('css'); ?>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/animate.css/4.1.1/animate.min.css" />
    <style>
        .welcome-box {
            background: linear-gradient(135deg, #2f2f30, #1f1f1f);
            color: #fff;
            border-radius: 12px;
            padding: 30px 25px;
            box-shadow: 0 4px 15px rgba(0, 123, 255, 0.1);
        }

        .welcome-box h4 {
            font-weight: 700;
            font-size: 1.6rem;
        }

        .stats-card {
            background: #fff;
            border-radius: 12px;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.05);
            padding: 25px;
            transition: 0.3s;
        }

        .stats-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 4px 18px rgba(0, 0, 0, 0.1);
        }

        .stats-icon {
            font-size: 2.5rem;
            opacity: 0.8;
        }

        .stats-title {
            font-size: 0.9rem;
            color: #888;
        }

        .stats-number {
            font-size: 1.8rem;
            font-weight: 700;
            color: #333;
        }

        .section-title {
            font-weight: 600;
            font-size: 1.2rem;
            margin-bottom: 15px;
            color: #555;
        }

        .chart-card {
            background: #fff;
            border-radius: 12px;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.05);
            padding: 25px;
        }

        @media (max-width: 768px) {
            .stats-card {
                text-align: center;
            }
        }
    </style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="container-fluid py-3">
        <!-- 🔷 الترحيب -->
        <div class="welcome-box mb-4 animate__animated animate__fadeInDown">
            <h4>👋 <?php echo e(__('messages.hello')); ?> <?php echo e(auth()->user()->name ?? ''); ?></h4>
            <p class="mb-0">مرحبًا بك في نظام إدارة <strong>Pioneer Gym</strong> — تابع أدناه أهم الإحصائيات والأنشطة.</p>
        </div>

        <!-- 🔹 الإحصائيات -->
        <div class="row g-3 mb-4">
            <div class="col-md-6 col-lg-3">
                <div class="stats-card text-center">
                    <div class="stats-icon text-primary mb-2"><i class="fa-solid fa-users"></i></div>
                    <div class="stats-title">عدد العملاء</div>
                    <div class="stats-number"><?php echo e(\App\Models\Customer::count()); ?></div>
                </div>
            </div>

            <div class="col-md-6 col-lg-3">
                <div class="stats-card text-center">
                    <div class="stats-icon text-success mb-2"><i class="fa-solid fa-dumbbell"></i></div>
                    <div class="stats-title">عدد الأعضاء</div>
                    <div class="stats-number"><?php echo e(\App\Models\Member::count()); ?></div>
                </div>
            </div>

            <div class="col-md-6 col-lg-3">
                <div class="stats-card text-center">
                    <div class="stats-icon text-warning mb-2"><i class="fa-solid fa-building"></i></div>
                    <div class="stats-title">عدد الفروع</div>
                    <div class="stats-number"><?php echo e(\App\Models\Branch::count()); ?></div>
                </div>
            </div>

            <div class="col-md-6 col-lg-3">
                <div class="stats-card text-center">
                    <div class="stats-icon text-danger mb-2"><i class="fa-solid fa-tags"></i></div>
                    <div class="stats-title">عدد العروض</div>
                    <div class="stats-number"><?php echo e(\App\Models\Offer::count()); ?></div>
                </div>
            </div>
        </div>

        <!-- 🔹 الرسوم البيانية -->
        <div class="row g-3">
            <div class="col-md-8">
                <div class="chart-card">
                    <h6 class="section-title mb-3">نمو الأعضاء خلال الأشهر</h6>
                    <canvas id="membersChart" height="130"></canvas>
                </div>
            </div>
            <div class="col-md-4">
                <div class="chart-card">
                    <h6 class="section-title mb-3">نسبة الخدمات</h6>
                    <canvas id="servicesChart" height="220"></canvas>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <script>
        // 🔹 مخطط الأعضاء
        const membersCtx = document.getElementById('membersChart');
        new Chart(membersCtx, {
            type: 'line',
            data: {
                labels: ['يناير', 'فبراير', 'مارس', 'أبريل', 'مايو', 'يونيو', 'يوليو'],
                datasets: [{
                    label: 'عدد الأعضاء',
                    data: [120, 180, 200, 260, 300, 270, 340],
                    borderColor: '#007bff',
                    backgroundColor: 'rgba(0,123,255,0.1)',
                    fill: true,
                    tension: 0.3
                }]
            },
            options: {
                plugins: {
                    legend: {
                        display: false
                    }
                },
                scales: {
                    y: {
                        beginAtZero: true
                    }
                }
            }
        });

        // 🔹 مخطط الخدمات
        const servicesCtx = document.getElementById('servicesChart');
        new Chart(servicesCtx, {
            type: 'doughnut',
            data: {
                labels: ['لياقة', 'تغذية', 'عروض خاصة', 'معدات'],
                datasets: [{
                    data: [45, 20, 25, 10],
                    backgroundColor: ['#007bff', '#28a745', '#ffc107', '#dc3545'],
                    hoverOffset: 5
                }]
            },
            options: {
                plugins: {
                    legend: {
                        position: 'bottom'
                    }
                }
            }
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\xampp\htdocs\Pioneer\resources\views/admin/dashboard.blade.php ENDPATH**/ ?>