

<?php $__env->startSection('title', 'المستخدمين'); ?>
<?php $__env->startSection('pages'); ?> <?php echo e(__('dashboard.home')); ?> <?php $__env->stopSection(); ?>

<?php $__env->startSection('css'); ?>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="container-fluid">
        <div class="d-flex align-items-center justify-content-between mb-3 flex-wrap gap-2">
            <h5 class="mb-0">إدارة المستخدمين</h5>
            <button class="btn btn-primary" id="addUserBtn"><i class="fas fa-plus mx-2"></i>إضافة مستخدم</button>
        </div>

        <div class="card p-3 mb-3">
            <div class="row g-2">
                <div class="col-md-4">
                    <input type="text" id="f_name" class="form-control" placeholder="ابحث بالاسم...">
                </div>
                <div class="col-md-4">
                    <select id="f_branch" class="form-select">
                        <option value="">— كل الفروع —</option>
                        <?php $__currentLoopData = $branches; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $b): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($b->id); ?>"><?php echo e($b->name); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
                <div class="col-md-4 d-grid d-md-flex gap-2">
                    <button class="btn btn-secondary" id="f_reset">إعادة تعيين</button>
                </div>
            </div>
        </div>

        <div class="table-responsive">
            <table id="users-table" class="table table-bordered text-center w-100">
                <thead>
                    <tr>
                        <th>#</th>
                        <th>الاسم</th>
                        <th>البريد</th>
                        <th>الفرع</th>
                        <th>الأدوار</th>
                        <th>إجراءات</th>
                    </tr>
                </thead>
            </table>
        </div>
    </div>

    <!-- 🔽 Modal -->
    <div class="modal fade" id="userModal" tabindex="-1">
        <div class="modal-dialog ">
            <div class="modal-content">
                <form id="userForm">
                    <?php echo csrf_field(); ?>
                    <input type="hidden" id="user_id">
                    <div class="modal-header ">
                        <h5 class="modal-title">إضافة / تعديل مستخدم</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                    </div>
                    <div class="modal-body">
                        <div class="row mb-3">
                            <div class="col-md-12 mb-3">
                                <label>الاسم</label>
                                <input type="text" id="user_name" class="form-control" required>
                            </div>
                            <div class="col-md-12 mb-3">
                                <label>البريد الإلكتروني</label>
                                <input type="email" id="user_email" class="form-control" required>
                            </div>
                        </div>

                        <div class="row mb-3">
                            <div class="col-md-12 mb-3">
                                <label>كلمة المرور</label>
                                <input type="password" id="user_password" class="form-control">
                            </div>
                            <div class="col-md-12 mb-3">
                                <label>الفرع</label>
                                <select id="user_branch" class="form-select">
                                    <option value="">اختر الفرع</option>
                                    <?php $__currentLoopData = $branches; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $branch): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($branch->id); ?>"><?php echo e($branch->name); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                        </div>

                        <hr>
                        <label>الأدوار</label>
                        <div class="row">
                            <?php $__currentLoopData = $roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $role): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="col-md-3">
                                    <div class="form-check">
                                        <input type="checkbox" class="form-check-input role-check"
                                            value="<?php echo e($role->id); ?>" id="role<?php echo e($role->id); ?>">
                                        <label class="form-check-label"
                                            for="role<?php echo e($role->id); ?>"><?php echo e($role->name); ?></label>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button class="btn btn-success" type="submit">حفظ</button>
                        <button class="btn btn-secondary" data-bs-dismiss="modal">إغلاق</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>
    <script>
        $(function() {
            let table = $('#users-table').DataTable({
                processing: true,
                serverSide: true,
                ajax: {
                    url: "<?php echo e(route('users.list')); ?>",
                    data: d => {
                        d.name = $('#f_name').val();
                        d.branch_id = $('#f_branch').val();
                    }
                },
                language: <?php echo json_encode(__('datatable')); ?>,
                columns: [{
                        data: 'DT_RowIndex',
                        orderable: false,
                        searchable: false,
                        defaultContent: ''
                    },
                    {
                        data: 'name',
                        name: 'name'
                    },
                    {
                        data: 'email',
                        name: 'email'
                    },
                    {
                        data: 'branch',
                        name: 'branch.name'
                    },
                    {
                        data: 'roles',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'actions',
                        orderable: false,
                        searchable: false
                    },
                ]

            });

            $('#f_name,#f_branch').on('change keyup', () => table.ajax.reload());
            $('#f_reset').on('click', () => {
                $('#f_name').val('');
                $('#f_branch').val('');
                table.ajax.reload();
            });

            let modal = new bootstrap.Modal($('#userModal')[0]);

            $('#addUserBtn').click(() => {
                $('#userForm')[0].reset();
                $('#user_id').val('');
                $('.role-check').prop('checked', false);
                modal.show();
            });

            $('#userForm').submit(function(e) {
                e.preventDefault();
                let id = $('#user_id').val();
                let url = id ? `/users/${id}` : `/users`;
                let method = id ? 'PUT' : 'POST';
                let roles = [];
                $('.role-check:checked').each(function() {
                    roles.push($(this).val());
                });

                fetch(url, {
                    method,
                    headers: {
                        'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>',
                        'Content-Type': 'application/json'
                    },
                    body: JSON.stringify({
                        name: $('#user_name').val(),
                        email: $('#user_email').val(),
                        password: $('#user_password').val(),
                        branch_id: $('#user_branch').val(),
                        roles: roles
                    })
                }).then(() => {
                    modal.hide();
                    table.ajax.reload();
                    toastr.success('تم الحفظ بنجاح');
                });
            });

            $(document).on('click', '.editUser', function() {
                let id = $(this).data('id');
                fetch(`/users/${id}/edit`).then(r => r.json()).then(d => {
                    $('#user_id').val(d.user.id);
                    $('#user_name').val(d.user.name);
                    $('#user_email').val(d.user.email);
                    $('#user_branch').val(d.user.branch_id);
                    $('.role-check').prop('checked', false);
                    d.roles.forEach(rid => $('#role' + rid).prop('checked', true));
                    modal.show();
                });
            });

            $(document).on('click', '.deleteUser', function() {
                if (!confirm('هل تريد حذف المستخدم؟')) return;
                let id = $(this).data('id');
                fetch(`/users/${id}`, {
                        method: 'DELETE',
                        headers: {
                            'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>'
                        }
                    })
                    .then(() => {
                        table.ajax.reload();
                        toastr.warning('تم حذف المستخدم بنجاح');
                    });
            });
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\xampp\htdocs\Pioneer\resources\views/users/index.blade.php ENDPATH**/ ?>