<aside class="page-sidebar bg-dark text-white shadow-lg position-fixed h-100" id="sidebar">


    <nav class="sidebar-menu mt-3">
        <ul class="list-unstyled px-2">

            <!-- Dashboard -->
            <li class="mb-2">
                <a href="<?php echo e(route('admin.dashboard')); ?>"
                    class="d-flex align-items-center gap-3 text-white text-decoration-none py-2 px-3 rounded hover-item">
                    <i class="fa-solid fa-gauge-high fa-lg text-info"></i>
                    <span><?php echo e(__('dashboard.dashboard')); ?></span>
                </a>
            </li>

            <!-- Settings -->
            <li class="mb-2">
                <a href="<?php echo e(route('settings.company.edit')); ?>"
                    class="d-flex align-items-center gap-3 text-white text-decoration-none py-2 px-3 rounded hover-item">
                    <i class="fa-solid fa-gear fa-lg text-warning"></i>
                    <span>الإعدادات العامة</span>
                </a>
            </li>

            <hr class="border-secondary my-2">

            <!-- Branches -->
            <li class="menu-group">
                <button
                    class="btn w-100 text-start text-white d-flex align-items-center gap-3 py-2 px-3 toggle-submenu">
                    <i class="fa-solid fa-building fa-lg text-success"></i>
                    <span>الفروع</span>
                    <i class="fa-solid fa-angle-down me-auto"></i>
                </button>
                <ul class="submenu list-unstyled ms-4 mt-1">
                    <li><a href="<?php echo e(route('branch-categories.index')); ?>" class="submenu-item"> فئات الفروع </a></li>
                    <li><a href="<?php echo e(route('branch-types.index')); ?>" class="submenu-item">أنواع الفروع</a></li>
                    <li><a href="<?php echo e(route('branches.index')); ?>" class="submenu-item">الفروع</a></li>
                </ul>
            </li>

            <!-- Services -->
            <li class="menu-group">
                <button
                    class="btn w-100 text-start text-white d-flex align-items-center gap-3 py-2 px-3 toggle-submenu">
                    <i class="fa-solid fa-dumbbell fa-lg text-primary"></i>
                    <span>الخدمات</span>
                    <i class="fa-solid fa-angle-down me-auto"></i>
                </button>
                <ul class="submenu list-unstyled ms-4 mt-1">
                    <li><a href="<?php echo e(route('service-types.index')); ?>" class="submenu-item">أنواع الخدمات</a></li>
                    <li><a href="<?php echo e(route('service-categories.index')); ?>" class="submenu-item">فئات الخدمات</a></li>
                    <li><a href="<?php echo e(route('services.index')); ?>" class="submenu-item">الخدمات</a></li>
                </ul>
            </li>

            <!-- Customers -->
            <li class="menu-group">
                <button
                    class="btn w-100 text-start text-white d-flex align-items-center gap-3 py-2 px-3 toggle-submenu">
                    <i class="fa-solid fa-user-group fa-lg text-info"></i>
                    <span>العملاء</span>
                    <i class="fas fa-angle-down me-auto"></i>
                </button>
                <ul class="submenu list-unstyled ms-4 mt-1">
                    <li><a href="<?php echo e(route('customers.index')); ?>" class="submenu-item">قائمة العملاء</a></li>
                    <li><a href="<?php echo e(route('customers.create')); ?>" class="submenu-item">إضافة عميل</a></li>
                </ul>
            </li>

            <!-- Members -->
            <li class="menu-group">
                <button
                    class="btn w-100 text-start text-white d-flex align-items-center gap-3 py-2 px-3 toggle-submenu">
                    <i class="fas fa-users fa-lg text-success"></i>
                    <span>الأعضاء</span>
                    <i class="fas fa-angle-down me-auto"></i>
                </button>
                <ul class="submenu list-unstyled ms-4 mt-1">
                    <li><a href="<?php echo e(route('members.index')); ?>" class="submenu-item">قائمة الأعضاء</a></li>
                    <li><a href="<?php echo e(route('members.create')); ?>" class="submenu-item">إضافة عضو</a></li>
                </ul>
            </li>

            <!-- Offers -->
            <li class="menu-group">
                <button
                    class="btn w-100 text-start text-white d-flex align-items-center gap-3 py-2 px-3 toggle-submenu">
                    <i class="fa-solid fa-tags fa-lg text-danger"></i>
                    <span>العروض</span>
                    <i class="fa-solid fa-angle-down me-auto"></i>
                </button>
                <ul class="submenu list-unstyled ms-4 mt-1">
                    <li><a href="<?php echo e(route('offers.index')); ?>" class="submenu-item">قائمة العروض</a></li>
                    <li><a href="<?php echo e(route('offers.create')); ?>" class="submenu-item">إضافة عرض</a></li>
                </ul>
            </li>

            <!-- Users -->
            <li class="menu-group">
                <button
                    class="btn w-100 text-start text-white d-flex align-items-center gap-3 py-2 px-3 toggle-submenu">
                    <i class="fa-solid fa-user-shield fa-lg text-warning"></i>
                    <span>المستخدمين والصلاحيات</span>
                    <i class="fa-solid fa-angle-down me-auto"></i>
                </button>
                <ul class="submenu list-unstyled ms-4 mt-1">
                    <li><a href="<?php echo e(route('roles.index')); ?>" class="submenu-item">الأدوار والصلاحيات</a></li>
                    <li><a href="<?php echo e(route('users.index')); ?>" class="submenu-item">قائمة المستخدمين</a></li>
                </ul>
            </li>

        </ul>
    </nav>
</aside>

<style>
    /* Sidebar Base */
    .sidebar {
        width: 270px;
        transition: all 0.3s ease;
        overflow-y: auto;
        z-index: 1000;
    }

    .sidebar.collapsed {
        width: 80px;
    }

    .hover-item:hover {
        background: rgba(255, 255, 255, 0.1);
        transition: 0.3s;
    }

    /* Submenu */
    .submenu {
        display: none;
        padding-right: 5px;
        transition: all 0.3s ease;
    }

    .submenu-item {
        display: block;
        color: #bbb;
        padding: 6px 10px;
        text-decoration: none;
        border-radius: 6px;
        font-size: 14px;
    }

    .submenu-item:hover {
        background: rgba(255, 255, 255, 0.1);
        color: #fff;
    }

    .menu-group.open>.submenu {
        display: block;
        animation: fadeIn 0.3s;
    }

    @keyframes fadeIn {
        from {
            opacity: 0;
            transform: translateY(-10px);
        }

        to {
            opacity: 1;
            transform: translateY(0);
        }
    }
</style>

<script>
    document.addEventListener('DOMContentLoaded', function() {
        // Toggle submenus
        document.querySelectorAll('.toggle-submenu').forEach(btn => {
            btn.addEventListener('click', function() {
                const parent = this.closest('.menu-group');
                parent.classList.toggle('open');
                this.querySelector('i.fa-angle-down').classList.toggle('fa-rotate-180');
            });
        });

        // Collapse sidebar
        document.getElementById('toggleSidebar').addEventListener('click', () => {
            document.getElementById('sidebar').classList.toggle('collapsed');
        });
    });
</script>
<?php /**PATH E:\xampp\htdocs\Pioneer\resources\views/layouts/sidebar.blade.php ENDPATH**/ ?>