-- phpMyAdmin SQL Dump
-- version 5.2.1
-- https://www.phpmyadmin.net/
--
-- Host: 127.0.0.1
-- Generation Time: Oct 21, 2025 at 07:18 AM
-- Server version: 10.4.28-MariaDB
-- PHP Version: 8.2.12

SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
START TRANSACTION;
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;

--
-- Database: `pioneer`
--

-- --------------------------------------------------------

--
-- Table structure for table `branches`
--

CREATE TABLE `branches` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `branch_code` varchar(10) NOT NULL,
  `name` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL CHECK (json_valid(`name`)),
  `branch_category_id` bigint(20) UNSIGNED NOT NULL,
  `branch_type_id` bigint(20) UNSIGNED NOT NULL,
  `city_id` bigint(20) UNSIGNED NOT NULL,
  `primary_phone` varchar(255) NOT NULL,
  `phones` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`phones`)),
  `active` tinyint(1) NOT NULL DEFAULT 1,
  `address` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`address`)),
  `min_age` tinyint(3) UNSIGNED DEFAULT NULL,
  `max_discount_percent` decimal(5,2) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `branches`
--

INSERT INTO `branches` (`id`, `branch_code`, `name`, `branch_category_id`, `branch_type_id`, `city_id`, `primary_phone`, `phones`, `active`, `address`, `min_age`, `max_discount_percent`, `created_at`, `updated_at`) VALUES
(1, 'MAIN001', '{\"ar\":\"المركز الرئيسي\",\"en\":\"Main Center\"}', 3, 1, 1, '0500000000', '[{\"label\":{\"ar\":\"الاستقبال\",\"en\":\"Reception\"},\"number\":\"0501111111\"},{\"label\":{\"ar\":\"المدربون\",\"en\":\"Coaches\"},\"number\":\"0502222222\"}]', 1, '{\"street\":{\"ar\":\"شارع العليا\",\"en\":\"Olaya Street\"},\"district\":{\"ar\":\"الملز\",\"en\":\"Al Malaz\"},\"building_no\":\"12B\",\"postal_code\":\"11564\"}', 15, 30.00, '2025-10-19 04:46:25', '2025-10-19 04:46:25'),
(2, 'SUB002', '{\"ar\":\"فرع جدة\",\"en\":\"Jeddah Branch\"}', 2, 2, 2, '0550000000', '[{\"label\":{\"ar\":\"المبيعات\",\"en\":\"Sales\"},\"number\":\"0551111111\"}]', 1, '{\"street\":{\"ar\":\"طريق المدينة\",\"en\":\"Madinah Road\"},\"district\":{\"ar\":\"السلامة\",\"en\":\"Al Salama\"},\"building_no\":\"22A\",\"postal_code\":\"21423\"}', 16, 20.00, '2025-10-19 04:46:25', '2025-10-19 04:46:25'),
(3, 'FR003', '{\"ar\":\"فرع الدمام\",\"en\":\"Dammam Branch\"}', 1, 3, 3, '0560000000', '[{\"label\":{\"ar\":\"الاستقبال\",\"en\":\"Reception\"},\"number\":\"0561234567\"}]', 1, '{\"street\":{\"ar\":\"شارع الخليج\",\"en\":\"Khaleej Street\"},\"district\":{\"ar\":\"الروضة\",\"en\":\"Al Rawda\"},\"building_no\":\"8C\",\"postal_code\":\"31952\"}', 14, 25.00, '2025-10-19 04:46:25', '2025-10-19 04:46:25');

-- --------------------------------------------------------

--
-- Table structure for table `branch_categories`
--

CREATE TABLE `branch_categories` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `name` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL CHECK (json_valid(`name`)),
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `branch_categories`
--

INSERT INTO `branch_categories` (`id`, `name`, `created_at`, `updated_at`) VALUES
(1, '{\"ar\":\"نادي نسائي\",\"en\":\"Women Gym\"}', '2025-10-19 04:46:25', '2025-10-19 04:46:25'),
(2, '{\"ar\":\"نادي رجالي\",\"en\":\"Men Gym\"}', '2025-10-19 04:46:25', '2025-10-19 04:46:25'),
(3, '{\"ar\":\"نادي عائلي\",\"en\":\"Family Gym\"}', '2025-10-19 04:46:25', '2025-10-19 04:46:25');

-- --------------------------------------------------------

--
-- Table structure for table `branch_monthly_goals`
--

CREATE TABLE `branch_monthly_goals` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `branch_id` bigint(20) UNSIGNED NOT NULL,
  `year` smallint(6) NOT NULL,
  `month` tinyint(4) NOT NULL,
  `actual` decimal(12,2) NOT NULL DEFAULT 0.00,
  `target` decimal(12,2) NOT NULL DEFAULT 0.00,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `branch_service_provided`
--

CREATE TABLE `branch_service_provided` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `service_id` bigint(20) UNSIGNED NOT NULL,
  `branch_id` bigint(20) UNSIGNED NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `branch_service_sold`
--

CREATE TABLE `branch_service_sold` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `service_id` bigint(20) UNSIGNED NOT NULL,
  `branch_id` bigint(20) UNSIGNED NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `branch_types`
--

CREATE TABLE `branch_types` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `name` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL CHECK (json_valid(`name`)),
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `branch_types`
--

INSERT INTO `branch_types` (`id`, `name`, `created_at`, `updated_at`) VALUES
(1, '{\"ar\":\"رئيسي\",\"en\":\"Main\"}', '2025-10-19 04:46:25', '2025-10-19 04:46:25'),
(2, '{\"ar\":\"فرعي\",\"en\":\"Sub\"}', '2025-10-19 04:46:25', '2025-10-19 04:46:25'),
(3, '{\"ar\":\"امتياز\",\"en\":\"Franchise\"}', '2025-10-19 04:46:25', '2025-10-19 04:46:25');

-- --------------------------------------------------------

--
-- Table structure for table `cities`
--

CREATE TABLE `cities` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `name` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL CHECK (json_valid(`name`)),
  `state_id` bigint(20) UNSIGNED NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `cities`
--

INSERT INTO `cities` (`id`, `name`, `state_id`, `created_at`, `updated_at`) VALUES
(1, '{\"ar\":\"مدينة نصر\",\"en\":\"Nasr City\"}', 1, '2025-10-19 04:46:20', '2025-10-19 04:46:20'),
(2, '{\"ar\":\"الزمالك\",\"en\":\"Zamalek\"}', 1, '2025-10-19 04:46:20', '2025-10-19 04:46:20'),
(3, '{\"ar\":\"الملز\",\"en\":\"Olaya\"}', 4, '2025-10-19 04:46:20', '2025-10-19 04:46:20'),
(4, '{\"ar\":\"الخبر\",\"en\":\"Al-Khobar\"}', 4, '2025-10-19 04:46:20', '2025-10-19 04:46:20'),
(5, '{\"ar\":\"الخليج الغربي\",\"en\":\"West Bay\"}', 13, '2025-10-19 04:46:22', '2025-10-19 04:46:22'),
(6, '{\"ar\":\"السد\",\"en\":\"Al Sadd\"}', 13, '2025-10-19 04:46:22', '2025-10-19 04:46:22');

-- --------------------------------------------------------

--
-- Table structure for table `company_settings`
--

CREATE TABLE `company_settings` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `name` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL CHECK (json_valid(`name`)),
  `logo_path` varchar(255) DEFAULT NULL,
  `primary_color` varchar(255) NOT NULL DEFAULT '#0ea5b6',
  `secondary_color` varchar(255) NOT NULL DEFAULT '#1e293b',
  `email` varchar(255) DEFAULT NULL,
  `phones` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`phones`)),
  `country_id` bigint(20) UNSIGNED DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `company_settings`
--

INSERT INTO `company_settings` (`id`, `name`, `logo_path`, `primary_color`, `secondary_color`, `email`, `phones`, `country_id`, `created_at`, `updated_at`) VALUES
(1, '{\"ar\":\"الشركة النموذجية\",\"en\":\"Demo Company\"}', NULL, '#0ea5b6', '#1e293b', 'info@example.com', '[{\"label\":{\"ar\":\"\\u0627\\u0644\\u0645\\u0628\\u064a\\u0639\\u0627\\u062a\",\"en\":\"Sales\"},\"number\":\"+201234567890\"},{\"label\":{\"ar\":\"\\u0627\\u0644\\u062f\\u0639\\u0645\",\"en\":\"Support\"},\"number\":\"+201112223334\"}]', 2, '2025-10-19 04:46:24', '2025-10-19 04:46:24');

-- --------------------------------------------------------

--
-- Table structure for table `countries`
--

CREATE TABLE `countries` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `name` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL CHECK (json_valid(`name`)),
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `countries`
--

INSERT INTO `countries` (`id`, `name`, `created_at`, `updated_at`) VALUES
(1, '{\"ar\":\"مصر\",\"en\":\"Egypt\"}', '2025-10-19 04:46:20', '2025-10-19 04:46:20'),
(2, '{\"ar\":\"السعودية\",\"en\":\"Saudi Arabia\"}', '2025-10-19 04:46:20', '2025-10-19 04:46:20'),
(3, '{\"ar\":\"الإمارات\",\"en\":\"United Arab Emirates\"}', '2025-10-19 04:46:21', '2025-10-19 04:46:21'),
(4, '{\"ar\":\"الأردن\",\"en\":\"Jordan\"}', '2025-10-19 04:46:21', '2025-10-19 04:46:21'),
(5, '{\"ar\":\"لبنان\",\"en\":\"Lebanon\"}', '2025-10-19 04:46:21', '2025-10-19 04:46:21'),
(6, '{\"ar\":\"الجزائر\",\"en\":\"Algeria\"}', '2025-10-19 04:46:21', '2025-10-19 04:46:21'),
(7, '{\"ar\":\"المغرب\",\"en\":\"Morocco\"}', '2025-10-19 04:46:21', '2025-10-19 04:46:21'),
(8, '{\"ar\":\"تونس\",\"en\":\"Tunisia\"}', '2025-10-19 04:46:21', '2025-10-19 04:46:21'),
(9, '{\"ar\":\"العراق\",\"en\":\"Iraq\"}', '2025-10-19 04:46:21', '2025-10-19 04:46:21'),
(10, '{\"ar\":\"الكويت\",\"en\":\"Kuwait\"}', '2025-10-19 04:46:21', '2025-10-19 04:46:21'),
(11, '{\"ar\":\"عمان\",\"en\":\"Oman\"}', '2025-10-19 04:46:21', '2025-10-19 04:46:21'),
(12, '{\"ar\":\"قطر\",\"en\":\"Qatar\"}', '2025-10-19 04:46:22', '2025-10-19 04:46:22'),
(13, '{\"ar\":\"البحرين\",\"en\":\"Bahrain\"}', '2025-10-19 04:46:23', '2025-10-19 04:46:23'),
(14, '{\"ar\":\"فلسطين\",\"en\":\"Palestine\"}', '2025-10-19 04:46:23', '2025-10-19 04:46:23'),
(15, '{\"ar\":\"سوريا\",\"en\":\"Syria\"}', '2025-10-19 04:46:23', '2025-10-19 04:46:23'),
(16, '{\"ar\":\"اليمن\",\"en\":\"Yemen\"}', '2025-10-19 04:46:23', '2025-10-19 04:46:23');

-- --------------------------------------------------------

--
-- Table structure for table `customers`
--

CREATE TABLE `customers` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `customer_code` varchar(7) NOT NULL,
  `branch_id` bigint(20) UNSIGNED NOT NULL,
  `name` varchar(255) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `failed_jobs`
--

CREATE TABLE `failed_jobs` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `uuid` varchar(255) NOT NULL,
  `connection` text NOT NULL,
  `queue` text NOT NULL,
  `payload` longtext NOT NULL,
  `exception` longtext NOT NULL,
  `failed_at` timestamp NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `members`
--

CREATE TABLE `members` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `member_code` char(7) NOT NULL,
  `branch_id` bigint(20) UNSIGNED NOT NULL,
  `status` enum('new','active','inactive') NOT NULL DEFAULT 'new',
  `id_type` enum('national_id','residence','passport','driving_license','work_card') DEFAULT NULL,
  `id_number` varchar(20) DEFAULT NULL,
  `id_issue_greg` date DEFAULT NULL,
  `id_expiry_greg` date DEFAULT NULL,
  `id_issue_hijri` varchar(20) DEFAULT NULL,
  `id_expiry_hijri` varchar(20) DEFAULT NULL,
  `name` varchar(255) NOT NULL,
  `gender` enum('male','female') DEFAULT NULL,
  `nationality_id` bigint(20) UNSIGNED DEFAULT NULL,
  `birth_greg` date DEFAULT NULL,
  `birth_hijri` varchar(20) DEFAULT NULL,
  `age` smallint(5) UNSIGNED DEFAULT NULL,
  `phone` varchar(30) DEFAULT NULL,
  `email` varchar(255) DEFAULT NULL,
  `po_box` varchar(50) DEFAULT NULL,
  `postal_code` varchar(20) DEFAULT NULL,
  `address` varchar(255) DEFAULT NULL,
  `avatar_path` varchar(255) DEFAULT NULL,
  `id_image_path` varchar(255) DEFAULT NULL,
  `work_card_image_path` varchar(255) DEFAULT NULL,
  `how_heard` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`how_heard`)),
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `member_sequences`
--

CREATE TABLE `member_sequences` (
  `branch_id` bigint(20) UNSIGNED NOT NULL,
  `prefix` char(2) NOT NULL,
  `last_seq` int(10) UNSIGNED NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `migrations`
--

CREATE TABLE `migrations` (
  `id` int(10) UNSIGNED NOT NULL,
  `migration` varchar(255) NOT NULL,
  `batch` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `migrations`
--

INSERT INTO `migrations` (`id`, `migration`, `batch`) VALUES
(1, '2014_01_20_195147_create_countries_table', 1),
(2, '2014_01_20_195616_create_states_table', 1),
(3, '2014_01_20_195637_create_cities_table', 1),
(4, '2014_01_25_060108_create_branch_categories_table', 1),
(5, '2014_01_25_062659_create_branch_types_table', 1),
(6, '2014_01_25_082216_create_branches_table', 1),
(7, '2014_10_12_000000_create_users_table', 1),
(8, '2014_10_12_100000_create_password_reset_tokens_table', 1),
(9, '2014_10_12_100000_create_password_resets_table', 1),
(10, '2019_08_19_000000_create_failed_jobs_table', 1),
(11, '2019_12_14_000001_create_personal_access_tokens_table', 1),
(12, '2025_09_25_071042_create_company_settings_table', 1),
(13, '2025_09_25_082331_create_branch_monthly_goals_table', 1),
(14, '2025_09_25_170137_create_service_types_table', 1),
(15, '2025_09_25_172350_create_service_categories_table', 1),
(16, '2025_09_25_184345_create_services_table', 1),
(17, '2025_10_03_195032_create_customers_table', 1),
(18, '2025_10_03_204536_create_members_table', 1),
(19, '2025_10_03_231239_create_member_sequences_table', 1),
(20, '2025_10_06_075050_create_offers_table', 1),
(21, '2025_10_06_075203_create_offer_items_table', 1),
(22, '2025_10_18_120945_create_permission_tables', 1);

-- --------------------------------------------------------

--
-- Table structure for table `model_has_permissions`
--

CREATE TABLE `model_has_permissions` (
  `permission_id` bigint(20) UNSIGNED NOT NULL,
  `model_type` varchar(255) NOT NULL,
  `model_id` bigint(20) UNSIGNED NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `model_has_roles`
--

CREATE TABLE `model_has_roles` (
  `role_id` bigint(20) UNSIGNED NOT NULL,
  `model_type` varchar(255) NOT NULL,
  `model_id` bigint(20) UNSIGNED NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `model_has_roles`
--

INSERT INTO `model_has_roles` (`role_id`, `model_type`, `model_id`) VALUES
(1, 'App\\Models\\User', 1);

-- --------------------------------------------------------

--
-- Table structure for table `offers`
--

CREATE TABLE `offers` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `offer_no` bigint(20) UNSIGNED NOT NULL,
  `name` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL CHECK (json_valid(`name`)),
  `scope` enum('all','members','customers','coupons') NOT NULL DEFAULT 'all',
  `target_member_ids` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`target_member_ids`)),
  `target_customer_ids` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`target_customer_ids`)),
  `coupon_codes` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`coupon_codes`)),
  `start_date_g` date NOT NULL,
  `end_date_g` date NOT NULL,
  `start_date_h` varchar(20) DEFAULT NULL,
  `end_date_h` varchar(20) DEFAULT NULL,
  `duration_days` int(10) UNSIGNED NOT NULL DEFAULT 0,
  `discount_type` enum('percent','amount') NOT NULL DEFAULT 'percent',
  `discount_value` decimal(10,2) NOT NULL DEFAULT 0.00,
  `extra_days` int(10) UNSIGNED NOT NULL DEFAULT 0,
  `active` tinyint(1) NOT NULL DEFAULT 1,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `offer_items`
--

CREATE TABLE `offer_items` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `offer_id` bigint(20) UNSIGNED NOT NULL,
  `service_id` bigint(20) UNSIGNED NOT NULL,
  `service_name` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL CHECK (json_valid(`service_name`)),
  `base_price` decimal(10,2) NOT NULL,
  `base_duration_value` int(10) UNSIGNED NOT NULL,
  `base_duration_unit` enum('days','months','years') NOT NULL,
  `row_discount_type` enum('percent','amount') DEFAULT NULL,
  `row_discount_value` decimal(10,2) DEFAULT NULL,
  `row_extra_days` int(10) UNSIGNED DEFAULT NULL,
  `final_price` decimal(10,2) NOT NULL,
  `final_duration_value` int(10) UNSIGNED NOT NULL,
  `final_duration_unit` enum('days','months','years') NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `password_resets`
--

CREATE TABLE `password_resets` (
  `email` varchar(255) NOT NULL,
  `token` varchar(255) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `password_reset_tokens`
--

CREATE TABLE `password_reset_tokens` (
  `email` varchar(255) NOT NULL,
  `token` varchar(255) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `permissions`
--

CREATE TABLE `permissions` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `name` varchar(255) NOT NULL,
  `guard_name` varchar(255) NOT NULL,
  `branch_id` bigint(20) UNSIGNED DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `permissions`
--

INSERT INTO `permissions` (`id`, `name`, `guard_name`, `branch_id`, `created_at`, `updated_at`) VALUES
(1, 'users.view', 'web', NULL, '2025-10-19 04:46:24', '2025-10-19 04:46:24'),
(2, 'users.create', 'web', NULL, '2025-10-19 04:46:24', '2025-10-19 04:46:24'),
(3, 'users.edit', 'web', NULL, '2025-10-19 04:46:24', '2025-10-19 04:46:24'),
(4, 'users.delete', 'web', NULL, '2025-10-19 04:46:24', '2025-10-19 04:46:24'),
(5, 'roles.view', 'web', NULL, '2025-10-19 04:46:24', '2025-10-19 04:46:24'),
(6, 'roles.create', 'web', NULL, '2025-10-19 04:46:24', '2025-10-19 04:46:24'),
(7, 'roles.edit', 'web', NULL, '2025-10-19 04:46:24', '2025-10-19 04:46:24'),
(8, 'roles.delete', 'web', NULL, '2025-10-19 04:46:24', '2025-10-19 04:46:24'),
(9, 'branches.view', 'web', NULL, '2025-10-19 04:46:24', '2025-10-19 04:46:24'),
(10, 'branches.create', 'web', NULL, '2025-10-19 04:46:24', '2025-10-19 04:46:24'),
(11, 'branches.edit', 'web', NULL, '2025-10-19 04:46:24', '2025-10-19 04:46:24'),
(12, 'branches.delete', 'web', NULL, '2025-10-19 04:46:24', '2025-10-19 04:46:24'),
(13, 'reports.view', 'web', NULL, '2025-10-19 04:46:25', '2025-10-19 04:46:25'),
(14, 'reports.export', 'web', NULL, '2025-10-19 04:46:25', '2025-10-19 04:46:25');

-- --------------------------------------------------------

--
-- Table structure for table `personal_access_tokens`
--

CREATE TABLE `personal_access_tokens` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `tokenable_type` varchar(255) NOT NULL,
  `tokenable_id` bigint(20) UNSIGNED NOT NULL,
  `name` varchar(255) NOT NULL,
  `token` varchar(64) NOT NULL,
  `abilities` text DEFAULT NULL,
  `last_used_at` timestamp NULL DEFAULT NULL,
  `expires_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `roles`
--

CREATE TABLE `roles` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `name` varchar(255) NOT NULL,
  `guard_name` varchar(255) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `roles`
--

INSERT INTO `roles` (`id`, `name`, `guard_name`, `created_at`, `updated_at`) VALUES
(1, 'super_admin', 'web', '2025-10-19 04:46:25', '2025-10-19 04:46:25');

-- --------------------------------------------------------

--
-- Table structure for table `role_has_permissions`
--

CREATE TABLE `role_has_permissions` (
  `permission_id` bigint(20) UNSIGNED NOT NULL,
  `role_id` bigint(20) UNSIGNED NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `role_has_permissions`
--

INSERT INTO `role_has_permissions` (`permission_id`, `role_id`) VALUES
(1, 1),
(2, 1),
(3, 1),
(4, 1),
(5, 1),
(6, 1),
(7, 1),
(8, 1),
(9, 1),
(10, 1),
(11, 1),
(12, 1),
(13, 1),
(14, 1);

-- --------------------------------------------------------

--
-- Table structure for table `services`
--

CREATE TABLE `services` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `service_code` varchar(10) DEFAULT NULL,
  `name` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL CHECK (json_valid(`name`)),
  `service_category_id` bigint(20) UNSIGNED NOT NULL,
  `service_type_id` bigint(20) UNSIGNED NOT NULL,
  `price` decimal(10,2) NOT NULL,
  `duration_value` int(10) UNSIGNED NOT NULL,
  `duration_unit` enum('days','months','years') NOT NULL,
  `start_time` time DEFAULT NULL,
  `end_time` time DEFAULT NULL,
  `notes` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`notes`)),
  `settings` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`settings`)),
  `active` tinyint(1) NOT NULL DEFAULT 1,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `service_categories`
--

CREATE TABLE `service_categories` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `name` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL CHECK (json_valid(`name`)),
  `description` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`description`)),
  `active` tinyint(1) NOT NULL DEFAULT 1,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `service_types`
--

CREATE TABLE `service_types` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `name` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL CHECK (json_valid(`name`)),
  `description` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`description`)),
  `active` tinyint(1) NOT NULL DEFAULT 1,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `states`
--

CREATE TABLE `states` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `name` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL CHECK (json_valid(`name`)),
  `country_id` bigint(20) UNSIGNED NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `states`
--

INSERT INTO `states` (`id`, `name`, `country_id`, `created_at`, `updated_at`) VALUES
(1, '{\"ar\":\"القاهرة\",\"en\":\"Cairo\"}', 1, '2025-10-19 04:46:20', '2025-10-19 04:46:20'),
(2, '{\"ar\":\"الإسكندرية\",\"en\":\"Alexandria\"}', 1, '2025-10-19 04:46:20', '2025-10-19 04:46:20'),
(3, '{\"ar\":\"الجيزة\",\"en\":\"Giza\"}', 1, '2025-10-19 04:46:20', '2025-10-19 04:46:20'),
(4, '{\"ar\":\"الرياض\",\"en\":\"Riyadh\"}', 2, '2025-10-19 04:46:20', '2025-10-19 04:46:20'),
(5, '{\"ar\":\"جدة\",\"en\":\"Jeddah\"}', 2, '2025-10-19 04:46:21', '2025-10-19 04:46:21'),
(6, '{\"ar\":\"مكة\",\"en\":\"Mecca\"}', 2, '2025-10-19 04:46:21', '2025-10-19 04:46:21'),
(7, '{\"ar\":\"دبي\",\"en\":\"Dubai\"}', 3, '2025-10-19 04:46:21', '2025-10-19 04:46:21'),
(8, '{\"ar\":\"أبوظبي\",\"en\":\"Abu Dhabi\"}', 3, '2025-10-19 04:46:21', '2025-10-19 04:46:21'),
(9, '{\"ar\":\"الشارقة\",\"en\":\"Sharjah\"}', 3, '2025-10-19 04:46:21', '2025-10-19 04:46:21'),
(10, '{\"ar\":\"مسقط\",\"en\":\"Muscat\"}', 11, '2025-10-19 04:46:22', '2025-10-19 04:46:22'),
(11, '{\"ar\":\"ظفار\",\"en\":\"Dhofar\"}', 11, '2025-10-19 04:46:22', '2025-10-19 04:46:22'),
(12, '{\"ar\":\"الباطنة شمال\",\"en\":\"North Batinah\"}', 11, '2025-10-19 04:46:22', '2025-10-19 04:46:22'),
(13, '{\"ar\":\"الدوحة\",\"en\":\"Doha\"}', 12, '2025-10-19 04:46:22', '2025-10-19 04:46:22'),
(14, '{\"ar\":\"الريان\",\"en\":\"Al Rayyan\"}', 12, '2025-10-19 04:46:22', '2025-10-19 04:46:22'),
(15, '{\"ar\":\"الخور\",\"en\":\"Al Khor\"}', 12, '2025-10-19 04:46:23', '2025-10-19 04:46:23'),
(16, '{\"ar\":\"المنامة\",\"en\":\"Manama\"}', 13, '2025-10-19 04:46:23', '2025-10-19 04:46:23'),
(17, '{\"ar\":\"المحرق\",\"en\":\"Muharraq\"}', 13, '2025-10-19 04:46:23', '2025-10-19 04:46:23'),
(18, '{\"ar\":\"رام الله\",\"en\":\"Ramallah\"}', 14, '2025-10-19 04:46:23', '2025-10-19 04:46:23'),
(19, '{\"ar\":\"غزة\",\"en\":\"Gaza\"}', 14, '2025-10-19 04:46:23', '2025-10-19 04:46:23'),
(20, '{\"ar\":\"دمشق\",\"en\":\"Damascus\"}', 15, '2025-10-19 04:46:23', '2025-10-19 04:46:23'),
(21, '{\"ar\":\"حلب\",\"en\":\"Aleppo\"}', 15, '2025-10-19 04:46:23', '2025-10-19 04:46:23'),
(22, '{\"ar\":\"صنعاء\",\"en\":\"Sanaa\"}', 16, '2025-10-19 04:46:23', '2025-10-19 04:46:23'),
(23, '{\"ar\":\"عدن\",\"en\":\"Aden\"}', 16, '2025-10-19 04:46:23', '2025-10-19 04:46:23');

-- --------------------------------------------------------

--
-- Table structure for table `users`
--

CREATE TABLE `users` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `name` varchar(255) NOT NULL,
  `email` varchar(255) NOT NULL,
  `email_verified_at` timestamp NULL DEFAULT NULL,
  `password` varchar(255) NOT NULL,
  `branch_id` bigint(20) UNSIGNED DEFAULT NULL,
  `remember_token` varchar(100) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `users`
--

INSERT INTO `users` (`id`, `name`, `email`, `email_verified_at`, `password`, `branch_id`, `remember_token`, `created_at`, `updated_at`) VALUES
(1, 'Super Admin', 'admin@system.local', NULL, '$2y$10$zFW76sceiwKh3dEcVAbn1O4YvUreAX621dQi2RrQgAHUCXNELd1u2', NULL, NULL, '2025-10-19 04:46:25', '2025-10-19 04:46:25');

--
-- Indexes for dumped tables
--

--
-- Indexes for table `branches`
--
ALTER TABLE `branches`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `branches_branch_code_unique` (`branch_code`),
  ADD KEY `branches_branch_category_id_foreign` (`branch_category_id`),
  ADD KEY `branches_branch_type_id_foreign` (`branch_type_id`),
  ADD KEY `branches_city_id_foreign` (`city_id`);

--
-- Indexes for table `branch_categories`
--
ALTER TABLE `branch_categories`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `branch_monthly_goals`
--
ALTER TABLE `branch_monthly_goals`
  ADD PRIMARY KEY (`id`),
  ADD KEY `branch_monthly_goals_branch_id_foreign` (`branch_id`);

--
-- Indexes for table `branch_service_provided`
--
ALTER TABLE `branch_service_provided`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `branch_service_provided_service_id_branch_id_unique` (`service_id`,`branch_id`),
  ADD KEY `branch_service_provided_branch_id_foreign` (`branch_id`);

--
-- Indexes for table `branch_service_sold`
--
ALTER TABLE `branch_service_sold`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `branch_service_sold_service_id_branch_id_unique` (`service_id`,`branch_id`),
  ADD KEY `branch_service_sold_branch_id_foreign` (`branch_id`);

--
-- Indexes for table `branch_types`
--
ALTER TABLE `branch_types`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `cities`
--
ALTER TABLE `cities`
  ADD PRIMARY KEY (`id`),
  ADD KEY `cities_state_id_foreign` (`state_id`);

--
-- Indexes for table `company_settings`
--
ALTER TABLE `company_settings`
  ADD PRIMARY KEY (`id`),
  ADD KEY `company_settings_country_id_foreign` (`country_id`);

--
-- Indexes for table `countries`
--
ALTER TABLE `countries`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `customers`
--
ALTER TABLE `customers`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `customers_customer_code_unique` (`customer_code`),
  ADD KEY `customers_branch_id_foreign` (`branch_id`);

--
-- Indexes for table `failed_jobs`
--
ALTER TABLE `failed_jobs`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `failed_jobs_uuid_unique` (`uuid`);

--
-- Indexes for table `members`
--
ALTER TABLE `members`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `members_member_code_unique` (`member_code`),
  ADD UNIQUE KEY `members_id_number_unique` (`id_number`),
  ADD KEY `members_nationality_id_foreign` (`nationality_id`),
  ADD KEY `members_branch_id_status_index` (`branch_id`,`status`);

--
-- Indexes for table `member_sequences`
--
ALTER TABLE `member_sequences`
  ADD PRIMARY KEY (`branch_id`);

--
-- Indexes for table `migrations`
--
ALTER TABLE `migrations`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `model_has_permissions`
--
ALTER TABLE `model_has_permissions`
  ADD PRIMARY KEY (`permission_id`,`model_id`,`model_type`),
  ADD KEY `model_has_permissions_model_id_model_type_index` (`model_id`,`model_type`);

--
-- Indexes for table `model_has_roles`
--
ALTER TABLE `model_has_roles`
  ADD PRIMARY KEY (`role_id`,`model_id`,`model_type`),
  ADD KEY `model_has_roles_model_id_model_type_index` (`model_id`,`model_type`);

--
-- Indexes for table `offers`
--
ALTER TABLE `offers`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `offers_offer_no_unique` (`offer_no`);

--
-- Indexes for table `offer_items`
--
ALTER TABLE `offer_items`
  ADD PRIMARY KEY (`id`),
  ADD KEY `offer_items_offer_id_foreign` (`offer_id`),
  ADD KEY `offer_items_service_id_foreign` (`service_id`);

--
-- Indexes for table `password_resets`
--
ALTER TABLE `password_resets`
  ADD KEY `password_resets_email_index` (`email`);

--
-- Indexes for table `password_reset_tokens`
--
ALTER TABLE `password_reset_tokens`
  ADD PRIMARY KEY (`email`);

--
-- Indexes for table `permissions`
--
ALTER TABLE `permissions`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `perm_name_guard_branch_unique` (`name`,`guard_name`,`branch_id`),
  ADD KEY `permissions_branch_id_foreign` (`branch_id`);

--
-- Indexes for table `personal_access_tokens`
--
ALTER TABLE `personal_access_tokens`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `personal_access_tokens_token_unique` (`token`),
  ADD KEY `personal_access_tokens_tokenable_type_tokenable_id_index` (`tokenable_type`,`tokenable_id`);

--
-- Indexes for table `roles`
--
ALTER TABLE `roles`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `roles_name_guard_name_unique` (`name`,`guard_name`);

--
-- Indexes for table `role_has_permissions`
--
ALTER TABLE `role_has_permissions`
  ADD PRIMARY KEY (`permission_id`,`role_id`),
  ADD KEY `role_has_permissions_role_id_foreign` (`role_id`);

--
-- Indexes for table `services`
--
ALTER TABLE `services`
  ADD PRIMARY KEY (`id`),
  ADD KEY `services_service_category_id_foreign` (`service_category_id`),
  ADD KEY `services_service_type_id_foreign` (`service_type_id`);

--
-- Indexes for table `service_categories`
--
ALTER TABLE `service_categories`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `service_types`
--
ALTER TABLE `service_types`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `states`
--
ALTER TABLE `states`
  ADD PRIMARY KEY (`id`),
  ADD KEY `states_country_id_foreign` (`country_id`);

--
-- Indexes for table `users`
--
ALTER TABLE `users`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `users_email_unique` (`email`),
  ADD KEY `users_branch_id_foreign` (`branch_id`);

--
-- AUTO_INCREMENT for dumped tables
--

--
-- AUTO_INCREMENT for table `branches`
--
ALTER TABLE `branches`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=4;

--
-- AUTO_INCREMENT for table `branch_categories`
--
ALTER TABLE `branch_categories`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=4;

--
-- AUTO_INCREMENT for table `branch_monthly_goals`
--
ALTER TABLE `branch_monthly_goals`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `branch_service_provided`
--
ALTER TABLE `branch_service_provided`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `branch_service_sold`
--
ALTER TABLE `branch_service_sold`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `branch_types`
--
ALTER TABLE `branch_types`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=4;

--
-- AUTO_INCREMENT for table `cities`
--
ALTER TABLE `cities`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=7;

--
-- AUTO_INCREMENT for table `company_settings`
--
ALTER TABLE `company_settings`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=2;

--
-- AUTO_INCREMENT for table `countries`
--
ALTER TABLE `countries`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=17;

--
-- AUTO_INCREMENT for table `customers`
--
ALTER TABLE `customers`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `failed_jobs`
--
ALTER TABLE `failed_jobs`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `members`
--
ALTER TABLE `members`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `migrations`
--
ALTER TABLE `migrations`
  MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=23;

--
-- AUTO_INCREMENT for table `offers`
--
ALTER TABLE `offers`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `offer_items`
--
ALTER TABLE `offer_items`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `permissions`
--
ALTER TABLE `permissions`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=15;

--
-- AUTO_INCREMENT for table `personal_access_tokens`
--
ALTER TABLE `personal_access_tokens`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `roles`
--
ALTER TABLE `roles`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=2;

--
-- AUTO_INCREMENT for table `services`
--
ALTER TABLE `services`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `service_categories`
--
ALTER TABLE `service_categories`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `service_types`
--
ALTER TABLE `service_types`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `states`
--
ALTER TABLE `states`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=24;

--
-- AUTO_INCREMENT for table `users`
--
ALTER TABLE `users`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=2;

--
-- Constraints for dumped tables
--

--
-- Constraints for table `branches`
--
ALTER TABLE `branches`
  ADD CONSTRAINT `branches_branch_category_id_foreign` FOREIGN KEY (`branch_category_id`) REFERENCES `branch_categories` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `branches_branch_type_id_foreign` FOREIGN KEY (`branch_type_id`) REFERENCES `branch_types` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `branches_city_id_foreign` FOREIGN KEY (`city_id`) REFERENCES `states` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `branch_monthly_goals`
--
ALTER TABLE `branch_monthly_goals`
  ADD CONSTRAINT `branch_monthly_goals_branch_id_foreign` FOREIGN KEY (`branch_id`) REFERENCES `branches` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `branch_service_provided`
--
ALTER TABLE `branch_service_provided`
  ADD CONSTRAINT `branch_service_provided_branch_id_foreign` FOREIGN KEY (`branch_id`) REFERENCES `branches` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `branch_service_provided_service_id_foreign` FOREIGN KEY (`service_id`) REFERENCES `services` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `branch_service_sold`
--
ALTER TABLE `branch_service_sold`
  ADD CONSTRAINT `branch_service_sold_branch_id_foreign` FOREIGN KEY (`branch_id`) REFERENCES `branches` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `branch_service_sold_service_id_foreign` FOREIGN KEY (`service_id`) REFERENCES `services` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `cities`
--
ALTER TABLE `cities`
  ADD CONSTRAINT `cities_state_id_foreign` FOREIGN KEY (`state_id`) REFERENCES `states` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `company_settings`
--
ALTER TABLE `company_settings`
  ADD CONSTRAINT `company_settings_country_id_foreign` FOREIGN KEY (`country_id`) REFERENCES `countries` (`id`) ON DELETE SET NULL;

--
-- Constraints for table `customers`
--
ALTER TABLE `customers`
  ADD CONSTRAINT `customers_branch_id_foreign` FOREIGN KEY (`branch_id`) REFERENCES `branches` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `members`
--
ALTER TABLE `members`
  ADD CONSTRAINT `members_branch_id_foreign` FOREIGN KEY (`branch_id`) REFERENCES `branches` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `members_nationality_id_foreign` FOREIGN KEY (`nationality_id`) REFERENCES `countries` (`id`) ON DELETE SET NULL;

--
-- Constraints for table `member_sequences`
--
ALTER TABLE `member_sequences`
  ADD CONSTRAINT `member_sequences_branch_id_foreign` FOREIGN KEY (`branch_id`) REFERENCES `branches` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `model_has_permissions`
--
ALTER TABLE `model_has_permissions`
  ADD CONSTRAINT `model_has_permissions_permission_id_foreign` FOREIGN KEY (`permission_id`) REFERENCES `permissions` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `model_has_roles`
--
ALTER TABLE `model_has_roles`
  ADD CONSTRAINT `model_has_roles_role_id_foreign` FOREIGN KEY (`role_id`) REFERENCES `roles` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `offer_items`
--
ALTER TABLE `offer_items`
  ADD CONSTRAINT `offer_items_offer_id_foreign` FOREIGN KEY (`offer_id`) REFERENCES `offers` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `offer_items_service_id_foreign` FOREIGN KEY (`service_id`) REFERENCES `services` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `permissions`
--
ALTER TABLE `permissions`
  ADD CONSTRAINT `permissions_branch_id_foreign` FOREIGN KEY (`branch_id`) REFERENCES `branches` (`id`) ON DELETE SET NULL;

--
-- Constraints for table `role_has_permissions`
--
ALTER TABLE `role_has_permissions`
  ADD CONSTRAINT `role_has_permissions_permission_id_foreign` FOREIGN KEY (`permission_id`) REFERENCES `permissions` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `role_has_permissions_role_id_foreign` FOREIGN KEY (`role_id`) REFERENCES `roles` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `services`
--
ALTER TABLE `services`
  ADD CONSTRAINT `services_service_category_id_foreign` FOREIGN KEY (`service_category_id`) REFERENCES `service_categories` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `services_service_type_id_foreign` FOREIGN KEY (`service_type_id`) REFERENCES `service_types` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `states`
--
ALTER TABLE `states`
  ADD CONSTRAINT `states_country_id_foreign` FOREIGN KEY (`country_id`) REFERENCES `countries` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `users`
--
ALTER TABLE `users`
  ADD CONSTRAINT `users_branch_id_foreign` FOREIGN KEY (`branch_id`) REFERENCES `branches` (`id`) ON DELETE SET NULL;
COMMIT;

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
