-- phpMyAdmin SQL Dump
-- version 5.2.1
-- https://www.phpmyadmin.net/
--
-- Host: 127.0.0.1
-- Generation Time: Sep 28, 2025 at 11:12 AM
-- Server version: 10.4.28-MariaDB
-- PHP Version: 8.2.12

SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
START TRANSACTION;
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;

--
-- Database: `pioneer`
--

-- --------------------------------------------------------

--
-- Table structure for table `branches`
--

CREATE TABLE `branches` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `name` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL CHECK (json_valid(`name`)),
  `branch_category_id` bigint(20) UNSIGNED NOT NULL,
  `branch_type_id` bigint(20) UNSIGNED NOT NULL,
  `city_id` bigint(20) UNSIGNED NOT NULL,
  `primary_phone` varchar(255) NOT NULL,
  `phones` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`phones`)),
  `active` tinyint(1) NOT NULL DEFAULT 1,
  `address` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`address`)),
  `min_age` tinyint(3) UNSIGNED DEFAULT NULL,
  `max_discount_percent` decimal(5,2) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `branch_categories`
--

CREATE TABLE `branch_categories` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `name` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL CHECK (json_valid(`name`)),
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `branch_monthly_goals`
--

CREATE TABLE `branch_monthly_goals` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `branch_id` bigint(20) UNSIGNED NOT NULL,
  `year` smallint(6) NOT NULL,
  `month` tinyint(4) NOT NULL,
  `actual` decimal(12,2) NOT NULL DEFAULT 0.00,
  `target` decimal(12,2) NOT NULL DEFAULT 0.00,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `branch_service_provided`
--

CREATE TABLE `branch_service_provided` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `service_id` bigint(20) UNSIGNED NOT NULL,
  `branch_id` bigint(20) UNSIGNED NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `branch_service_sold`
--

CREATE TABLE `branch_service_sold` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `service_id` bigint(20) UNSIGNED NOT NULL,
  `branch_id` bigint(20) UNSIGNED NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `branch_types`
--

CREATE TABLE `branch_types` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `name` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL CHECK (json_valid(`name`)),
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `cities`
--

CREATE TABLE `cities` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `name` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL CHECK (json_valid(`name`)),
  `state_id` bigint(20) UNSIGNED NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `cities`
--

INSERT INTO `cities` (`id`, `name`, `state_id`, `created_at`, `updated_at`) VALUES
(1, '{\"ar\":\"مدينة نصر\",\"en\":\"Nasr City\"}', 1, '2025-09-28 06:11:59', '2025-09-28 06:11:59'),
(2, '{\"ar\":\"الزمالك\",\"en\":\"Zamalek\"}', 1, '2025-09-28 06:11:59', '2025-09-28 06:11:59'),
(3, '{\"ar\":\"الملز\",\"en\":\"Olaya\"}', 4, '2025-09-28 06:12:00', '2025-09-28 06:12:00'),
(4, '{\"ar\":\"الخبر\",\"en\":\"Al-Khobar\"}', 4, '2025-09-28 06:12:00', '2025-09-28 06:12:00'),
(5, '{\"ar\":\"الخليج الغربي\",\"en\":\"West Bay\"}', 13, '2025-09-28 06:12:02', '2025-09-28 06:12:02'),
(6, '{\"ar\":\"السد\",\"en\":\"Al Sadd\"}', 13, '2025-09-28 06:12:02', '2025-09-28 06:12:02');

-- --------------------------------------------------------

--
-- Table structure for table `company_settings`
--

CREATE TABLE `company_settings` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `name` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL CHECK (json_valid(`name`)),
  `logo_path` varchar(255) DEFAULT NULL,
  `primary_color` varchar(255) NOT NULL DEFAULT '#0ea5b6',
  `secondary_color` varchar(255) NOT NULL DEFAULT '#1e293b',
  `email` varchar(255) DEFAULT NULL,
  `phones` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`phones`)),
  `country_id` bigint(20) UNSIGNED DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `company_settings`
--

INSERT INTO `company_settings` (`id`, `name`, `logo_path`, `primary_color`, `secondary_color`, `email`, `phones`, `country_id`, `created_at`, `updated_at`) VALUES
(1, '{\"ar\":\"الشركة النموذجية\",\"en\":\"Demo Company\"}', NULL, '#0ea5b6', '#1e293b', 'info@example.com', '[{\"label\":{\"ar\":\"\\u0627\\u0644\\u0645\\u0628\\u064a\\u0639\\u0627\\u062a\",\"en\":\"Sales\"},\"number\":\"+201234567890\"},{\"label\":{\"ar\":\"\\u0627\\u0644\\u062f\\u0639\\u0645\",\"en\":\"Support\"},\"number\":\"+201112223334\"}]', 2, '2025-09-28 06:12:05', '2025-09-28 06:12:05');

-- --------------------------------------------------------

--
-- Table structure for table `countries`
--

CREATE TABLE `countries` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `name` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL CHECK (json_valid(`name`)),
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `countries`
--

INSERT INTO `countries` (`id`, `name`, `created_at`, `updated_at`) VALUES
(1, '{\"ar\":\"مصر\",\"en\":\"Egypt\"}', '2025-09-28 06:11:59', '2025-09-28 06:11:59'),
(2, '{\"ar\":\"السعودية\",\"en\":\"Saudi Arabia\"}', '2025-09-28 06:12:00', '2025-09-28 06:12:00'),
(3, '{\"ar\":\"الإمارات\",\"en\":\"United Arab Emirates\"}', '2025-09-28 06:12:01', '2025-09-28 06:12:01'),
(4, '{\"ar\":\"الأردن\",\"en\":\"Jordan\"}', '2025-09-28 06:12:01', '2025-09-28 06:12:01'),
(5, '{\"ar\":\"لبنان\",\"en\":\"Lebanon\"}', '2025-09-28 06:12:01', '2025-09-28 06:12:01'),
(6, '{\"ar\":\"الجزائر\",\"en\":\"Algeria\"}', '2025-09-28 06:12:01', '2025-09-28 06:12:01'),
(7, '{\"ar\":\"المغرب\",\"en\":\"Morocco\"}', '2025-09-28 06:12:01', '2025-09-28 06:12:01'),
(8, '{\"ar\":\"تونس\",\"en\":\"Tunisia\"}', '2025-09-28 06:12:01', '2025-09-28 06:12:01'),
(9, '{\"ar\":\"العراق\",\"en\":\"Iraq\"}', '2025-09-28 06:12:01', '2025-09-28 06:12:01'),
(10, '{\"ar\":\"الكويت\",\"en\":\"Kuwait\"}', '2025-09-28 06:12:02', '2025-09-28 06:12:02'),
(11, '{\"ar\":\"عمان\",\"en\":\"Oman\"}', '2025-09-28 06:12:02', '2025-09-28 06:12:02'),
(12, '{\"ar\":\"قطر\",\"en\":\"Qatar\"}', '2025-09-28 06:12:02', '2025-09-28 06:12:02'),
(13, '{\"ar\":\"البحرين\",\"en\":\"Bahrain\"}', '2025-09-28 06:12:03', '2025-09-28 06:12:03'),
(14, '{\"ar\":\"فلسطين\",\"en\":\"Palestine\"}', '2025-09-28 06:12:03', '2025-09-28 06:12:03'),
(15, '{\"ar\":\"سوريا\",\"en\":\"Syria\"}', '2025-09-28 06:12:04', '2025-09-28 06:12:04'),
(16, '{\"ar\":\"اليمن\",\"en\":\"Yemen\"}', '2025-09-28 06:12:04', '2025-09-28 06:12:04');

-- --------------------------------------------------------

--
-- Table structure for table `failed_jobs`
--

CREATE TABLE `failed_jobs` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `uuid` varchar(255) NOT NULL,
  `connection` text NOT NULL,
  `queue` text NOT NULL,
  `payload` longtext NOT NULL,
  `exception` longtext NOT NULL,
  `failed_at` timestamp NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `migrations`
--

CREATE TABLE `migrations` (
  `id` int(10) UNSIGNED NOT NULL,
  `migration` varchar(255) NOT NULL,
  `batch` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `migrations`
--

INSERT INTO `migrations` (`id`, `migration`, `batch`) VALUES
(1, '2014_10_12_000000_create_users_table', 1),
(2, '2014_10_12_100000_create_password_reset_tokens_table', 1),
(3, '2014_10_12_100000_create_password_resets_table', 1),
(4, '2019_08_19_000000_create_failed_jobs_table', 1),
(5, '2019_12_14_000001_create_personal_access_tokens_table', 1),
(6, '2025_01_31_195147_create_countries_table', 1),
(7, '2025_01_31_195616_create_states_table', 1),
(8, '2025_01_31_195637_create_cities_table', 1),
(9, '2025_09_25_060108_create_branch_categories_table', 1),
(10, '2025_09_25_062659_create_branch_types_table', 1),
(11, '2025_09_25_071042_create_company_settings_table', 1),
(12, '2025_09_25_082216_create_branches_table', 1),
(13, '2025_09_25_082331_create_branch_monthly_goals_table', 1),
(14, '2025_09_25_170137_create_service_types_table', 1),
(15, '2025_09_25_172350_create_service_categories_table', 1),
(16, '2025_09_25_184345_create_services_table', 1);

-- --------------------------------------------------------

--
-- Table structure for table `password_resets`
--

CREATE TABLE `password_resets` (
  `email` varchar(255) NOT NULL,
  `token` varchar(255) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `password_reset_tokens`
--

CREATE TABLE `password_reset_tokens` (
  `email` varchar(255) NOT NULL,
  `token` varchar(255) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `personal_access_tokens`
--

CREATE TABLE `personal_access_tokens` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `tokenable_type` varchar(255) NOT NULL,
  `tokenable_id` bigint(20) UNSIGNED NOT NULL,
  `name` varchar(255) NOT NULL,
  `token` varchar(64) NOT NULL,
  `abilities` text DEFAULT NULL,
  `last_used_at` timestamp NULL DEFAULT NULL,
  `expires_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `services`
--

CREATE TABLE `services` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `name` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL CHECK (json_valid(`name`)),
  `service_category_id` bigint(20) UNSIGNED NOT NULL,
  `service_type_id` bigint(20) UNSIGNED NOT NULL,
  `price` decimal(10,2) NOT NULL,
  `discount_price` decimal(10,2) DEFAULT NULL,
  `duration_value` int(10) UNSIGNED NOT NULL,
  `duration_unit` enum('days','months','years') NOT NULL,
  `start_time` time DEFAULT NULL,
  `end_time` time DEFAULT NULL,
  `notes` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`notes`)),
  `settings` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`settings`)),
  `active` tinyint(1) NOT NULL DEFAULT 1,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `service_categories`
--

CREATE TABLE `service_categories` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `name` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL CHECK (json_valid(`name`)),
  `description` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`description`)),
  `active` tinyint(1) NOT NULL DEFAULT 1,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `service_types`
--

CREATE TABLE `service_types` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `name` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL CHECK (json_valid(`name`)),
  `description` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`description`)),
  `active` tinyint(1) NOT NULL DEFAULT 1,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `states`
--

CREATE TABLE `states` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `name` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL CHECK (json_valid(`name`)),
  `country_id` bigint(20) UNSIGNED NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `states`
--

INSERT INTO `states` (`id`, `name`, `country_id`, `created_at`, `updated_at`) VALUES
(1, '{\"ar\":\"القاهرة\",\"en\":\"Cairo\"}', 1, '2025-09-28 06:11:59', '2025-09-28 06:11:59'),
(2, '{\"ar\":\"الإسكندرية\",\"en\":\"Alexandria\"}', 1, '2025-09-28 06:11:59', '2025-09-28 06:11:59'),
(3, '{\"ar\":\"الجيزة\",\"en\":\"Giza\"}', 1, '2025-09-28 06:12:00', '2025-09-28 06:12:00'),
(4, '{\"ar\":\"الرياض\",\"en\":\"Riyadh\"}', 2, '2025-09-28 06:12:00', '2025-09-28 06:12:00'),
(5, '{\"ar\":\"جدة\",\"en\":\"Jeddah\"}', 2, '2025-09-28 06:12:00', '2025-09-28 06:12:00'),
(6, '{\"ar\":\"مكة\",\"en\":\"Mecca\"}', 2, '2025-09-28 06:12:01', '2025-09-28 06:12:01'),
(7, '{\"ar\":\"دبي\",\"en\":\"Dubai\"}', 3, '2025-09-28 06:12:01', '2025-09-28 06:12:01'),
(8, '{\"ar\":\"أبوظبي\",\"en\":\"Abu Dhabi\"}', 3, '2025-09-28 06:12:01', '2025-09-28 06:12:01'),
(9, '{\"ar\":\"الشارقة\",\"en\":\"Sharjah\"}', 3, '2025-09-28 06:12:01', '2025-09-28 06:12:01'),
(10, '{\"ar\":\"مسقط\",\"en\":\"Muscat\"}', 11, '2025-09-28 06:12:02', '2025-09-28 06:12:02'),
(11, '{\"ar\":\"ظفار\",\"en\":\"Dhofar\"}', 11, '2025-09-28 06:12:02', '2025-09-28 06:12:02'),
(12, '{\"ar\":\"الباطنة شمال\",\"en\":\"North Batinah\"}', 11, '2025-09-28 06:12:02', '2025-09-28 06:12:02'),
(13, '{\"ar\":\"الدوحة\",\"en\":\"Doha\"}', 12, '2025-09-28 06:12:02', '2025-09-28 06:12:02'),
(14, '{\"ar\":\"الريان\",\"en\":\"Al Rayyan\"}', 12, '2025-09-28 06:12:02', '2025-09-28 06:12:02'),
(15, '{\"ar\":\"الخور\",\"en\":\"Al Khor\"}', 12, '2025-09-28 06:12:03', '2025-09-28 06:12:03'),
(16, '{\"ar\":\"المنامة\",\"en\":\"Manama\"}', 13, '2025-09-28 06:12:03', '2025-09-28 06:12:03'),
(17, '{\"ar\":\"المحرق\",\"en\":\"Muharraq\"}', 13, '2025-09-28 06:12:03', '2025-09-28 06:12:03'),
(18, '{\"ar\":\"رام الله\",\"en\":\"Ramallah\"}', 14, '2025-09-28 06:12:03', '2025-09-28 06:12:03'),
(19, '{\"ar\":\"غزة\",\"en\":\"Gaza\"}', 14, '2025-09-28 06:12:03', '2025-09-28 06:12:03'),
(20, '{\"ar\":\"دمشق\",\"en\":\"Damascus\"}', 15, '2025-09-28 06:12:04', '2025-09-28 06:12:04'),
(21, '{\"ar\":\"حلب\",\"en\":\"Aleppo\"}', 15, '2025-09-28 06:12:04', '2025-09-28 06:12:04'),
(22, '{\"ar\":\"صنعاء\",\"en\":\"Sanaa\"}', 16, '2025-09-28 06:12:04', '2025-09-28 06:12:04'),
(23, '{\"ar\":\"عدن\",\"en\":\"Aden\"}', 16, '2025-09-28 06:12:04', '2025-09-28 06:12:04');

-- --------------------------------------------------------

--
-- Table structure for table `users`
--

CREATE TABLE `users` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `name` varchar(255) NOT NULL,
  `email` varchar(255) NOT NULL,
  `email_verified_at` timestamp NULL DEFAULT NULL,
  `password` varchar(255) NOT NULL,
  `remember_token` varchar(100) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `users`
--

INSERT INTO `users` (`id`, `name`, `email`, `email_verified_at`, `password`, `remember_token`, `created_at`, `updated_at`) VALUES
(1, '{\"ar\":\"المشرف\",\"en\":\"Admin\"}', 'admin@admin.com', NULL, '$2y$10$sKdnGR5esNJN81jMQz836O6D0lY66HchM2RfmPODI3ZI5fT7sKabG', NULL, '2025-09-28 06:11:59', '2025-09-28 06:11:59');

--
-- Indexes for dumped tables
--

--
-- Indexes for table `branches`
--
ALTER TABLE `branches`
  ADD PRIMARY KEY (`id`),
  ADD KEY `branches_branch_category_id_foreign` (`branch_category_id`),
  ADD KEY `branches_branch_type_id_foreign` (`branch_type_id`),
  ADD KEY `branches_city_id_foreign` (`city_id`);

--
-- Indexes for table `branch_categories`
--
ALTER TABLE `branch_categories`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `branch_monthly_goals`
--
ALTER TABLE `branch_monthly_goals`
  ADD PRIMARY KEY (`id`),
  ADD KEY `branch_monthly_goals_branch_id_foreign` (`branch_id`);

--
-- Indexes for table `branch_service_provided`
--
ALTER TABLE `branch_service_provided`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `branch_service_provided_service_id_branch_id_unique` (`service_id`,`branch_id`),
  ADD KEY `branch_service_provided_branch_id_foreign` (`branch_id`);

--
-- Indexes for table `branch_service_sold`
--
ALTER TABLE `branch_service_sold`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `branch_service_sold_service_id_branch_id_unique` (`service_id`,`branch_id`),
  ADD KEY `branch_service_sold_branch_id_foreign` (`branch_id`);

--
-- Indexes for table `branch_types`
--
ALTER TABLE `branch_types`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `cities`
--
ALTER TABLE `cities`
  ADD PRIMARY KEY (`id`),
  ADD KEY `cities_state_id_foreign` (`state_id`);

--
-- Indexes for table `company_settings`
--
ALTER TABLE `company_settings`
  ADD PRIMARY KEY (`id`),
  ADD KEY `company_settings_country_id_foreign` (`country_id`);

--
-- Indexes for table `countries`
--
ALTER TABLE `countries`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `failed_jobs`
--
ALTER TABLE `failed_jobs`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `failed_jobs_uuid_unique` (`uuid`);

--
-- Indexes for table `migrations`
--
ALTER TABLE `migrations`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `password_resets`
--
ALTER TABLE `password_resets`
  ADD KEY `password_resets_email_index` (`email`);

--
-- Indexes for table `password_reset_tokens`
--
ALTER TABLE `password_reset_tokens`
  ADD PRIMARY KEY (`email`);

--
-- Indexes for table `personal_access_tokens`
--
ALTER TABLE `personal_access_tokens`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `personal_access_tokens_token_unique` (`token`),
  ADD KEY `personal_access_tokens_tokenable_type_tokenable_id_index` (`tokenable_type`,`tokenable_id`);

--
-- Indexes for table `services`
--
ALTER TABLE `services`
  ADD PRIMARY KEY (`id`),
  ADD KEY `services_service_category_id_foreign` (`service_category_id`),
  ADD KEY `services_service_type_id_foreign` (`service_type_id`);

--
-- Indexes for table `service_categories`
--
ALTER TABLE `service_categories`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `service_types`
--
ALTER TABLE `service_types`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `states`
--
ALTER TABLE `states`
  ADD PRIMARY KEY (`id`),
  ADD KEY `states_country_id_foreign` (`country_id`);

--
-- Indexes for table `users`
--
ALTER TABLE `users`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `users_email_unique` (`email`);

--
-- AUTO_INCREMENT for dumped tables
--

--
-- AUTO_INCREMENT for table `branches`
--
ALTER TABLE `branches`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `branch_categories`
--
ALTER TABLE `branch_categories`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `branch_monthly_goals`
--
ALTER TABLE `branch_monthly_goals`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `branch_service_provided`
--
ALTER TABLE `branch_service_provided`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `branch_service_sold`
--
ALTER TABLE `branch_service_sold`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `branch_types`
--
ALTER TABLE `branch_types`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `cities`
--
ALTER TABLE `cities`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=7;

--
-- AUTO_INCREMENT for table `company_settings`
--
ALTER TABLE `company_settings`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=2;

--
-- AUTO_INCREMENT for table `countries`
--
ALTER TABLE `countries`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=17;

--
-- AUTO_INCREMENT for table `failed_jobs`
--
ALTER TABLE `failed_jobs`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `migrations`
--
ALTER TABLE `migrations`
  MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=17;

--
-- AUTO_INCREMENT for table `personal_access_tokens`
--
ALTER TABLE `personal_access_tokens`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `services`
--
ALTER TABLE `services`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `service_categories`
--
ALTER TABLE `service_categories`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `service_types`
--
ALTER TABLE `service_types`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `states`
--
ALTER TABLE `states`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=24;

--
-- AUTO_INCREMENT for table `users`
--
ALTER TABLE `users`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=2;

--
-- Constraints for dumped tables
--

--
-- Constraints for table `branches`
--
ALTER TABLE `branches`
  ADD CONSTRAINT `branches_branch_category_id_foreign` FOREIGN KEY (`branch_category_id`) REFERENCES `branch_categories` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `branches_branch_type_id_foreign` FOREIGN KEY (`branch_type_id`) REFERENCES `branch_types` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `branches_city_id_foreign` FOREIGN KEY (`city_id`) REFERENCES `states` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `branch_monthly_goals`
--
ALTER TABLE `branch_monthly_goals`
  ADD CONSTRAINT `branch_monthly_goals_branch_id_foreign` FOREIGN KEY (`branch_id`) REFERENCES `branches` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `branch_service_provided`
--
ALTER TABLE `branch_service_provided`
  ADD CONSTRAINT `branch_service_provided_branch_id_foreign` FOREIGN KEY (`branch_id`) REFERENCES `branches` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `branch_service_provided_service_id_foreign` FOREIGN KEY (`service_id`) REFERENCES `services` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `branch_service_sold`
--
ALTER TABLE `branch_service_sold`
  ADD CONSTRAINT `branch_service_sold_branch_id_foreign` FOREIGN KEY (`branch_id`) REFERENCES `branches` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `branch_service_sold_service_id_foreign` FOREIGN KEY (`service_id`) REFERENCES `services` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `cities`
--
ALTER TABLE `cities`
  ADD CONSTRAINT `cities_state_id_foreign` FOREIGN KEY (`state_id`) REFERENCES `states` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `company_settings`
--
ALTER TABLE `company_settings`
  ADD CONSTRAINT `company_settings_country_id_foreign` FOREIGN KEY (`country_id`) REFERENCES `countries` (`id`) ON DELETE SET NULL;

--
-- Constraints for table `services`
--
ALTER TABLE `services`
  ADD CONSTRAINT `services_service_category_id_foreign` FOREIGN KEY (`service_category_id`) REFERENCES `service_categories` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `services_service_type_id_foreign` FOREIGN KEY (`service_type_id`) REFERENCES `service_types` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `states`
--
ALTER TABLE `states`
  ADD CONSTRAINT `states_country_id_foreign` FOREIGN KEY (`country_id`) REFERENCES `countries` (`id`) ON DELETE CASCADE;
COMMIT;

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
