-- phpMyAdmin SQL Dump
-- version 5.2.1
-- https://www.phpmyadmin.net/
--
-- Host: localhost:3306
-- Generation Time: 18 يناير 2026 الساعة 19:58
-- إصدار الخادم: 10.11.14-MariaDB
-- PHP Version: 8.3.14

SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
START TRANSACTION;
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;

--
-- Database: `smartfitnesscom_pioneer`
--

-- --------------------------------------------------------

--
-- بنية الجدول `branches`
--

CREATE TABLE `branches` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `branch_code` varchar(10) NOT NULL,
  `name` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL CHECK (json_valid(`name`)),
  `branch_category_id` bigint(20) UNSIGNED NOT NULL,
  `branch_type_id` bigint(20) UNSIGNED NOT NULL,
  `city_id` bigint(20) UNSIGNED NOT NULL,
  `primary_phone` varchar(255) NOT NULL,
  `phones` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`phones`)),
  `active` tinyint(1) NOT NULL DEFAULT 1,
  `address` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`address`)),
  `min_age` tinyint(3) UNSIGNED DEFAULT NULL,
  `max_discount_percent` decimal(5,2) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- إرجاع أو استيراد بيانات الجدول `branches`
--

INSERT INTO `branches` (`id`, `branch_code`, `name`, `branch_category_id`, `branch_type_id`, `city_id`, `primary_phone`, `phones`, `active`, `address`, `min_age`, `max_discount_percent`, `created_at`, `updated_at`) VALUES
(1, '001', '{\"ar\":\"فرع الصفا\",\"en\":\"Al-Safa Branch\"}', 1, 2, 5, '0559136671', '[{\"label\":{\"ar\":\"\\u0647\\u0627\\u062a\\u0641 \\u0627\\u0644\\u0646\\u0627\\u062f\\u064a\",\"en\":\"Mobile Club\"},\"number\":\"0559136671\"}]', 1, '{\"full\":{\"ar\":\"\\u062c\\u062f\\u0629\",\"en\":null},\"short\":{\"ar\":\"\\u062d\\u064a \\u0627\\u0644\\u0635\\u0641\\u0627\",\"en\":null},\"street\":{\"ar\":\"\\u0634\\u0627\\u0631\\u0639 \\u0627\\u0644\\u0627\\u0645\\u064a\\u0631 \\u0645\\u062a\\u0639\\u0628\",\"en\":null},\"district\":{\"ar\":\"\\u062d\\u064a \\u0627\\u0644\\u0635\\u0641\\u0627\",\"en\":null},\"building_no\":\"123456\",\"postal_code\":\"203060\",\"tax_no\":null}', 16, NULL, '2025-12-04 02:26:04', '2025-12-04 02:26:04');

-- --------------------------------------------------------

--
-- بنية الجدول `branch_categories`
--

CREATE TABLE `branch_categories` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `name` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL CHECK (json_valid(`name`)),
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- إرجاع أو استيراد بيانات الجدول `branch_categories`
--

INSERT INTO `branch_categories` (`id`, `name`, `created_at`, `updated_at`) VALUES
(1, '{\"ar\":\"الفئة الاحترافية\",\"en\":\"Professional Category\"}', '2025-10-19 04:46:25', '2025-12-04 02:18:13'),
(2, '{\"ar\":\"الفئة الاقتصادية\",\"en\":\"Economy Category\"}', '2025-10-19 04:46:25', '2025-12-04 02:18:34'),
(3, '{\"ar\":\"فئة سولد جيم\",\"en\":\"Solid Gym Category\"}', '2025-10-19 04:46:25', '2025-12-04 02:19:44'),
(4, '{\"en\":\"12\",\"ar\":\"12\"}', '2025-12-04 02:16:09', '2025-12-04 02:19:04'),
(5, '{\"en\":\"23\",\"ar\":\"23\"}', '2025-12-04 02:16:30', '2025-12-04 02:19:11');

-- --------------------------------------------------------

--
-- بنية الجدول `branch_monthly_goals`
--

CREATE TABLE `branch_monthly_goals` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `branch_id` bigint(20) UNSIGNED NOT NULL,
  `year` smallint(6) NOT NULL,
  `month` tinyint(4) NOT NULL,
  `actual` decimal(12,2) NOT NULL DEFAULT 0.00,
  `target` decimal(12,2) NOT NULL DEFAULT 0.00,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- بنية الجدول `branch_service_provided`
--

CREATE TABLE `branch_service_provided` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `service_id` bigint(20) UNSIGNED NOT NULL,
  `branch_id` bigint(20) UNSIGNED NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- إرجاع أو استيراد بيانات الجدول `branch_service_provided`
--

INSERT INTO `branch_service_provided` (`id`, `service_id`, `branch_id`) VALUES
(2, 1, 2),
(1, 1, 3),
(3, 2, 3);

-- --------------------------------------------------------

--
-- بنية الجدول `branch_service_sold`
--

CREATE TABLE `branch_service_sold` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `service_id` bigint(20) UNSIGNED NOT NULL,
  `branch_id` bigint(20) UNSIGNED NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- إرجاع أو استيراد بيانات الجدول `branch_service_sold`
--

INSERT INTO `branch_service_sold` (`id`, `service_id`, `branch_id`) VALUES
(2, 1, 1),
(1, 1, 2),
(3, 2, 2);

-- --------------------------------------------------------

--
-- بنية الجدول `branch_types`
--

CREATE TABLE `branch_types` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `name` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL CHECK (json_valid(`name`)),
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- إرجاع أو استيراد بيانات الجدول `branch_types`
--

INSERT INTO `branch_types` (`id`, `name`, `created_at`, `updated_at`) VALUES
(1, '{\"ar\":\"الإدارات\",\"en\":\"Departments\"}', '2025-10-19 04:46:25', '2025-12-04 02:20:30'),
(2, '{\"ar\":\"الصالات الرجالية\",\"en\":\"Men Gym\"}', '2025-10-19 04:46:25', '2025-12-04 02:20:51'),
(3, '{\"ar\":\"الصالات النسائية\",\"en\":\"Ladies Gym\"}', '2025-10-19 04:46:25', '2025-12-04 02:21:10'),
(4, '{\"en\":\"Kids Gym\",\"ar\":\"صالات الأصفال\"}', '2025-12-04 02:21:25', '2025-12-04 02:21:25'),
(5, '{\"en\":\"Family Gym\",\"ar\":\"الصالات العائلية\"}', '2025-12-04 02:21:41', '2025-12-04 02:21:41'),
(6, '{\"en\":\"On Cloud Applications\",\"ar\":\"التطبيقات السحابية\"}', '2025-12-04 02:22:07', '2025-12-04 02:22:07');

-- --------------------------------------------------------

--
-- بنية الجدول `cities`
--

CREATE TABLE `cities` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `name` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL CHECK (json_valid(`name`)),
  `state_id` bigint(20) UNSIGNED NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- إرجاع أو استيراد بيانات الجدول `cities`
--

INSERT INTO `cities` (`id`, `name`, `state_id`, `created_at`, `updated_at`) VALUES
(1, '{\"ar\":\"مدينة نصر\",\"en\":\"Nasr City\"}', 1, '2025-10-19 04:46:20', '2025-10-19 04:46:20'),
(2, '{\"ar\":\"الزمالك\",\"en\":\"Zamalek\"}', 1, '2025-10-19 04:46:20', '2025-10-19 04:46:20'),
(3, '{\"ar\":\"الملز\",\"en\":\"Olaya\"}', 4, '2025-10-19 04:46:20', '2025-10-19 04:46:20'),
(4, '{\"ar\":\"الخبر\",\"en\":\"Al-Khobar\"}', 4, '2025-10-19 04:46:20', '2025-10-19 04:46:20'),
(5, '{\"ar\":\"الخليج الغربي\",\"en\":\"West Bay\"}', 13, '2025-10-19 04:46:22', '2025-10-19 04:46:22'),
(6, '{\"ar\":\"السد\",\"en\":\"Al Sadd\"}', 13, '2025-10-19 04:46:22', '2025-10-19 04:46:22');

-- --------------------------------------------------------

--
-- بنية الجدول `company_settings`
--

CREATE TABLE `company_settings` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `name` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL CHECK (json_valid(`name`)),
  `logo_path` varchar(255) DEFAULT NULL,
  `primary_color` varchar(255) NOT NULL DEFAULT '#0ea5b6',
  `secondary_color` varchar(255) NOT NULL DEFAULT '#1e293b',
  `email` varchar(255) DEFAULT NULL,
  `phones` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`phones`)),
  `country_id` bigint(20) UNSIGNED DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- إرجاع أو استيراد بيانات الجدول `company_settings`
--

INSERT INTO `company_settings` (`id`, `name`, `logo_path`, `primary_color`, `secondary_color`, `email`, `phones`, `country_id`, `created_at`, `updated_at`) VALUES
(1, '{\"ar\":\"الشركة النموذجية\",\"en\":\"Demo Company\"}', NULL, '#0ea5b6', '#1e293b', 'info@example.com', '[{\"label\":{\"ar\":\"\\u0627\\u0644\\u0645\\u0628\\u064a\\u0639\\u0627\\u062a\",\"en\":\"Sales\"},\"number\":\"+201234567890\"},{\"label\":{\"ar\":\"\\u0627\\u0644\\u062f\\u0639\\u0645\",\"en\":\"Support\"},\"number\":\"+201112223334\"}]', 2, '2025-10-19 04:46:24', '2025-10-19 04:46:24');

-- --------------------------------------------------------

--
-- بنية الجدول `countries`
--

CREATE TABLE `countries` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `name` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL CHECK (json_valid(`name`)),
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- إرجاع أو استيراد بيانات الجدول `countries`
--

INSERT INTO `countries` (`id`, `name`, `created_at`, `updated_at`) VALUES
(1, '{\"ar\":\"مصر\",\"en\":\"Egypt\"}', '2025-10-19 04:46:20', '2025-10-19 04:46:20'),
(2, '{\"ar\":\"السعودية\",\"en\":\"Saudi Arabia\"}', '2025-10-19 04:46:20', '2025-10-19 04:46:20'),
(3, '{\"ar\":\"الإمارات\",\"en\":\"United Arab Emirates\"}', '2025-10-19 04:46:21', '2025-10-19 04:46:21'),
(4, '{\"ar\":\"الأردن\",\"en\":\"Jordan\"}', '2025-10-19 04:46:21', '2025-10-19 04:46:21'),
(5, '{\"ar\":\"لبنان\",\"en\":\"Lebanon\"}', '2025-10-19 04:46:21', '2025-10-19 04:46:21'),
(6, '{\"ar\":\"الجزائر\",\"en\":\"Algeria\"}', '2025-10-19 04:46:21', '2025-10-19 04:46:21'),
(7, '{\"ar\":\"المغرب\",\"en\":\"Morocco\"}', '2025-10-19 04:46:21', '2025-10-19 04:46:21'),
(8, '{\"ar\":\"تونس\",\"en\":\"Tunisia\"}', '2025-10-19 04:46:21', '2025-10-19 04:46:21'),
(9, '{\"ar\":\"العراق\",\"en\":\"Iraq\"}', '2025-10-19 04:46:21', '2025-10-19 04:46:21'),
(10, '{\"ar\":\"الكويت\",\"en\":\"Kuwait\"}', '2025-10-19 04:46:21', '2025-10-19 04:46:21'),
(11, '{\"ar\":\"عمان\",\"en\":\"Oman\"}', '2025-10-19 04:46:21', '2025-10-19 04:46:21'),
(12, '{\"ar\":\"قطر\",\"en\":\"Qatar\"}', '2025-10-19 04:46:22', '2025-10-19 04:46:22'),
(13, '{\"ar\":\"البحرين\",\"en\":\"Bahrain\"}', '2025-10-19 04:46:23', '2025-10-19 04:46:23'),
(14, '{\"ar\":\"فلسطين\",\"en\":\"Palestine\"}', '2025-10-19 04:46:23', '2025-10-19 04:46:23'),
(15, '{\"ar\":\"سوريا\",\"en\":\"Syria\"}', '2025-10-19 04:46:23', '2025-10-19 04:46:23'),
(16, '{\"ar\":\"اليمن\",\"en\":\"Yemen\"}', '2025-10-19 04:46:23', '2025-10-19 04:46:23');

-- --------------------------------------------------------

--
-- بنية الجدول `customers`
--

CREATE TABLE `customers` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `customer_code` varchar(7) NOT NULL,
  `branch_id` bigint(20) UNSIGNED NOT NULL,
  `name` varchar(255) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- إرجاع أو استيراد بيانات الجدول `customers`
--

INSERT INTO `customers` (`id`, `customer_code`, `branch_id`, `name`, `created_at`, `updated_at`) VALUES
(1, '0100001', 1, 'elkady', '2025-10-22 03:04:01', '2025-10-22 03:04:01'),
(2, '0100002', 1, 'Elkady for software\'s', '2025-10-22 03:15:58', '2025-10-22 03:15:58');

-- --------------------------------------------------------

--
-- بنية الجدول `failed_jobs`
--

CREATE TABLE `failed_jobs` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `uuid` varchar(255) NOT NULL,
  `connection` text NOT NULL,
  `queue` text NOT NULL,
  `payload` longtext NOT NULL,
  `exception` longtext NOT NULL,
  `failed_at` timestamp NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- بنية الجدول `members`
--

CREATE TABLE `members` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `member_code` char(7) NOT NULL,
  `branch_id` bigint(20) UNSIGNED NOT NULL,
  `status` enum('new','active','inactive') NOT NULL DEFAULT 'new',
  `id_type` enum('national_id','residence','passport','driving_license','work_card') DEFAULT NULL,
  `id_number` varchar(20) DEFAULT NULL,
  `id_issue_greg` date DEFAULT NULL,
  `id_expiry_greg` date DEFAULT NULL,
  `id_issue_hijri` varchar(20) DEFAULT NULL,
  `id_expiry_hijri` varchar(20) DEFAULT NULL,
  `name` varchar(255) NOT NULL,
  `gender` enum('male','female') DEFAULT NULL,
  `nationality_id` bigint(20) UNSIGNED DEFAULT NULL,
  `birth_greg` date DEFAULT NULL,
  `birth_hijri` varchar(20) DEFAULT NULL,
  `age` smallint(5) UNSIGNED DEFAULT NULL,
  `phone` varchar(30) DEFAULT NULL,
  `email` varchar(255) DEFAULT NULL,
  `po_box` varchar(50) DEFAULT NULL,
  `postal_code` varchar(20) DEFAULT NULL,
  `address` varchar(255) DEFAULT NULL,
  `avatar_path` varchar(255) DEFAULT NULL,
  `id_image_path` varchar(255) DEFAULT NULL,
  `work_card_image_path` varchar(255) DEFAULT NULL,
  `how_heard` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`how_heard`)),
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- بنية الجدول `member_sequences`
--

CREATE TABLE `member_sequences` (
  `branch_id` bigint(20) UNSIGNED NOT NULL,
  `prefix` char(2) NOT NULL,
  `last_seq` int(10) UNSIGNED NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- بنية الجدول `migrations`
--

CREATE TABLE `migrations` (
  `id` int(10) UNSIGNED NOT NULL,
  `migration` varchar(255) NOT NULL,
  `batch` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- إرجاع أو استيراد بيانات الجدول `migrations`
--

INSERT INTO `migrations` (`id`, `migration`, `batch`) VALUES
(1, '2014_01_20_195147_create_countries_table', 1),
(2, '2014_01_20_195616_create_states_table', 1),
(3, '2014_01_20_195637_create_cities_table', 1),
(4, '2014_01_25_060108_create_branch_categories_table', 1),
(5, '2014_01_25_062659_create_branch_types_table', 1),
(6, '2014_01_25_082216_create_branches_table', 1),
(7, '2014_10_12_000000_create_users_table', 1),
(8, '2014_10_12_100000_create_password_reset_tokens_table', 1),
(9, '2014_10_12_100000_create_password_resets_table', 1),
(10, '2019_08_19_000000_create_failed_jobs_table', 1),
(11, '2019_12_14_000001_create_personal_access_tokens_table', 1),
(12, '2025_09_25_071042_create_company_settings_table', 1),
(13, '2025_09_25_082331_create_branch_monthly_goals_table', 1),
(14, '2025_09_25_170137_create_service_types_table', 1),
(15, '2025_09_25_172350_create_service_categories_table', 1),
(16, '2025_09_25_184345_create_services_table', 1),
(17, '2025_10_03_195032_create_customers_table', 1),
(18, '2025_10_03_204536_create_members_table', 1),
(19, '2025_10_03_231239_create_member_sequences_table', 1),
(20, '2025_10_06_075050_create_offers_table', 1),
(21, '2025_10_06_075203_create_offer_items_table', 1),
(22, '2025_10_18_120945_create_permission_tables', 1);

-- --------------------------------------------------------

--
-- بنية الجدول `model_has_permissions`
--

CREATE TABLE `model_has_permissions` (
  `permission_id` bigint(20) UNSIGNED NOT NULL,
  `model_type` varchar(255) NOT NULL,
  `model_id` bigint(20) UNSIGNED NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- بنية الجدول `model_has_roles`
--

CREATE TABLE `model_has_roles` (
  `role_id` bigint(20) UNSIGNED NOT NULL,
  `model_type` varchar(255) NOT NULL,
  `model_id` bigint(20) UNSIGNED NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- إرجاع أو استيراد بيانات الجدول `model_has_roles`
--

INSERT INTO `model_has_roles` (`role_id`, `model_type`, `model_id`) VALUES
(1, 'App\\Models\\User', 1),
(1, 'App\\Models\\User', 2),
(1, 'App\\Models\\User', 3);

-- --------------------------------------------------------

--
-- بنية الجدول `offers`
--

CREATE TABLE `offers` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `offer_no` bigint(20) UNSIGNED NOT NULL,
  `name` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL CHECK (json_valid(`name`)),
  `scope` enum('all','members','customers','coupons') NOT NULL DEFAULT 'all',
  `target_member_ids` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`target_member_ids`)),
  `target_customer_ids` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`target_customer_ids`)),
  `coupon_codes` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`coupon_codes`)),
  `start_date_g` date NOT NULL,
  `end_date_g` date NOT NULL,
  `start_date_h` varchar(20) DEFAULT NULL,
  `end_date_h` varchar(20) DEFAULT NULL,
  `duration_days` int(10) UNSIGNED NOT NULL DEFAULT 0,
  `discount_type` enum('percent','amount') NOT NULL DEFAULT 'percent',
  `discount_value` decimal(10,2) NOT NULL DEFAULT 0.00,
  `extra_days` int(10) UNSIGNED NOT NULL DEFAULT 0,
  `active` tinyint(1) NOT NULL DEFAULT 1,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- بنية الجدول `offer_items`
--

CREATE TABLE `offer_items` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `offer_id` bigint(20) UNSIGNED NOT NULL,
  `service_id` bigint(20) UNSIGNED NOT NULL,
  `service_name` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL CHECK (json_valid(`service_name`)),
  `base_price` decimal(10,2) NOT NULL,
  `base_duration_value` int(10) UNSIGNED NOT NULL,
  `base_duration_unit` enum('days','months','years') NOT NULL,
  `row_discount_type` enum('percent','amount') DEFAULT NULL,
  `row_discount_value` decimal(10,2) DEFAULT NULL,
  `row_extra_days` int(10) UNSIGNED DEFAULT NULL,
  `final_price` decimal(10,2) NOT NULL,
  `final_duration_value` int(10) UNSIGNED NOT NULL,
  `final_duration_unit` enum('days','months','years') NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- بنية الجدول `password_resets`
--

CREATE TABLE `password_resets` (
  `email` varchar(255) NOT NULL,
  `token` varchar(255) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- بنية الجدول `password_reset_tokens`
--

CREATE TABLE `password_reset_tokens` (
  `email` varchar(255) NOT NULL,
  `token` varchar(255) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- بنية الجدول `payment_methods`
--

CREATE TABLE `payment_methods` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `name_ar` varchar(100) NOT NULL,
  `name_en` varchar(100) NOT NULL,
  `code` varchar(30) DEFAULT NULL,
  `active` tinyint(1) DEFAULT 1,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- إرجاع أو استيراد بيانات الجدول `payment_methods`
--

INSERT INTO `payment_methods` (`id`, `name_ar`, `name_en`, `code`, `active`, `created_at`, `updated_at`) VALUES
(1, 'نقدي', 'Cash', 'cash', 1, '2025-10-28 07:07:08', '2025-10-28 07:07:08'),
(2, 'بطاقة بنكية', 'Card', 'card', 1, '2025-10-28 07:07:08', '2025-10-28 07:07:08'),
(3, 'تحويل بنكي', 'Bank Transfer', 'bank', 1, '2025-10-28 07:07:08', '2025-10-28 07:07:08'),
(4, 'مدى', 'Mada', 'mada', 1, '2025-10-28 07:07:08', '2025-10-28 07:07:08'),
(5, 'Apple Pay', 'Apple Pay', 'apple', 1, '2025-10-28 07:07:08', '2025-10-28 07:07:08'),
(6, 'Google Pay', 'Google Pay', 'google', 1, '2025-10-28 07:07:08', '2025-10-28 07:07:08'),
(7, 'بطاقة إئتمانية', 'Credit Card', '7', 1, '2025-10-29 03:11:51', '2025-10-29 03:11:51');

-- --------------------------------------------------------

--
-- بنية الجدول `permissions`
--

CREATE TABLE `permissions` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `name` varchar(255) NOT NULL,
  `guard_name` varchar(255) NOT NULL,
  `branch_id` bigint(20) UNSIGNED DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- إرجاع أو استيراد بيانات الجدول `permissions`
--

INSERT INTO `permissions` (`id`, `name`, `guard_name`, `branch_id`, `created_at`, `updated_at`) VALUES
(1, 'users.view', 'web', NULL, '2025-10-19 04:46:24', '2025-10-19 04:46:24'),
(2, 'users.create', 'web', NULL, '2025-10-19 04:46:24', '2025-10-19 04:46:24'),
(3, 'users.edit', 'web', NULL, '2025-10-19 04:46:24', '2025-10-19 04:46:24'),
(4, 'users.delete', 'web', NULL, '2025-10-19 04:46:24', '2025-10-19 04:46:24'),
(5, 'roles.view', 'web', NULL, '2025-10-19 04:46:24', '2025-10-19 04:46:24'),
(6, 'roles.create', 'web', NULL, '2025-10-19 04:46:24', '2025-10-19 04:46:24'),
(7, 'roles.edit', 'web', NULL, '2025-10-19 04:46:24', '2025-10-19 04:46:24'),
(8, 'roles.delete', 'web', NULL, '2025-10-19 04:46:24', '2025-10-19 04:46:24'),
(9, 'branches.view', 'web', NULL, '2025-10-19 04:46:24', '2025-10-19 04:46:24'),
(10, 'branches.create', 'web', NULL, '2025-10-19 04:46:24', '2025-10-19 04:46:24'),
(11, 'branches.edit', 'web', NULL, '2025-10-19 04:46:24', '2025-10-19 04:46:24'),
(12, 'branches.delete', 'web', NULL, '2025-10-19 04:46:24', '2025-10-19 04:46:24'),
(13, 'reports.view', 'web', NULL, '2025-10-19 04:46:25', '2025-10-19 04:46:25'),
(14, 'reports.export', 'web', NULL, '2025-10-19 04:46:25', '2025-10-19 04:46:25');

-- --------------------------------------------------------

--
-- بنية الجدول `personal_access_tokens`
--

CREATE TABLE `personal_access_tokens` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `tokenable_type` varchar(255) NOT NULL,
  `tokenable_id` bigint(20) UNSIGNED NOT NULL,
  `name` varchar(255) NOT NULL,
  `token` varchar(64) NOT NULL,
  `abilities` text DEFAULT NULL,
  `last_used_at` timestamp NULL DEFAULT NULL,
  `expires_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- بنية الجدول `roles`
--

CREATE TABLE `roles` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `name` varchar(255) NOT NULL,
  `guard_name` varchar(255) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- إرجاع أو استيراد بيانات الجدول `roles`
--

INSERT INTO `roles` (`id`, `name`, `guard_name`, `created_at`, `updated_at`) VALUES
(1, 'super_admin', 'web', '2025-10-19 04:46:25', '2025-10-19 04:46:25');

-- --------------------------------------------------------

--
-- بنية الجدول `role_has_permissions`
--

CREATE TABLE `role_has_permissions` (
  `permission_id` bigint(20) UNSIGNED NOT NULL,
  `role_id` bigint(20) UNSIGNED NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- إرجاع أو استيراد بيانات الجدول `role_has_permissions`
--

INSERT INTO `role_has_permissions` (`permission_id`, `role_id`) VALUES
(1, 1),
(2, 1),
(3, 1),
(4, 1),
(5, 1),
(6, 1),
(7, 1),
(8, 1),
(9, 1),
(10, 1),
(11, 1),
(12, 1),
(13, 1),
(14, 1);

-- --------------------------------------------------------

--
-- بنية الجدول `services`
--

CREATE TABLE `services` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `service_code` varchar(10) DEFAULT NULL,
  `name` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL CHECK (json_valid(`name`)),
  `service_category_id` bigint(20) UNSIGNED NOT NULL,
  `service_type_id` bigint(20) UNSIGNED NOT NULL,
  `price` decimal(10,2) NOT NULL,
  `duration_value` int(10) UNSIGNED NOT NULL,
  `duration_unit` enum('days','months','years') NOT NULL,
  `start_time` time DEFAULT NULL,
  `end_time` time DEFAULT NULL,
  `notes` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`notes`)),
  `settings` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`settings`)),
  `active` tinyint(1) NOT NULL DEFAULT 1,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- بنية الجدول `service_categories`
--

CREATE TABLE `service_categories` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `name` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL CHECK (json_valid(`name`)),
  `description` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`description`)),
  `active` tinyint(1) NOT NULL DEFAULT 1,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- إرجاع أو استيراد بيانات الجدول `service_categories`
--

INSERT INTO `service_categories` (`id`, `name`, `description`, `active`, `created_at`, `updated_at`) VALUES
(1, '{\"en\":\"General Memberships\",\"ar\":\"الاشتراكات العامة\"}', '{\"en\":\"Voluptatum blanditii\",\"ar\":\"Iure minima voluptat\"}', 1, '2025-10-22 03:33:25', '2025-11-17 01:58:17'),
(2, '{\"en\":\"Personal Memberships\",\"ar\":\"إشتراكات التدريب الشخصي\"}', '{\"ar\":null}', 1, '2025-11-17 01:58:53', '2025-11-17 01:58:53'),
(3, '{\"en\":\"Swimming Personal Training Memberships\",\"ar\":\"إشتراكات التدريب الشخصي سباحة\"}', '{\"ar\":null}', 1, '2025-11-17 02:01:26', '2025-11-17 02:01:26');

-- --------------------------------------------------------

--
-- بنية الجدول `service_invoices`
--

CREATE TABLE `service_invoices` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `document_no` bigint(20) UNSIGNED NOT NULL,
  `invoice_no` varchar(255) NOT NULL,
  `branch_id` bigint(20) UNSIGNED DEFAULT NULL,
  `member_id` bigint(20) UNSIGNED DEFAULT NULL,
  `provider_user_id` bigint(20) UNSIGNED DEFAULT NULL,
  `service_user_id` bigint(20) UNSIGNED DEFAULT NULL,
  `created_by` bigint(20) UNSIGNED DEFAULT NULL,
  `account_user_id` bigint(20) UNSIGNED DEFAULT NULL,
  `greg_date` date NOT NULL,
  `hijri_date` varchar(255) DEFAULT NULL,
  `notes` text DEFAULT NULL,
  `payment_methods` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`payment_methods`)),
  `total_price` decimal(10,2) DEFAULT 0.00,
  `total_discount` decimal(10,2) DEFAULT 0.00,
  `total_tax` decimal(10,2) DEFAULT 0.00,
  `total_net` decimal(10,2) DEFAULT 0.00,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- بنية الجدول `service_invoice_items`
--

CREATE TABLE `service_invoice_items` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `service_invoice_id` bigint(20) UNSIGNED NOT NULL,
  `type` enum('service','offer') DEFAULT NULL,
  `service_id` bigint(20) UNSIGNED DEFAULT NULL,
  `offer_id` bigint(20) UNSIGNED DEFAULT NULL,
  `offer_service_id` bigint(20) UNSIGNED DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `qty` int(10) UNSIGNED DEFAULT 1,
  `price` decimal(10,2) DEFAULT 0.00,
  `discount` decimal(10,2) DEFAULT 0.00,
  `tax` decimal(10,2) DEFAULT 0.00,
  `total` decimal(10,2) DEFAULT 0.00,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- بنية الجدول `service_types`
--

CREATE TABLE `service_types` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `name` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL CHECK (json_valid(`name`)),
  `description` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`description`)),
  `active` tinyint(1) NOT NULL DEFAULT 1,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- إرجاع أو استيراد بيانات الجدول `service_types`
--

INSERT INTO `service_types` (`id`, `name`, `description`, `active`, `created_at`, `updated_at`) VALUES
(1, '{\"en\":\"Membership\",\"ar\":\"عضوية\"}', '{\"en\":\"Perferendis itaque o\",\"ar\":\"Cupiditate ut tenetu\"}', 1, '2025-10-22 03:31:25', '2025-11-17 01:53:08'),
(2, '{\"en\":\"Cards\",\"ar\":\"بطاقات\"}', '{\"en\":\"General Memberships\",\"ar\":\"الاشتراكات العامة\"}', 1, '2025-10-23 06:32:01', '2025-11-17 01:52:54'),
(3, '{\"en\":\"Services\",\"ar\":\"خدمات\"}', '{\"en\":\"Personal Trainning Memberships\",\"ar\":\"اشتراكات التدريب الشخصي\"}', 1, '2025-10-23 06:33:21', '2025-11-17 01:54:19'),
(4, '{\"en\":\"Additional Features\",\"ar\":\"ميزات إضافية\"}', '{\"en\":\"Swimming Pool Personal Trainning\",\"ar\":\"اشتراكات السباحة\"}', 1, '2025-10-23 06:34:34', '2025-11-17 01:55:22');

-- --------------------------------------------------------

--
-- بنية الجدول `states`
--

CREATE TABLE `states` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `name` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL CHECK (json_valid(`name`)),
  `country_id` bigint(20) UNSIGNED NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- إرجاع أو استيراد بيانات الجدول `states`
--

INSERT INTO `states` (`id`, `name`, `country_id`, `created_at`, `updated_at`) VALUES
(1, '{\"ar\":\"القاهرة\",\"en\":\"Cairo\"}', 1, '2025-10-19 04:46:20', '2025-10-19 04:46:20'),
(2, '{\"ar\":\"الإسكندرية\",\"en\":\"Alexandria\"}', 1, '2025-10-19 04:46:20', '2025-10-19 04:46:20'),
(3, '{\"ar\":\"الجيزة\",\"en\":\"Giza\"}', 1, '2025-10-19 04:46:20', '2025-10-19 04:46:20'),
(4, '{\"ar\":\"الرياض\",\"en\":\"Riyadh\"}', 2, '2025-10-19 04:46:20', '2025-10-19 04:46:20'),
(5, '{\"ar\":\"جدة\",\"en\":\"Jeddah\"}', 2, '2025-10-19 04:46:21', '2025-10-19 04:46:21'),
(6, '{\"ar\":\"مكة\",\"en\":\"Mecca\"}', 2, '2025-10-19 04:46:21', '2025-10-19 04:46:21'),
(7, '{\"ar\":\"دبي\",\"en\":\"Dubai\"}', 3, '2025-10-19 04:46:21', '2025-10-19 04:46:21'),
(8, '{\"ar\":\"أبوظبي\",\"en\":\"Abu Dhabi\"}', 3, '2025-10-19 04:46:21', '2025-10-19 04:46:21'),
(9, '{\"ar\":\"الشارقة\",\"en\":\"Sharjah\"}', 3, '2025-10-19 04:46:21', '2025-10-19 04:46:21'),
(10, '{\"ar\":\"مسقط\",\"en\":\"Muscat\"}', 11, '2025-10-19 04:46:22', '2025-10-19 04:46:22'),
(11, '{\"ar\":\"ظفار\",\"en\":\"Dhofar\"}', 11, '2025-10-19 04:46:22', '2025-10-19 04:46:22'),
(12, '{\"ar\":\"الباطنة شمال\",\"en\":\"North Batinah\"}', 11, '2025-10-19 04:46:22', '2025-10-19 04:46:22'),
(13, '{\"ar\":\"الدوحة\",\"en\":\"Doha\"}', 12, '2025-10-19 04:46:22', '2025-10-19 04:46:22'),
(14, '{\"ar\":\"الريان\",\"en\":\"Al Rayyan\"}', 12, '2025-10-19 04:46:22', '2025-10-19 04:46:22'),
(15, '{\"ar\":\"الخور\",\"en\":\"Al Khor\"}', 12, '2025-10-19 04:46:23', '2025-10-19 04:46:23'),
(16, '{\"ar\":\"المنامة\",\"en\":\"Manama\"}', 13, '2025-10-19 04:46:23', '2025-10-19 04:46:23'),
(17, '{\"ar\":\"المحرق\",\"en\":\"Muharraq\"}', 13, '2025-10-19 04:46:23', '2025-10-19 04:46:23'),
(18, '{\"ar\":\"رام الله\",\"en\":\"Ramallah\"}', 14, '2025-10-19 04:46:23', '2025-10-19 04:46:23'),
(19, '{\"ar\":\"غزة\",\"en\":\"Gaza\"}', 14, '2025-10-19 04:46:23', '2025-10-19 04:46:23'),
(20, '{\"ar\":\"دمشق\",\"en\":\"Damascus\"}', 15, '2025-10-19 04:46:23', '2025-10-19 04:46:23'),
(21, '{\"ar\":\"حلب\",\"en\":\"Aleppo\"}', 15, '2025-10-19 04:46:23', '2025-10-19 04:46:23'),
(22, '{\"ar\":\"صنعاء\",\"en\":\"Sanaa\"}', 16, '2025-10-19 04:46:23', '2025-10-19 04:46:23'),
(23, '{\"ar\":\"عدن\",\"en\":\"Aden\"}', 16, '2025-10-19 04:46:23', '2025-10-19 04:46:23');

-- --------------------------------------------------------

--
-- بنية الجدول `subscriptions`
--

CREATE TABLE `subscriptions` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `subscription_no` bigint(20) UNSIGNED NOT NULL,
  `invoice_no` varchar(50) NOT NULL,
  `verification_code` varchar(100) DEFAULT NULL,
  `branch_id` bigint(20) UNSIGNED DEFAULT NULL,
  `member_id` bigint(20) UNSIGNED DEFAULT NULL,
  `subscription_type` enum('service','offer') NOT NULL,
  `item_id` bigint(20) UNSIGNED NOT NULL,
  `item_name` varchar(255) NOT NULL,
  `start_date` date NOT NULL,
  `end_date` date NOT NULL,
  `duration` int(10) UNSIGNED NOT NULL,
  `price` decimal(10,2) NOT NULL DEFAULT 0.00,
  `tax` decimal(10,2) NOT NULL DEFAULT 0.00,
  `discount` decimal(10,2) NOT NULL DEFAULT 0.00,
  `total` decimal(10,2) NOT NULL DEFAULT 0.00,
  `created_by` bigint(20) UNSIGNED DEFAULT NULL,
  `account_user_id` bigint(20) UNSIGNED DEFAULT NULL,
  `payment_methods` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`payment_methods`)),
  `status` enum('new','under_review','approved','rejected') NOT NULL DEFAULT 'under_review',
  `rejection_notes` text DEFAULT NULL,
  `active` tinyint(1) NOT NULL DEFAULT 1,
  `created_at` timestamp NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NULL DEFAULT current_timestamp() ON UPDATE current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- بنية الجدول `users`
--

CREATE TABLE `users` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `name` varchar(255) NOT NULL,
  `email` varchar(255) NOT NULL,
  `email_verified_at` timestamp NULL DEFAULT NULL,
  `password` varchar(255) NOT NULL,
  `branch_id` bigint(20) UNSIGNED DEFAULT NULL,
  `remember_token` varchar(100) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- إرجاع أو استيراد بيانات الجدول `users`
--

INSERT INTO `users` (`id`, `name`, `email`, `email_verified_at`, `password`, `branch_id`, `remember_token`, `created_at`, `updated_at`) VALUES
(1, 'Super Admin', 'admin@system.local', NULL, '$2y$10$zFW76sceiwKh3dEcVAbn1O4YvUreAX621dQi2RrQgAHUCXNELd1u2', NULL, NULL, '2025-10-19 04:46:25', '2025-10-19 04:46:25'),
(2, 'محمد خشبه', 'mkhashaba@gulftriangle.net', NULL, '$2y$10$Ee4.v4tqZexZYudhQJh2jeiymP4Op0TDC4Si80X1BN9QgBoWCye7S', 3, NULL, '2025-10-21 05:26:36', '2025-11-24 12:07:28'),
(3, 'عبدالحميد خشبه', 'khashabawey@outlook.com', NULL, '$2y$10$aiN93dhcinBAR18aUYpe0unUII03TWlVPv09Ij9GaC5glXNRYQeI.', NULL, NULL, '2025-11-01 07:24:10', '2025-12-04 03:06:27');

--
-- Indexes for dumped tables
--

--
-- Indexes for table `branches`
--
ALTER TABLE `branches`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `branches_branch_code_unique` (`branch_code`),
  ADD KEY `branches_branch_category_id_foreign` (`branch_category_id`),
  ADD KEY `branches_branch_type_id_foreign` (`branch_type_id`),
  ADD KEY `branches_city_id_foreign` (`city_id`);

--
-- Indexes for table `branch_categories`
--
ALTER TABLE `branch_categories`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `branch_monthly_goals`
--
ALTER TABLE `branch_monthly_goals`
  ADD PRIMARY KEY (`id`),
  ADD KEY `branch_monthly_goals_branch_id_foreign` (`branch_id`);

--
-- Indexes for table `branch_service_provided`
--
ALTER TABLE `branch_service_provided`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `branch_service_provided_service_id_branch_id_unique` (`service_id`,`branch_id`),
  ADD KEY `branch_service_provided_branch_id_foreign` (`branch_id`);

--
-- Indexes for table `branch_service_sold`
--
ALTER TABLE `branch_service_sold`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `branch_service_sold_service_id_branch_id_unique` (`service_id`,`branch_id`),
  ADD KEY `branch_service_sold_branch_id_foreign` (`branch_id`);

--
-- Indexes for table `branch_types`
--
ALTER TABLE `branch_types`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `cities`
--
ALTER TABLE `cities`
  ADD PRIMARY KEY (`id`),
  ADD KEY `cities_state_id_foreign` (`state_id`);

--
-- Indexes for table `company_settings`
--
ALTER TABLE `company_settings`
  ADD PRIMARY KEY (`id`),
  ADD KEY `company_settings_country_id_foreign` (`country_id`);

--
-- Indexes for table `countries`
--
ALTER TABLE `countries`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `customers`
--
ALTER TABLE `customers`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `customers_customer_code_unique` (`customer_code`),
  ADD KEY `customers_branch_id_foreign` (`branch_id`);

--
-- Indexes for table `failed_jobs`
--
ALTER TABLE `failed_jobs`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `failed_jobs_uuid_unique` (`uuid`);

--
-- Indexes for table `members`
--
ALTER TABLE `members`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `members_member_code_unique` (`member_code`),
  ADD UNIQUE KEY `members_id_number_unique` (`id_number`),
  ADD KEY `members_nationality_id_foreign` (`nationality_id`),
  ADD KEY `members_branch_id_status_index` (`branch_id`,`status`);

--
-- Indexes for table `member_sequences`
--
ALTER TABLE `member_sequences`
  ADD PRIMARY KEY (`branch_id`);

--
-- Indexes for table `migrations`
--
ALTER TABLE `migrations`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `model_has_permissions`
--
ALTER TABLE `model_has_permissions`
  ADD PRIMARY KEY (`permission_id`,`model_id`,`model_type`),
  ADD KEY `model_has_permissions_model_id_model_type_index` (`model_id`,`model_type`);

--
-- Indexes for table `model_has_roles`
--
ALTER TABLE `model_has_roles`
  ADD PRIMARY KEY (`role_id`,`model_id`,`model_type`),
  ADD KEY `model_has_roles_model_id_model_type_index` (`model_id`,`model_type`);

--
-- Indexes for table `offers`
--
ALTER TABLE `offers`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `offers_offer_no_unique` (`offer_no`);

--
-- Indexes for table `offer_items`
--
ALTER TABLE `offer_items`
  ADD PRIMARY KEY (`id`),
  ADD KEY `offer_items_offer_id_foreign` (`offer_id`),
  ADD KEY `offer_items_service_id_foreign` (`service_id`);

--
-- Indexes for table `password_resets`
--
ALTER TABLE `password_resets`
  ADD KEY `password_resets_email_index` (`email`);

--
-- Indexes for table `password_reset_tokens`
--
ALTER TABLE `password_reset_tokens`
  ADD PRIMARY KEY (`email`);

--
-- Indexes for table `payment_methods`
--
ALTER TABLE `payment_methods`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `code` (`code`);

--
-- Indexes for table `permissions`
--
ALTER TABLE `permissions`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `perm_name_guard_branch_unique` (`name`,`guard_name`,`branch_id`),
  ADD KEY `permissions_branch_id_foreign` (`branch_id`);

--
-- Indexes for table `personal_access_tokens`
--
ALTER TABLE `personal_access_tokens`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `personal_access_tokens_token_unique` (`token`),
  ADD KEY `personal_access_tokens_tokenable_type_tokenable_id_index` (`tokenable_type`,`tokenable_id`);

--
-- Indexes for table `roles`
--
ALTER TABLE `roles`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `roles_name_guard_name_unique` (`name`,`guard_name`);

--
-- Indexes for table `role_has_permissions`
--
ALTER TABLE `role_has_permissions`
  ADD PRIMARY KEY (`permission_id`,`role_id`),
  ADD KEY `role_has_permissions_role_id_foreign` (`role_id`);

--
-- Indexes for table `services`
--
ALTER TABLE `services`
  ADD PRIMARY KEY (`id`),
  ADD KEY `services_service_category_id_foreign` (`service_category_id`),
  ADD KEY `services_service_type_id_foreign` (`service_type_id`);

--
-- Indexes for table `service_categories`
--
ALTER TABLE `service_categories`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `service_invoices`
--
ALTER TABLE `service_invoices`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `document_no` (`document_no`),
  ADD UNIQUE KEY `invoice_no` (`invoice_no`),
  ADD KEY `service_invoices_branch_id_foreign` (`branch_id`),
  ADD KEY `service_invoices_member_id_foreign` (`member_id`),
  ADD KEY `service_invoices_provider_id_foreign` (`provider_user_id`),
  ADD KEY `service_invoices_service_user_id_foreign` (`service_user_id`),
  ADD KEY `service_invoices_created_by_foreign` (`created_by`),
  ADD KEY `service_invoices_account_user_id_foreign` (`account_user_id`);

--
-- Indexes for table `service_invoice_items`
--
ALTER TABLE `service_invoice_items`
  ADD PRIMARY KEY (`id`),
  ADD KEY `invoice_items_invoice_id_fk` (`service_invoice_id`),
  ADD KEY `invoice_items_service_id_fk` (`service_id`),
  ADD KEY `invoice_items_offer_id_fk` (`offer_id`);

--
-- Indexes for table `service_types`
--
ALTER TABLE `service_types`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `states`
--
ALTER TABLE `states`
  ADD PRIMARY KEY (`id`),
  ADD KEY `states_country_id_foreign` (`country_id`);

--
-- Indexes for table `subscriptions`
--
ALTER TABLE `subscriptions`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `unique_invoice_no` (`invoice_no`),
  ADD KEY `idx_branch_id` (`branch_id`),
  ADD KEY `idx_member_id` (`member_id`),
  ADD KEY `fk_subscriptions_created_by` (`created_by`),
  ADD KEY `fk_subscriptions_account_user` (`account_user_id`);

--
-- Indexes for table `users`
--
ALTER TABLE `users`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `users_email_unique` (`email`),
  ADD KEY `users_branch_id_foreign` (`branch_id`);

--
-- AUTO_INCREMENT for dumped tables
--

--
-- AUTO_INCREMENT for table `branches`
--
ALTER TABLE `branches`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=2;

--
-- AUTO_INCREMENT for table `branch_categories`
--
ALTER TABLE `branch_categories`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=6;

--
-- AUTO_INCREMENT for table `branch_monthly_goals`
--
ALTER TABLE `branch_monthly_goals`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `branch_service_provided`
--
ALTER TABLE `branch_service_provided`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=4;

--
-- AUTO_INCREMENT for table `branch_service_sold`
--
ALTER TABLE `branch_service_sold`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=4;

--
-- AUTO_INCREMENT for table `branch_types`
--
ALTER TABLE `branch_types`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=7;

--
-- AUTO_INCREMENT for table `cities`
--
ALTER TABLE `cities`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=7;

--
-- AUTO_INCREMENT for table `company_settings`
--
ALTER TABLE `company_settings`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=2;

--
-- AUTO_INCREMENT for table `countries`
--
ALTER TABLE `countries`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=17;

--
-- AUTO_INCREMENT for table `customers`
--
ALTER TABLE `customers`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=3;

--
-- AUTO_INCREMENT for table `failed_jobs`
--
ALTER TABLE `failed_jobs`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `members`
--
ALTER TABLE `members`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `migrations`
--
ALTER TABLE `migrations`
  MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=23;

--
-- AUTO_INCREMENT for table `offers`
--
ALTER TABLE `offers`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `offer_items`
--
ALTER TABLE `offer_items`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `payment_methods`
--
ALTER TABLE `payment_methods`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=8;

--
-- AUTO_INCREMENT for table `permissions`
--
ALTER TABLE `permissions`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=15;

--
-- AUTO_INCREMENT for table `personal_access_tokens`
--
ALTER TABLE `personal_access_tokens`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `roles`
--
ALTER TABLE `roles`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=2;

--
-- AUTO_INCREMENT for table `services`
--
ALTER TABLE `services`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `service_categories`
--
ALTER TABLE `service_categories`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=4;

--
-- AUTO_INCREMENT for table `service_invoices`
--
ALTER TABLE `service_invoices`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `service_invoice_items`
--
ALTER TABLE `service_invoice_items`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `service_types`
--
ALTER TABLE `service_types`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=5;

--
-- AUTO_INCREMENT for table `states`
--
ALTER TABLE `states`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=24;

--
-- AUTO_INCREMENT for table `subscriptions`
--
ALTER TABLE `subscriptions`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `users`
--
ALTER TABLE `users`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=4;

--
-- قيود الجداول المُلقاة.
--

--
-- قيود الجداول `branches`
--
ALTER TABLE `branches`
  ADD CONSTRAINT `branches_branch_category_id_foreign` FOREIGN KEY (`branch_category_id`) REFERENCES `branch_categories` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `branches_branch_type_id_foreign` FOREIGN KEY (`branch_type_id`) REFERENCES `branch_types` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `branches_city_id_foreign` FOREIGN KEY (`city_id`) REFERENCES `states` (`id`) ON DELETE CASCADE;

--
-- قيود الجداول `branch_monthly_goals`
--
ALTER TABLE `branch_monthly_goals`
  ADD CONSTRAINT `branch_monthly_goals_branch_id_foreign` FOREIGN KEY (`branch_id`) REFERENCES `branches` (`id`) ON DELETE CASCADE;

--
-- قيود الجداول `branch_service_provided`
--
ALTER TABLE `branch_service_provided`
  ADD CONSTRAINT `branch_service_provided_branch_id_foreign` FOREIGN KEY (`branch_id`) REFERENCES `branches` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `branch_service_provided_service_id_foreign` FOREIGN KEY (`service_id`) REFERENCES `services` (`id`) ON DELETE CASCADE;

--
-- قيود الجداول `branch_service_sold`
--
ALTER TABLE `branch_service_sold`
  ADD CONSTRAINT `branch_service_sold_branch_id_foreign` FOREIGN KEY (`branch_id`) REFERENCES `branches` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `branch_service_sold_service_id_foreign` FOREIGN KEY (`service_id`) REFERENCES `services` (`id`) ON DELETE CASCADE;

--
-- قيود الجداول `cities`
--
ALTER TABLE `cities`
  ADD CONSTRAINT `cities_state_id_foreign` FOREIGN KEY (`state_id`) REFERENCES `states` (`id`) ON DELETE CASCADE;

--
-- قيود الجداول `company_settings`
--
ALTER TABLE `company_settings`
  ADD CONSTRAINT `company_settings_country_id_foreign` FOREIGN KEY (`country_id`) REFERENCES `countries` (`id`) ON DELETE SET NULL;

--
-- قيود الجداول `customers`
--
ALTER TABLE `customers`
  ADD CONSTRAINT `customers_branch_id_foreign` FOREIGN KEY (`branch_id`) REFERENCES `branches` (`id`) ON DELETE CASCADE;

--
-- قيود الجداول `members`
--
ALTER TABLE `members`
  ADD CONSTRAINT `members_branch_id_foreign` FOREIGN KEY (`branch_id`) REFERENCES `branches` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `members_nationality_id_foreign` FOREIGN KEY (`nationality_id`) REFERENCES `countries` (`id`) ON DELETE SET NULL;

--
-- قيود الجداول `member_sequences`
--
ALTER TABLE `member_sequences`
  ADD CONSTRAINT `member_sequences_branch_id_foreign` FOREIGN KEY (`branch_id`) REFERENCES `branches` (`id`) ON DELETE CASCADE;

--
-- قيود الجداول `model_has_permissions`
--
ALTER TABLE `model_has_permissions`
  ADD CONSTRAINT `model_has_permissions_permission_id_foreign` FOREIGN KEY (`permission_id`) REFERENCES `permissions` (`id`) ON DELETE CASCADE;

--
-- قيود الجداول `model_has_roles`
--
ALTER TABLE `model_has_roles`
  ADD CONSTRAINT `model_has_roles_role_id_foreign` FOREIGN KEY (`role_id`) REFERENCES `roles` (`id`) ON DELETE CASCADE;

--
-- قيود الجداول `offer_items`
--
ALTER TABLE `offer_items`
  ADD CONSTRAINT `offer_items_offer_id_foreign` FOREIGN KEY (`offer_id`) REFERENCES `offers` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `offer_items_service_id_foreign` FOREIGN KEY (`service_id`) REFERENCES `services` (`id`) ON DELETE CASCADE;

--
-- قيود الجداول `permissions`
--
ALTER TABLE `permissions`
  ADD CONSTRAINT `permissions_branch_id_foreign` FOREIGN KEY (`branch_id`) REFERENCES `branches` (`id`) ON DELETE SET NULL;

--
-- قيود الجداول `role_has_permissions`
--
ALTER TABLE `role_has_permissions`
  ADD CONSTRAINT `role_has_permissions_permission_id_foreign` FOREIGN KEY (`permission_id`) REFERENCES `permissions` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `role_has_permissions_role_id_foreign` FOREIGN KEY (`role_id`) REFERENCES `roles` (`id`) ON DELETE CASCADE;

--
-- قيود الجداول `services`
--
ALTER TABLE `services`
  ADD CONSTRAINT `services_service_category_id_foreign` FOREIGN KEY (`service_category_id`) REFERENCES `service_categories` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `services_service_type_id_foreign` FOREIGN KEY (`service_type_id`) REFERENCES `service_types` (`id`) ON DELETE CASCADE;

--
-- قيود الجداول `service_invoices`
--
ALTER TABLE `service_invoices`
  ADD CONSTRAINT `service_invoices_account_user_id_foreign` FOREIGN KEY (`account_user_id`) REFERENCES `users` (`id`) ON DELETE SET NULL,
  ADD CONSTRAINT `service_invoices_branch_id_foreign` FOREIGN KEY (`branch_id`) REFERENCES `branches` (`id`) ON DELETE SET NULL,
  ADD CONSTRAINT `service_invoices_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`) ON DELETE SET NULL,
  ADD CONSTRAINT `service_invoices_member_id_foreign` FOREIGN KEY (`member_id`) REFERENCES `members` (`id`) ON DELETE SET NULL,
  ADD CONSTRAINT `service_invoices_provider_id_foreign` FOREIGN KEY (`provider_user_id`) REFERENCES `users` (`id`) ON DELETE SET NULL,
  ADD CONSTRAINT `service_invoices_service_user_id_foreign` FOREIGN KEY (`service_user_id`) REFERENCES `users` (`id`) ON DELETE SET NULL;

--
-- قيود الجداول `service_invoice_items`
--
ALTER TABLE `service_invoice_items`
  ADD CONSTRAINT `invoice_items_invoice_id_fk` FOREIGN KEY (`service_invoice_id`) REFERENCES `service_invoices` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `invoice_items_offer_id_fk` FOREIGN KEY (`offer_id`) REFERENCES `offers` (`id`) ON DELETE SET NULL,
  ADD CONSTRAINT `invoice_items_service_id_fk` FOREIGN KEY (`service_id`) REFERENCES `services` (`id`) ON DELETE SET NULL;

--
-- قيود الجداول `states`
--
ALTER TABLE `states`
  ADD CONSTRAINT `states_country_id_foreign` FOREIGN KEY (`country_id`) REFERENCES `countries` (`id`) ON DELETE CASCADE;

--
-- قيود الجداول `subscriptions`
--
ALTER TABLE `subscriptions`
  ADD CONSTRAINT `fk_subscriptions_account_user` FOREIGN KEY (`account_user_id`) REFERENCES `users` (`id`) ON DELETE SET NULL,
  ADD CONSTRAINT `fk_subscriptions_branch_id` FOREIGN KEY (`branch_id`) REFERENCES `branches` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `fk_subscriptions_created_by` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`) ON DELETE SET NULL,
  ADD CONSTRAINT `fk_subscriptions_member_id` FOREIGN KEY (`member_id`) REFERENCES `members` (`id`) ON DELETE CASCADE;

--
-- قيود الجداول `users`
--
ALTER TABLE `users`
  ADD CONSTRAINT `users_branch_id_foreign` FOREIGN KEY (`branch_id`) REFERENCES `branches` (`id`) ON DELETE SET NULL;
COMMIT;

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
