<?php

namespace App\Exceptions;

use Illuminate\Foundation\Exceptions\Handler as ExceptionHandler;
use Throwable;
use Tymon\JWTAuth\Exceptions\TokenExpiredException;
use Tymon\JWTAuth\Exceptions\TokenInvalidException;
use Tymon\JWTAuth\Exceptions\JWTException;

class Handler extends ExceptionHandler
{
    /**
     * A list of exception types with their corresponding custom log levels.
     *
     * @var array<class-string<\Throwable>, \Psr\Log\LogLevel::*>
     */
    protected $levels = [
        //
    ];

    /**
     * A list of the exception types that are not reported.
     *
     * @var array<int, class-string<\Throwable>>
     */
    protected $dontReport = [
        //
    ];

    /**
     * A list of the inputs that are never flashed to the session on validation exceptions.
     *
     * @var array<int, string>
     */
    protected $dontFlash = [
        'current_password',
        'password',
        'password_confirmation',
    ];

    /**
     * Register the exception handling callbacks for the application.
     */
    public function register(): void
    {
        $this->reportable(function (Throwable $e) {
            //
        });
    }

    public function render($request, Throwable $exception)
    {
        if ($exception instanceof TokenExpiredException) {
            return response()->json([
                'message' => 'انتهت صلاحية الجلسة، الرجاء تسجيل الدخول مجددًا.'
            ], 401);
        }

        if ($exception instanceof TokenInvalidException) {
            return response()->json([
                'message' => 'رمز الدخول غير صالح، الرجاء تسجيل الدخول من جديد.'
            ], 401);
        }

        if ($exception instanceof JWTException) {
            return response()->json([
                'message' => 'لم يتم إرسال رمز الدخول، الرجاء تسجيل الدخول.'
            ], 401);
        }

        return parent::render($request, $exception);
    }
}