<?php

namespace App\Http\Controllers;

use App\Models\City;
use App\Models\State;
use App\Models\Country;
use App\Models\CartItem;
use Illuminate\Http\Request;
use Yajra\DataTables\DataTables;

class CartItemController extends Controller
{
    public function index()
    {
        return view('admin.pages.student.card');
    }

    public function data(Request $request)
    {
        $items = CartItem::with('student', 'subject');

        return DataTables::of($items)
            ->addColumn('student', fn($item) => $item->student->name ?? '-')
            ->addColumn('subject', fn($item) => $item->subject->getTranslation('name', app()->getLocale()) ?? '-')
            ->addColumn('is_paid', function ($item) {
                return $item->is_paid
                    ? '<i class="fas fa-check-circle text-success"></i>'
                    : '<i class="fas fa-ban text-danger"></i>';
            })
            ->editColumn('created_at', function ($item) {
                return \Carbon\Carbon::parse($item->created_at)->format('Y-m-d H:i');
            })
            ->rawColumns(['is_paid']) 
            ->make(true);
    }
}