<?php

namespace App\Http\Controllers;

use App\Models\Country;
use Illuminate\Support\Str;
use App\Models\CompanySetting;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\Storage;
use App\Http\Requests\UpdateCompanySettingRequest;

class CompanySettingController extends Controller
{
     public function edit()
    {
        $setting   = CompanySetting::first();

        // هات قائمة الدول
        $countries = Country::query()->get(['id','name']); // إن كان 'name' JSON أو نص

        // لو عندك فروع وبتحتاجها للـ select:
        // $branches = Branch::all();

        return view('admin.settings.profile', compact('setting','countries'/*,'branches'*/));
    }

    public function update(UpdateCompanySettingRequest $request)
    {
        $setting = CompanySetting::firstOrFail();

        $data = [
            'name'            => $request->input('name'),
            // 'primary_color'   => $request->primary_color,
            // 'secondary_color' => $request->secondary_color,
            'email'           => $request->email,
            'phones'          => $request->phones ? array_values($request->phones) : null,
            'main_branch_id'  => $request->main_branch_id,
            'tax_number'  => $request->tax_number,

            
            
        ];

             $data['country_id']      = $request->country_id; // ← حفظ الدولة

        // رفع الشعار
        if ($request->hasFile('logo')) {
            // أنشئ المجلد لو مش موجود
            $dir = public_path('logo_path'); // يساوي E:\xampp\htdocs\Pioneer\public\logo_path على ويندوز
            File::ensureDirectoryExists($dir);

            // احذف الشعار القديم لو موجود (اعتمادًا إنك مخزّن قيمة نسبية مثل: logo_path/old.png)
            if (!empty($setting->logo_path) && File::exists(public_path($setting->logo_path))) {
                File::delete(public_path($setting->logo_path));
            }

            // اسم ملف آمن وفريد
            $ext = $request->file('logo')->getClientOriginalExtension();
            $filename = 'logo_' . now()->format('Ymd_His') . '_' . Str::random(6) . '.' . $ext;

            // انقل الملف إلى public/logo_path
            $request->file('logo')->move($dir, $filename);

            // خزّن مسارًا نسبيًا (عشان تقدر تستخدم asset() بسهولة)
            $data['logo_path'] = 'logo_path/' . $filename;
        }

        $setting->update($data);

        return back()->with('success', __('تم الحفظ بنجاح'));
    }
}