<?php

namespace App\Http\Controllers;

use App\Models\Lesson;
use Illuminate\Http\Request;

class LessonController extends Controller
{
  public function store(Request $request)
  {
      // Validate the incoming request
      $request->validate([
          'title_ar' => 'required|string|max:255',
          'title_en' => 'required|string|max:255',
          'content_ar' => 'nullable|string',
          'content_en' => 'nullable|string',
          'unit_id' => 'required|exists:units,id', // Ensure unit_id exists in the units table
      ]);

      

      $lesson = Lesson::create([
        'unit_id' => $request->unit_id,

        'title' => [
            'ar' => $request->title_ar,
            'en' => $request->title_en,
        ],
        'content' => [
            'ar' => $request->content_ar,
            'en' => $request->content_en,
        ],
        
    ]);



      // Redirect back or show success
      toastr()->success(__('messages.success'));
      return redirect()->back();

  }

  public function update(Request $request, $id)
{
    // Validate the incoming request
    $request->validate([
        'title_ar' => 'required|string|max:255',
        'title_en' => 'required|string|max:255',
        'content_ar' => 'nullable|string',
        'content_en' => 'nullable|string',
        'unit_id' => 'required|exists:units,id', // Ensure unit_id exists in the units table
    ]);

    // Find the lesson by its ID
    $lesson = Lesson::findOrFail($id); // If the lesson is not found, it will throw a 404 error.

    // Update the lesson's fields
    $lesson->update([
        'unit_id' => $request->unit_id,
        'title' => [
            'ar' => $request->title_ar,
            'en' => $request->title_en,
        ],
        'content' => [
            'ar' => $request->content_ar,
            'en' => $request->content_en,
        ],
    ]);

    // Show a success message and redirect
    toastr()->success(__('messages.success'));
    return redirect()->back();
}

}
