<?php

namespace App\Http\Controllers;

use App\Models\Semester;
use Illuminate\Http\Request;

class SemesterController extends Controller
{
    public function addSemester(Request $request)
    {
        $request->validate([
            'subject_id' => 'required|exists:subjects,id',
            'name_ar' => 'required|string|max:255',
            'name_en' => 'required|string|max:255',
            'start_date' => 'required|date',       
            'end_date' => 'required|date|after:start_date',
        ]);

        try {
            // Create new subject with translations
            $semester = Semester::create([
                'subject_id' => $request->subject_id,

                'name' => [
                    'ar' => $request->name_ar,
                    'en' => $request->name_en,
                ],
                'start_date'=>$request->start_date,
                'end_date'=>$request->end_date,
            ]);
            toastr()->success(__('messages.success'));
            return redirect()->route('subjects.show', $request->subject_id);
        } catch (\Exception $e) {
            toastr()->success(__('flasher::messages.error'));
            return redirect()->route('subjects.show', $request->subject_id);
        }
    }

    public function editSemester(Request $request, $id)
    {
        $request->validate([
          'subject_id' => 'required|exists:subjects,id',
          'name_ar' => 'required|string|max:255',
          'name_en' => 'required|string|max:255',
          'start_date' => 'required|date',       
          'end_date' => 'required|date|after:start_date',
        ]);
        try {

        $semester = Semester::findOrFail($id);
        $semester->update([
          'name' => [
            'ar' => $request->name_ar,
            'en' => $request->name_en,
        ],
        'start_date'=>$request->start_date,
        'end_date'=>$request->end_date,
          
        ]);

        toastr()->success(__('messages.success'));
            return redirect()->route('subjects.show', $id);
    
    } catch (\Exception $e) {
        toastr()->success(__('flasher::messages.error'));
        return redirect()->route('subjects.show', $id);
    }
    }
}
