<?php

namespace App\Http\Controllers;

use App\Models\Student;
use Illuminate\Http\Request;
use Yajra\DataTables\DataTables;

class StudentController extends Controller
{
    public function index()
    {
        return view('admin.pages.student.allStudent');
    }

    public function getStudents(Request $request)
    {
        if ($request->ajax()) {
            $lang = app()->getLocale(); // for translations if needed
    
            $students = Student::with(['country', 'state', 'city', 'grade', 'heardAboutUs']);
    
            return DataTables::of($students)
                ->addColumn('grade_name', function ($student) use ($lang) {
                    return $student->grade ? $student->grade->getTranslation('name', $lang) : '';
                })
                ->addColumn('country_name', function ($student) use ($lang) {
                    return $student->country ? $student->country->getTranslation('name', $lang) : '';
                })
                ->addColumn('state_name', function ($student) use ($lang) {
                    return $student->state ? $student->state->getTranslation('name', $lang) : '';
                })
                ->addColumn('city_name', function ($student) use ($lang) {
                    return $student->city ? $student->city->getTranslation('name', $lang) : '';
                })
                ->addColumn('action', function ($student) {
                    return '<button class="btn btn-sm btn-primary edit" data-id="' . $student->id . '">Edit</button>';
                })
                ->rawColumns(['action']) // if you return HTML
                ->make(true);
        }
    }
    
}
