<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class StoreOfferRequest extends FormRequest
{
    public function authorize()
    {
        // غيّره حسب سياساتك (مثال: Gate::allows('create-offer'))
        return true;
    }

    /**
     * Normalize input names (map frontend g_* names to backend expected names)
     * This runs before validation.
     */
    protected function prepareForValidation()
    {
        $input = $this->all();

        // map g_* fields to non-g names if present
        if ($this->has('g_discount_type') && !$this->has('discount_type')) {
            $input['discount_type'] = $this->input('g_discount_type');
        }
        if ($this->has('g_discount_value') && !$this->has('discount_value')) {
            $input['discount_value'] = $this->input('g_discount_value');
        }
        if ($this->has('g_extra_days') && !$this->has('extra_days')) {
            $input['extra_days'] = $this->input('g_extra_days');
        }
        if ($this->has('g_stop_days') && !$this->has('stop_days')) {
            $input['stop_days'] = $this->input('g_stop_days');
        }
        if ($this->has('g_stop_times') && !$this->has('stop_times')) {
            $input['stop_times'] = $this->input('g_stop_times');
        }

        // scope might be named scope (same) — keep as is
        $this->replace($input);
    }

    public function rules()
    {
        return [
            'name' => ['required', 'max:191'],
            'scope' => ['required', 'in:members,customers,coupons'],

            // For members/customers/coupons validation you can add conditional rules later
            'target_member_ids' => ['nullable', 'array'],
            'target_member_ids.*' => ['integer', 'exists:members,id'],
            'target_customer_ids' => ['nullable', 'array'],
            'target_customer_ids.*' => ['integer', 'exists:customers,id'],

            // dates
            'start_date_g' => ['required', 'date_format:Y-m-d'],
            'end_date_g' => ['required', 'date_format:Y-m-d', 'after_or_equal:start_date_g'],

            'start_date_h' => ['required', 'date_format:Y-m-d'],
            'end_date_h' => ['required', 'date_format:Y-m-d', 'after_or_equal:start_date_h'],

            // **الحقول المطلوبة بحسب طلبك**
            'discount_type' => ['required', 'in:percent,amount'],
            'discount_value' => ['required', 'numeric', 'min:0'], // لو تريد >0: use min:1
            'extra_days' => ['required', 'integer', 'min:0'],

            // stop fields (غير إجبارية حسب كلامك الأخير، اجعلها required إن أردت)
            'stop_days' => ['nullable', 'integer', 'min:0'],
            'stop_times' => ['nullable', 'integer', 'min:0'],

            // items array
            'items' => ['required', 'array', 'min:1'],
            'items.*.service_id' => ['required', 'integer', 'exists:services,id'],

            // coupons
            'coupon_codes' => ['nullable', 'array'],
            'coupon_codes.*' => ['string'],
        ];
    }

    public function messages()
    {
        return [
            'name.required' => 'اسم العرض مطلوب.',
            'scope.required' => 'اختر الفئة المستهدفة.',
            'scope.in' => 'قيمة الفئة غير صحيحة.',

            'start_date_g.required' => 'تاريخ البداية (ميلادي) مطلوب.',
            'end_date_g.required' => 'تاريخ النهاية (ميلادي) مطلوب.',
            'end_date_g.after_or_equal' => 'تاريخ النهاية يجب أن يكون في نفس يوم البداية أو بعده.',

            'discount_type.required' => 'حقل نوع الخصم مطلوب.',
            'discount_type.in' => 'نوع الخصم غير مدعوم (percent أو amount).',
            'discount_value.required' => 'حقل قيمة الخصم مطلوب.',
            'discount_value.numeric' => 'قيمة الخصم يجب أن تكون رقمًا.',
            'discount_value.min' => 'قيمة الخصم يجب أن تكون ≥ 0.',

            'extra_days.required' => 'حقل الأيام الإضافية مطلوب.',
            'extra_days.integer' => 'الأيام الإضافية يجب أن تكون رقمًا صحيحًا.',
            'extra_days.min' => 'الأيام الإضافية لا يمكن أن تكون سالبة.',

            'items.required' => 'يجب إضافة عنصر واحد على الأقل.',
            'items.array' => 'قائمة العناصر غير صحيحة.',
            'items.min' => 'يجب إضافة عنصر واحد على الأقل.',

            'items.*.service_id.required' => 'معرّف الخدمة مطلوب لكل عنصر.',
            'items.*.service_id.exists' => 'أحد الخدمات المضافة غير موجودة.',
        ];
    }
}