<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class UpdateCompanySettingRequest extends FormRequest
{
    public function authorize(): bool { return true; }

    public function rules(): array
    {
        return [
            'name.ar' => ['required','string','max:255'],
            'name.en' => ['required','string','max:255'],
            'logo'    => ['nullable','image','mimes:jpg,jpeg,png,webp','max:2048'],
            // 'primary_color'   => ['required','regex:/^#([A-Fa-f0-9]{3}|[A-Fa-f0-9]{6})$/'],
            // 'secondary_color' => ['required','regex:/^#([A-Fa-f0-9]{3}|[A-Fa-f0-9]{6})$/'],
            'email'   => ['nullable','email','max:255'],

            // phones: array of rows -> each row has label[ar], label[en], number
            'phones'                 => ['nullable','array','max:20'],
            'phones.*.label.ar'      => ['required_with:phones.*.number','string','max:100'],
            'phones.*.label.en'      => ['required_with:phones.*.number','string','max:100'],
            'phones.*.number'        => ['required_with:phones.*.label.ar','string','max:30','regex:/^[0-9+\-\s()]+$/'],
             'country_id'     => ['required','exists:countries,id'], // ← المطلوبة

            'main_branch_id' => ['nullable','exists:branches,id'], // اختياري
        ];
    }

    public function attributes(): array
    {
        return [
            'name.ar' => __('الاسم (ar)'),
            'name.en' => __('الاسم (en)'),
            'phones.*.label.ar' => __('مسمى الهاتف (ar)'),
            'phones.*.label.en' => __('مسمى الهاتف (en)'),
            'phones.*.number'   => __('رقم الهاتف'),
             'country_id' => __('الدولة'),
        ];
    }
}