<?php

namespace App\Models;

use App\Models\State;
use Illuminate\Database\Eloquent\Model;
use Spatie\Translatable\HasTranslations;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class City extends Model
{
  use HasFactory, HasTranslations;

  protected $fillable = ['name', 'state_id'];
  public $translatable = ['name'];

  public function state()
  {
      return $this->belongsTo(State::class , 'state_id');
  }
}
