<?php

namespace App\Models;

use App\Models\Member;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class MemberPayment extends Model
{
    use HasFactory;


    protected $fillable = [
        'member_id',
        'item_type',
        'item_id',
        'amount',
        'currency',
        'merchant_transaction_id',
        'checkout_id',
        'transaction_id',
        'result_code',
        'result_description',
        'status',
    ];

    public function member()
    {
        return $this->belongsTo(Member::class);
    }
}