<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class ServiceInvoiceItem extends Model
{
    protected $fillable = [
        'service_invoice_id',
        'service_id',
        'service_name',
        'qty',
        'price',
        'discount',
        'tax',
        'total',
        'description'
    ];

    public function invoice()
    {
        return $this->belongsTo(ServiceInvoice::class, 'service_invoice_id');
    }

    public function service()
    {
        return $this->belongsTo(Service::class);
    }
}