<?php

namespace App\Models;

// use Illuminate\Contracts\Auth\MustVerifyEmail;
use App\Models\Role;
use App\Models\Branch;
use App\Models\Permission;
use Laravel\Sanctum\HasApiTokens;
use Tymon\JWTAuth\Contracts\JWTSubject;
use Illuminate\Notifications\Notifiable;
use Spatie\Translatable\HasTranslations;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Spatie\Permission\Traits\HasRoles;


class User extends Authenticatable implements JWTSubject
{
    use HasApiTokens, HasFactory, Notifiable, HasRoles;

    use  HasTranslations;




    protected $fillable = ['name', 'email', 'password', 'branch_id'];

    public function branch()
    {
        return $this->belongsTo(Branch::class);
    }

  

    public function permissions()
    {
        return $this->belongsToMany(Permission::class);
    }

    public function hasBranchPermission($permissionName, $branchId = null)
    {
        $branchId = $branchId ?? $this->branch_id;

        // صلاحيات المستخدم المباشرة
        $direct = $this->permissions()
            ->where('name', $permissionName)
            ->where(function ($q) use ($branchId) {
                $q->whereNull('branch_id')->orWhere('branch_id', $branchId);
            })
            ->exists();

        // صلاحيات الأدوار
        $rolePermission = $this->roles()
            ->whereHas('permissions', function ($q) use ($permissionName, $branchId) {
                $q->where('name', $permissionName)
                    ->where(function ($q2) use ($branchId) {
                        $q2->whereNull('branch_id')->orWhere('branch_id', $branchId);
                    });
            })
            ->exists();

        return $direct || $rolePermission;
    }

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
        'password',
        'remember_token',
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        'email_verified_at' => 'datetime',
    ];


    public function getJWTIdentifier()
    {
        return $this->getKey();
    }

    /**
     * Return a key value array, containing any custom claims to be added to the JWT.
     *
     * @return array
     */
    public function getJWTCustomClaims()
    {
        return [];
    }
}