<?php

namespace App\Services;

use App\Models\MemberPayment;
use App\Models\Subscription;
use Carbon\Carbon;
use Illuminate\Support\Facades\DB;

class SubscriptionService
{
    public function createFromPayment(MemberPayment $payment): Subscription
    {
        return DB::transaction(function () use ($payment) {

            $startDate = now();
            $duration  = 30;
            $endDate   = $startDate->copy()->addDays($duration);

            return Subscription::create([
                'subscription_no' => Subscription::max('subscription_no') + 1,
                'invoice_no'      => 'INV-' . now()->format('Ymd') . '-' . $payment->id,

                // ❌ لا branch_id لو مش موجود
                'member_id' => $payment->member_id,

                'subscription_type' => $payment->item_type,
                'item_id'           => $payment->item_id,
                'item_name'         => 'Offer Subscription',

                'start_date' => $startDate,
                'end_date'   => $endDate,
                'duration'   => $duration,

                'price'    => $payment->amount,
                'tax'      => 0,
                'discount' => 0,
                'total'    => $payment->amount,

                'payment_methods' => json_encode([
                    'hyperpay' => [
                        'transaction_id' => $payment->transaction_id,
                        'merchant_tx'    => $payment->merchant_transaction_id,
                    ]
                ]),

                'status' => 'approved',
                'active' => true,
            ]);
        });

        }

        
}