<?php

return [

    'defaults' => [
        'guard' => 'web',
        'passwords' => 'users',
    ],

    'guards' => [

        // مستخدمين السيستم (قديم)
        'web' => [
            'driver' => 'session',
            'provider' => 'users',
        ],

        // ✅ Members - Web
        'member' => [
            'driver' => 'session',
            'provider' => 'members',
        ],

        // ✅ Members - Mobile API
        'member-api' => [
            'driver' => 'sanctum',
            'provider' => 'members',
        ],
    ],

    'providers' => [

        'users' => [
            'driver' => 'eloquent',
            'model' => App\Models\User::class,
        ],

        // ✅ Members Provider
        'members' => [
            'driver' => 'eloquent',
            'model' => App\Models\Member::class,
        ],
    ],

    'passwords' => [

        'users' => [
            'provider' => 'users',
            'table' => 'password_reset_tokens',
            'expire' => 60,
            'throttle' => 60,
        ],

        // (اختياري لو هتعمل reset password للـ members)
        'members' => [
            'provider' => 'members',
            'table' => 'password_reset_tokens',
            'expire' => 60,
            'throttle' => 60,
        ],
    ],

    'password_timeout' => 10800,
];
