<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('company_settings', function (Blueprint $table) {
            $table->id();
            $table->json('name');          // مهم يكون json
            $table->string('logo_path')->nullable();
            $table->string('primary_color')->default('#0ea5b6');
            $table->string('secondary_color')->default('#1e293b');
            $table->string('email')->nullable();
            $table->json('phones')->nullable(); // مهم يكون json
            $table->foreignId('country_id')
                ->nullable()

                ->constrained('countries')
                ->nullOnDelete();
                 $table->string('tax_number', 50)
                  ->nullable();
            // $table->foreignId('main_branch_id')->nullable()->constrained('branches')->nullOnDelete(); // لو عندك جدول branches
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('company_settings');
    }
};