<?php

// database/migrations/2025_09_25_100000_create_services_table.php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('services', function (Blueprint $table) {
            $table->id();
            $table->string('service_code', 10)->nullable();
            $table->json('name');                           // Spatie Translatable
            $table->foreignId('service_category_id')->constrained()->cascadeOnDelete();
            $table->foreignId('service_type_id')->constrained()->cascadeOnDelete();
            $table->decimal('price', 10, 2);
            // $table->decimal('discount_price', 10, 2)->nullable();
            $table->unsignedInteger('duration_value');      // 1 .. n
            $table->enum('duration_unit', ['days', 'months', 'years']);
            $table->time('start_time')->nullable();
            $table->time('end_time')->nullable();
            $table->json('notes')->nullable();              // مترجم إن حبيت
            $table->json('settings')->nullable();           // كل الإعدادات هنا
            $table->boolean('active')->default(true);
            $table->timestamps();
        });

        // فروع مقدِّمة للخدمة
        Schema::create('branch_service_provided', function (Blueprint $table) {
            $table->id();
            $table->foreignId('service_id')->constrained()->cascadeOnDelete();
            $table->foreignId('branch_id')->constrained()->cascadeOnDelete();
            $table->unique(['service_id', 'branch_id']);
        });

        // فروع مباعة فيها الخدمة
        Schema::create('branch_service_sold', function (Blueprint $table) {
            $table->id();
            $table->foreignId('service_id')->constrained()->cascadeOnDelete();
            $table->foreignId('branch_id')->constrained()->cascadeOnDelete();
            $table->unique(['service_id', 'branch_id']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('branch_service_sold');
        Schema::dropIfExists('branch_service_provided');
        Schema::dropIfExists('services');
    }
};