<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('service_invoices', function (Blueprint $table) {
            $table->id();

            // رقم تسلسلي للوثيقة (يظهر للمستخدم)
            $table->unsignedBigInteger('document_no')->unique();

            // رقم الفاتورة (ممكن تستخدم نفس الفورمات الحالية GEN/..../...)
            $table->string('invoice_no')->unique();

            // العلاقات
            $table->foreignId('branch_id')->nullable()->constrained()->nullOnDelete();
            $table->foreignId('member_id')->nullable()->constrained()->nullOnDelete();


            // مقدم الخدمة والمسؤول
            $table->foreignId('service_user_id')->nullable()->constrained('users')->nullOnDelete();
            $table->foreignId('provider_user_id')->nullable()->constrained('users')->nullOnDelete();


            // المستخدم الذى أنشأ الفاتورة / صاحب الحساب
            $table->foreignId('created_by')->nullable()
                ->constrained('users')->nullOnDelete();
            $table->foreignId('account_user_id')->nullable()
                ->constrained('users')->nullOnDelete();

            // التواريخ
            $table->date('greg_date');                 // ميلادي
            $table->string('hijri_date')->nullable();  // نص هجري

            // ملاحظات عامة
            $table->text('notes')->nullable();

            $table->json('payment_methods')->nullable(); // هذا الحقل سيكون من نوع JSON


            // إجماليات
            $table->decimal('total_price',   10, 2)->default(0);   // مجموع الأسعار قبل الخصم
            $table->decimal('total_discount', 10, 2)->default(0);  // (خصومات البنود + الخصم الإضافي)
            $table->decimal('total_tax',      10, 2)->default(0);  // إجمالي الضريبة
            $table->decimal('total_net',      10, 2)->default(0);

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('service_invoices');
    }
};
