<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('service_invoice_items', function (Blueprint $table) {
            $table->id();

            $table->foreignId('service_invoice_id')
                ->constrained('service_invoices')
                ->cascadeOnDelete();

            // نوع البند: service | offer
            $table->enum('type', ['service', 'offer']);

            // الخدمة الأساسية (إن وجد)
            $table->foreignId('service_id')->nullable()
                ->constrained('services')->nullOnDelete();

            // العرض (إن وجد)
            $table->foreignId('offer_id')->nullable()
                ->constrained('offers')->nullOnDelete();

            // الخدمة داخل العرض
            $table->foreignId('offer_service_id')->nullable()
                ->constrained('offer_items')->nullOnDelete();

            // الاسم الظاهر على الفاتورة (مثلاً: تنظيف + تلميع)
            $table->string('description')->nullable();

            // بيانات البنود
            $table->unsignedInteger('qty')->default(1);
            $table->decimal('price',    10, 2)->default(0);
            $table->decimal('discount', 10, 2)->default(0);
            $table->decimal('tax',      10, 2)->default(0);
            $table->decimal('total',    10, 2)->default(0);

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('service_invoice_items');
    }
};