<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('member_payments', function (Blueprint $table) {
            $table->id();
            $table->foreignId('member_id')
                ->constrained('members')
                ->cascadeOnDelete();

            // 🔹 نوع الاشتراك (عرض / خدمة)
            $table->enum('item_type', ['offer', 'service']);
            $table->unsignedBigInteger('item_id');

            // 🔹 المبالغ
            $table->decimal('amount', 10, 2);
            $table->string('currency', 3)->default('SAR');

            // 🔹 HyperPay identifiers
            $table->string('merchant_transaction_id')->unique();
            $table->string('checkout_id')->nullable();
            $table->string('transaction_id')->nullable();

            // 🔹 نتيجة الدفع
            $table->string('result_code')->nullable();
            $table->string('result_description')->nullable();

            // 🔹 حالة العملية
            $table->enum('status', ['pending', 'paid', 'failed'])
                ->default('pending');

            $table->timestamps();

            // 🔹 Indexes للأداء
            $table->index(['member_id', 'status']);
            $table->index(['item_type', 'item_id']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('member_payments');
    }
};