<?php

namespace Database\Seeders;

use App\Models\CompanySetting;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class CompanySettingSeeder extends Seeder
{
    public function run(): void
    {
        // لو عندك علاقات FK يفضّل توقفها مؤقتًا
        DB::statement('SET FOREIGN_KEY_CHECKS=0');
        DB::table('company_settings')->truncate();
        DB::statement('SET FOREIGN_KEY_CHECKS=1');

        // دايمًا خليك Array مش null
        CompanySetting::updateOrCreate(
            ['id' => 1],
            [
                'name'            => ['ar' => 'الشركة النموذجية', 'en' => 'Demo Company'],
                'logo_path'       => null,
                'primary_color'   => '#0ea5b6',
                'secondary_color' => '#1e293b',
                'email'           => 'info@example.com',
                 'country_id'      => 2,
                'phones'          => [
                    ['label' => ['ar' => 'المبيعات', 'en' => 'Sales'],   'number' => '+201234567890'],
                    ['label' => ['ar' => 'الدعم',   'en' => 'Support'], 'number' => '+201112223334'],
                ],
            ]
        );
    }
}