<?php

namespace Database\Seeders;
use Illuminate\Database\Seeder;
use App\Models\Country;
use App\Models\State;
use App\Models\City;

class CountryStateCitySeeder extends Seeder
{
    public function run()
    {
        // Seed countries
        $countries = [
          'Egypt' => ['ar' => 'مصر', 'en' => 'Egypt'],
          'Saudi Arabia' => ['ar' => 'السعودية', 'en' => 'Saudi Arabia'],
          'United Arab Emirates' => ['ar' => 'الإمارات', 'en' => 'United Arab Emirates'],
          'Jordan' => ['ar' => 'الأردن', 'en' => 'Jordan'],
          'Lebanon' => ['ar' => 'لبنان', 'en' => 'Lebanon'],
          'Algeria' => ['ar' => 'الجزائر', 'en' => 'Algeria'],
          'Morocco' => ['ar' => 'المغرب', 'en' => 'Morocco'],
          'Tunisia' => ['ar' => 'تونس', 'en' => 'Tunisia'],
          'Iraq' => ['ar' => 'العراق', 'en' => 'Iraq'],
          'Kuwait' => ['ar' => 'الكويت', 'en' => 'Kuwait'],
          'Oman' => ['ar' => 'عمان', 'en' => 'Oman'],
          'Qatar' => ['ar' => 'قطر', 'en' => 'Qatar'],
          'Bahrain' => ['ar' => 'البحرين', 'en' => 'Bahrain'],
          'Palestine' => ['ar' => 'فلسطين', 'en' => 'Palestine'],
          'Syria' => ['ar' => 'سوريا', 'en' => 'Syria'],
          'Yemen' => ['ar' => 'اليمن', 'en' => 'Yemen'],
      ];

      foreach ($countries as $countryName => $countryTranslation) {
        $country = Country::create([
            'name' => $countryTranslation,  // Translatable field
        ]);

        // Seed States for each country
        $states = $this->getStatesForCountry($countryName);
        foreach ($states as $stateName => $stateTranslation) {
            $state = State::create([
                'name' => $stateTranslation,  // Translatable field
                'country_id' => $country->id,
            ]);

            // Seed Cities for each state
            $cities = $this->getCitiesForState($stateName);
            foreach ($cities as $cityName => $cityTranslation) {
                City::create([
                    'name' => $cityTranslation,  // Translatable field
                    'state_id' => $state->id,
                ]);
            }
        }
    }

    
  }

  // Example function to get states for each country
  private function getStatesForCountry($country)
  {
      $states = [];

      switch ($country) {
          case 'Egypt':
              $states = [
                  'Cairo' => ['ar' => 'القاهرة', 'en' => 'Cairo'],
                  'Alexandria' => ['ar' => 'الإسكندرية', 'en' => 'Alexandria'],
                  'Giza' => ['ar' => 'الجيزة', 'en' => 'Giza'],
              ];
              break;
          case 'Saudi Arabia':
              $states = [
                  'Riyadh' => ['ar' => 'الرياض', 'en' => 'Riyadh'],
                  'Jeddah' => ['ar' => 'جدة', 'en' => 'Jeddah'],
                  'Mecca' => ['ar' => 'مكة', 'en' => 'Mecca'],
              ];
              break;
          case 'United Arab Emirates':
              $states = [
                  'Dubai' => ['ar' => 'دبي', 'en' => 'Dubai'],
                  'Abu Dhabi' => ['ar' => 'أبوظبي', 'en' => 'Abu Dhabi'],
                  'Sharjah' => ['ar' => 'الشارقة', 'en' => 'Sharjah'],
              ];
              break;
          case 'Oman':
              $states = [
                  'Muscat' => ['ar' => 'مسقط', 'en' => 'Muscat'],
                  'Dhofar' => ['ar' => 'ظفار', 'en' => 'Dhofar'],
                  'North Batinah' => ['ar' => 'الباطنة شمال', 'en' => 'North Batinah'],
              ];
              break;
          case 'Qatar':
              $states = [
                  'Doha' => ['ar' => 'الدوحة', 'en' => 'Doha'],
                  'Al Rayyan' => ['ar' => 'الريان', 'en' => 'Al Rayyan'],
                  'Al Khor' => ['ar' => 'الخور', 'en' => 'Al Khor'],
              ];
              break;
          case 'Bahrain':
              $states = [
                  'Manama' => ['ar' => 'المنامة', 'en' => 'Manama'],
                  'Muharraq' => ['ar' => 'المحرق', 'en' => 'Muharraq'],
              ];
              break;
          case 'Palestine':
              $states = [
                  'Ramallah' => ['ar' => 'رام الله', 'en' => 'Ramallah'],
                  'Gaza' => ['ar' => 'غزة', 'en' => 'Gaza'],
              ];
              break;
          case 'Syria':
              $states = [
                  'Damascus' => ['ar' => 'دمشق', 'en' => 'Damascus'],
                  'Aleppo' => ['ar' => 'حلب', 'en' => 'Aleppo'],
              ];
              break;
          case 'Yemen':
              $states = [
                  'Sanaa' => ['ar' => 'صنعاء', 'en' => 'Sanaa'],
                  'Aden' => ['ar' => 'عدن', 'en' => 'Aden'],
              ];
              break;
          default:
              $states = [];
              break;
      }

      return $states;
  }

  // Example function to get cities for each state
  private function getCitiesForState($state)
  {
      $cities = [];

      switch ($state) {
          case 'Cairo':
              $cities = [
                  'Nasr City' => ['ar' => 'مدينة نصر', 'en' => 'Nasr City'],
                  'Zamalek' => ['ar' => 'الزمالك', 'en' => 'Zamalek'],
              ];
              break;
          case 'Riyadh':
              $cities = [
                  'Olaya' => ['ar' => 'الملز', 'en' => 'Olaya'],
                  'Al-Khobar' => ['ar' => 'الخبر', 'en' => 'Al-Khobar'],
              ];
              break;
          case 'Doha':
              $cities = [
                  'West Bay' => ['ar' => 'الخليج الغربي', 'en' => 'West Bay'],
                  'Al Sadd' => ['ar' => 'السد', 'en' => 'Al Sadd'],
              ];
              break;
          default:
              $cities = [];
              break;
      }

      return $cities;
  }
}

