<?php

namespace Database\Seeders;

use App\Models\Role;
use App\Models\User;
use App\Models\Permission;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;

class SuperAdminSeeder extends Seeder
{
    public function run(): void
    {
        // 1️⃣ إنشاء المستخدم Super Admin
        $admin = User::firstOrCreate(
            ['email' => 'admin@system.local'],
            [
                'name' => 'Super Admin',
                'password' => Hash::make('123456'), // غيّرها لاحقاً 🔒
                'branch_id' => null, // عام لكل الفروع
            ]
        );

        // 2️⃣ إنشاء الدور Super Admin لو مش موجود
        $role = Role::firstOrCreate(
            ['name' => 'super_admin', 'guard_name' => 'web']
        );

        // 3️⃣ الحصول على كل الصلاحيات الحالية
        $permissions = Permission::all();

        // 4️⃣ ربط جميع الصلاحيات بالدور
        $role->syncPermissions($permissions);

        // 5️⃣ منح المستخدم هذا الدور
        $admin->assignRole($role);

        // ✅ رسالة نجاح في الكونسول
        $this->command->info('Super Admin created and assigned all permissions successfully.');





        $categories = [
            ['name' => ['ar' => 'نادي نسائي', 'en' => 'Women Gym']],
            ['name' => ['ar' => 'نادي رجالي', 'en' => 'Men Gym']],
            ['name' => ['ar' => 'نادي عائلي', 'en' => 'Family Gym']],
        ];


        DB::table('branch_categories')->insert(array_map(function ($cat) {
            return [
                'name' => json_encode($cat['name'], JSON_UNESCAPED_UNICODE),
                'created_at' => now(),
                'updated_at' => now(),
            ];
        }, $categories));

        // ✅ بيانات أنواع الفروع
        $types = [
            ['name' => ['ar' => 'رئيسي', 'en' => 'Main']],
            ['name' => ['ar' => 'فرعي', 'en' => 'Sub']],
            ['name' => ['ar' => 'امتياز', 'en' => 'Franchise']],
        ];


        DB::table('branch_types')->insert(array_map(function ($type) {
            return [
                'name' => json_encode($type['name'], JSON_UNESCAPED_UNICODE),
                'created_at' => now(),
                'updated_at' => now(),
            ];
        }, $types));





        // ✅ بيانات الفروع (branches)
        $branches = [
            [
                'id' => 1, // المركز الرئيسي لازم id=1
                'branch_code' => 'MAIN001',
                'name' => ['ar' => 'المركز الرئيسي', 'en' => 'Main Center'],
                'branch_category_id' => 3, // نادي عائلي
                'branch_type_id' => 1, // رئيسي
                'city_id' => 1, // الرياض
                'primary_phone' => '0500000000',
                'phones' => [
                    ['label' => ['ar' => 'الاستقبال', 'en' => 'Reception'], 'number' => '0501111111'],
                    ['label' => ['ar' => 'المدربون', 'en' => 'Coaches'], 'number' => '0502222222'],
                ],
                'address' => [
                    'street' => ['ar' => 'شارع العليا', 'en' => 'Olaya Street'],
                    'district' => ['ar' => 'الملز', 'en' => 'Al Malaz'],
                    'building_no' => '12B',
                    'postal_code' => '11564',
                ],
                'min_age' => 15,
                'max_discount_percent' => 30,
                'short_name' => 'br1',
                'active' => true,
            ],
            [
                'branch_code' => 'SUB002',
                'name' => ['ar' => 'فرع جدة', 'en' => 'Jeddah Branch'],
                'branch_category_id' => 2, // رجالي
                'branch_type_id' => 2, // فرعي
                'city_id' => 2, // جدة
                'primary_phone' => '0550000000',
                'phones' => [
                    ['label' => ['ar' => 'المبيعات', 'en' => 'Sales'], 'number' => '0551111111'],
                ],
                'address' => [
                    'street' => ['ar' => 'طريق المدينة', 'en' => 'Madinah Road'],
                    'district' => ['ar' => 'السلامة', 'en' => 'Al Salama'],
                    'building_no' => '22A',
                    'postal_code' => '21423',
                ],
                'min_age' => 16,
                'max_discount_percent' => 20,
                'short_name' => 'br2',
                'active' => true,
            ],
            [
                'branch_code' => 'FR003',
                'name' => ['ar' => 'فرع الدمام', 'en' => 'Dammam Branch'],
                'branch_category_id' => 1, // نسائي
                'branch_type_id' => 3, // امتياز
                'city_id' => 3, // الدمام
                'primary_phone' => '0560000000',
                'phones' => [
                    ['label' => ['ar' => 'الاستقبال', 'en' => 'Reception'], 'number' => '0561234567'],
                ],
                'address' => [
                    'street' => ['ar' => 'شارع الخليج', 'en' => 'Khaleej Street'],
                    'district' => ['ar' => 'الروضة', 'en' => 'Al Rawda'],
                    'building_no' => '8C',
                    'postal_code' => '31952',
                ],
                'min_age' => 14,
                'max_discount_percent' => 25,
                'short_name' => 'br3',
                'active' => true,
            ],
        ];


        DB::table('branches')->insert(array_map(function ($branch) {
            return [
                'id' => $branch['id'] ?? null,
                'branch_code' => $branch['branch_code'],
                'name' => json_encode($branch['name'], JSON_UNESCAPED_UNICODE),
                'branch_category_id' => $branch['branch_category_id'],
                'branch_type_id' => $branch['branch_type_id'],
                'city_id' => $branch['city_id'],
                'primary_phone' => $branch['primary_phone'],
                'phones' => json_encode($branch['phones'], JSON_UNESCAPED_UNICODE),
                'address' => json_encode($branch['address'], JSON_UNESCAPED_UNICODE),
                'min_age' => $branch['min_age'],
                'max_discount_percent' => $branch['max_discount_percent'],
                'short_name' => $branch['short_name'],
                'active' => $branch['active'],
                
                'created_at' => now(),
                'updated_at' => now(),
            ];
        }, $branches));
    }
}