{{-- resources/views/admin/branches/create.blade.php --}}
@extends('layouts.master')

@section('title', isset($branch) ? __('تعديل فرع') : __('إضافة فرع'))
@section('pages') {{ __('dashboard.home') }} @endsection

@section('css')
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css">
    <style>
        .card-section {
            background: #0f1e2b;
            border-radius: 12px;
            padding: 16px;
            margin-bottom: 16px
        }

        .card-section h6 {
            margin-bottom: 12px
        }

        .phone-row .remove-phone {
            min-width: 42px
        }

        .form-text-muted {
            opacity: .8;
            font-size: .9rem
        }

        .tabs-sticky {
            position: sticky;
            top: 60px;
            z-index: 8;
            background: transparent
        }

        .tabs-sticky .nav-tabs {
            background: #0f1e2b;
            border-radius: 12px;
            padding: 6px
        }

        .header-row {
            gap: .75rem
        }

        .nav-link {
            color: #fff;
        }

        @media (max-width: 576px) {
            .header-row .btn {
                width: 100%
            }
        }

        .goals-two-cols .table thead th {
            position: sticky;
            top: 0;
            background: #102232;
            z-index: 1
        }
    </style>
@endsection

@section('content')
    <div class="container-fluid">

        {{-- رسائل النظام --}}
        @if (session('success'))
            <div class="alert alert-success">{{ session('success') }}</div>
        @endif
        @if ($errors->any())
            <div class="alert alert-danger">
                <ul class="mb-0">
                    @foreach ($errors->all() as $e)
                        <li>{{ $e }}</li>
                    @endforeach
                </ul>
            </div>
        @endif

        <form action="{{ isset($branch) ? route('branches.update', $branch) : route('branches.store') }}" method="POST">
            @csrf
            @if (isset($branch))
                @method('PUT')
            @endif

            {{-- عنوان + أزرار --}}
            <div class="d-flex align-items-center justify-content-between flex-wrap header-row mb-3">
                <h5 class="mb-0"></h5>
                <div class="d-flex align-items-center gap-2">
                    <button class="btn btn-primary">
                        <i class="fas fa-save mx-2"></i>{{ isset($branch) ? 'تحديث الفرع' : 'حفظ الفرع' }}
                    </button>
                    <a href="{{ route('branches.index') }}" class="btn btn-secondary">{{ __('dashboard.back') }}</a>
                </div>
            </div>

            {{-- Tabs --}}
            <div class="tabs-sticky mb-3">
                <ul class="nav nav-tabs" id="branchTabs" role="tablist">
                    <li class="nav-item"><button class="nav-link active text-light" data-bs-toggle="tab"
                            data-bs-target="#tab-basic" type="button">البيانات الأساسية</button></li>
                    {{-- <li class="nav-item"><button class="nav-link text-light" data-bs-toggle="tab"
                            data-bs-target="#tab-phones" type="button">أرقام الهواتف</button></li> --}}
                    <li class="nav-item"><button class="nav-link text-light" data-bs-toggle="tab"
                            data-bs-target="#tab-address" type="button">العنوان والتفاصيل</button></li>
                    <li class="nav-item"><button class="nav-link text-light" data-bs-toggle="tab"
                            data-bs-target="#tab-setting" type="button"> اعدادات اخرى</button></li>
                    <li class="nav-item"><button class="nav-link text-light" data-bs-toggle="tab"
                            data-bs-target="#tab-goals" type="button">الأهداف الشهرية</button></li>
                </ul>
            </div>

            <div class="tab-content">

                {{-- تبويب: البيانات الأساسية --}}
                <div class="tab-pane fade show active" id="tab-basic">
                    <div class="card-section">
                        <div class="row g-3">
                            <div class="col-md-1">
                                <label class="form-label">كود الفرع</label>
                                <input type="text" class="form-control"
                                    value="{{ isset($branch) ? $branch->branch_code : $suggestedCode ?? '001' }}" readonly>
                            </div>
                            <div class="col-md-3">
                                <label class="form-label">فئة الفرع <span class="text-danger">*</span></label>
                                <select name="branch_category_id" class="form-select" required>
                                    <option value="">— اختر —</option>
                                    @foreach ($categories as $c)
                                        <option value="{{ $c->id }}" @selected(old('branch_category_id', isset($branch) ? $branch->branch_category_id : null) == $c->id)>
                                            {{ method_exists($c, 'getTranslation') ? $c->getTranslation('name', app()->getLocale()) : (is_array($c->name) ? $c->name[app()->getLocale()] ?? ($c->name['en'] ?? '') : $c->name) }}
                                        </option>
                                    @endforeach
                                </select>
                                @error('branch_category_id')
                                    <small class="text-danger">{{ $message }}</small>
                                @enderror
                            </div>

                            <div class="col-md-3">
                                <label class="form-label">نوع الفرع <span class="text-danger">*</span></label>
                                <select name="branch_type_id" class="form-select" required>
                                    <option value="">— اختر —</option>
                                    @foreach ($types as $t)
                                        <option value="{{ $t->id }}" @selected(old('branch_type_id', isset($branch) ? $branch->branch_type_id : null) == $t->id)>
                                            {{ method_exists($t, 'getTranslation') ? $t->getTranslation('name', app()->getLocale()) : (is_array($t->name) ? $t->name[app()->getLocale()] ?? ($t->name['en'] ?? '') : $t->name) }}
                                        </option>
                                    @endforeach
                                </select>
                                @error('branch_type_id')
                                    <small class="text-danger">{{ $message }}</small>
                                @enderror
                            </div>

                            <div class="col-md-2">
                                <label class="form-label">جنس الفرع <span class="text-danger">*</span></label>

                                @php
                                    $genderOld = old('gender', isset($branch) ? (int) $branch->gender : 0);
                                @endphp

                                <select name="gender" class="form-select" required>
                                    <option value="0" @selected($genderOld === 0)>رجال</option>
                                    <option value="1" @selected($genderOld === 1)>نساء</option>
                                </select>

                                @error('gender')
                                    <small class="text-danger">{{ $message }}</small>
                                @enderror
                            </div>


                            <div class="col-md-3">
                                <label class="form-label">
                                    الاسم المختصر للفرع
                                    <span class="text-danger">*</span>
                                </label>

                                <input type="text" class="form-control" name="short_name"
                                    value="{{ old('short_name', isset($branch) ? $branch->short_name : '') }}"
                                    placeholder="مثال: MAA / BR1 / G01" required>

                                <small class="text-muted">
                                    رمز تعريفي مختصر للفرع (يُستخدم في الفواتير والتقارير)
                                </small>

                                @error('short_name')
                                    <small class="text-danger">{{ $message }}</small>
                                @enderror
                            </div>



                            <div class="col-md-6">
                                <label class="form-label">الاسم (ar) <span class="text-danger">*</span></label>
                                <input type="text" class="form-control" name="name[ar]"
                                    value="{{ old('name.ar', isset($branch) ? $branch->getTranslation('name', 'ar') : '') }}"
                                    required>
                                @error('name.ar')
                                    <small class="text-danger">{{ $message }}</small>
                                @enderror
                            </div>

                            <div class="col-md-6">
                                <label class="form-label">الاسم (en) <span class="text-danger">*</span></label>
                                <input type="text" class="form-control" name="name[en]"
                                    value="{{ old('name.en', isset($branch) ? $branch->getTranslation('name', 'en') : '') }}"
                                    required>
                                @error('name.en')
                                    <small class="text-danger">{{ $message }}</small>
                                @enderror
                            </div>




                            <div class="col-md-4">
                                <label class="form-label">المدينة <span class="text-danger">*</span></label>
                                <select name="city_id" class="form-select" required>
                                    <option value="">— اختر —</option>
                                    @foreach ($cities as $city)
                                        <option value="{{ $city->id }}" @selected(old('city_id', isset($branch) ? $branch->city_id : null) == $city->id)>
                                            {{ method_exists($city, 'getTranslation') ? $city->getTranslation('name', app()->getLocale()) : (is_array($city->name) ? $city->name[app()->getLocale()] ?? ($city->name['en'] ?? '') : $city->name) }}
                                        </option>
                                    @endforeach
                                </select>
                                <div class="form-text form-text-muted">* المدن محمّلة وفق الدولة المختارة في إعدادات
                                    الشركة.
                                </div>
                                @error('city_id')
                                    <small class="text-danger">{{ $message }}</small>
                                @enderror
                            </div>

                            <div class="col-md-4">
                                <label class="form-label">الهاتف الأساسي <span class="text-danger">*</span></label>
                                <input type="text" class="form-control" name="primary_phone"
                                    value="{{ old('primary_phone', isset($branch) ? $branch->primary_phone : '') }}"
                                    required>
                                @error('primary_phone')
                                    <small class="text-danger">{{ $message }}</small>
                                @enderror
                            </div>

                            <div class="col-md-4">
                                <label class="form-label">الحالة <span class="text-danger">*</span></label>
                                @php $activeOld = old('active', isset($branch)?(int)$branch->active:1); @endphp
                                <select name="active" class="form-select" required>
                                    <option value="1" @selected($activeOld == 1)>نشط</option>
                                    <option value="0" @selected($activeOld == 0)>غير نشط</option>
                                </select>
                                @error('active')
                                    <small class="text-danger">{{ $message }}</small>
                                @enderror
                            </div>

                            <div class="card-section">
                                <div class="d-flex justify-content-between align-items-center mb-2">
                                    <h6 class="mb-0">أرقام هواتف فرعية</h6>
                                    <button type="button" class="btn btn-info btn" id="addPhone"><i
                                            class="fas fa-plus"></i>
                                        إضافة رقم هاتف</button>
                                </div>
                                <div id="phonesWrapper">
                                    @php $phones = old('phones', isset($branch)?($branch->phones ?? []):[]); @endphp
                                    @if (empty($phones))
                                        @php $phones = [['label'=>['ar'=>'','en'=>''],'number'=>'']]; @endphp
                                    @endif

                                    @foreach ($phones as $i => $p)
                                        <div class="row g-2 phone-row align-items-end mb-2">
                                            <div class="col-md-3">
                                                <label class="form-label">مسمّى (ar)</label>
                                                <input type="text" class="form-control"
                                                    name="phones[{{ $i }}][label][ar]"
                                                    value="{{ $p['label']['ar'] ?? '' }}">
                                            </div>
                                            <div class="col-md-3">
                                                <label class="form-label">Label (en)</label>
                                                <input type="text" class="form-control"
                                                    name="phones[{{ $i }}][label][en]"
                                                    value="{{ $p['label']['en'] ?? '' }}">
                                            </div>
                                            <div class="col-md-4">
                                                <label class="form-label">رقم الهاتف</label>
                                                <input type="text" class="form-control"
                                                    name="phones[{{ $i }}][number]"
                                                    value="{{ $p['number'] ?? '' }}">
                                            </div>
                                            <div class="col-md-2 d-grid">
                                                <button type="button" class="btn btn-danger remove-phone"><i
                                                        class="fas fa-trash"></i></button>
                                            </div>
                                        </div>
                                    @endforeach

                                    @error('phones.*.label.ar')
                                        <small class="text-danger d-block">{{ $message }}</small>
                                    @enderror
                                    @error('phones.*.label.en')
                                        <small class="text-danger d-block">{{ $message }}</small>
                                    @enderror
                                    @error('phones.*.number')
                                        <small class="text-danger d-block">{{ $message }}</small>
                                    @enderror
                                </div>
                            </div>
                        </div>
                    </div>
                </div>




                {{-- تبويب: العنوان --}}
                <div class="tab-pane fade" id="tab-address">
                    <div class="card-section">
                        <div class="row g-3">
                            <div class="col-md-6">
                                <label class="form-label">العنوان (ar)</label>
                                <input type="text" class="form-control" name="address[full][ar]"
                                    value="{{ old('address.full.ar', isset($branch) ? $branch->address['full']['ar'] ?? '' : '') }}">
                            </div>
                            <div class="col-md-6">
                                <label class="form-label">العنوان (en)</label>
                                <input type="text" class="form-control" name="address[full][en]"
                                    value="{{ old('address.full.en', isset($branch) ? $branch->address['full']['en'] ?? '' : '') }}">
                            </div>

                            <div class="col-md-6">
                                <label class="form-label">العنوان المختصر (ar)</label>
                                <input type="text" class="form-control" name="address[short][ar]"
                                    value="{{ old('address.short.ar', isset($branch) ? $branch->address['short']['ar'] ?? '' : '') }}">
                            </div>

                            <div class="col-md-6">
                                <label class="form-label">العنوان المختصر (en)</label>
                                <input type="text" class="form-control" name="address[short][en]"
                                    value="{{ old('address.short.en', isset($branch) ? $branch->address['short']['en'] ?? '' : '') }}">
                            </div>

                            <div class="col-md-6">
                                <label class="form-label">اسم الشارع (ar)</label>
                                <input type="text" class="form-control" name="address[street][ar]"
                                    value="{{ old('address.street.ar', isset($branch) ? $branch->address['street']['ar'] ?? '' : '') }}">
                            </div>
                            <div class="col-md-6">
                                <label class="form-label">اسم الشارع (en)</label>
                                <input type="text" class="form-control" name="address[street][en]"
                                    value="{{ old('address.street.en', isset($branch) ? $branch->address['street']['en'] ?? '' : '') }}">
                            </div>
                            <div class="col-md-6">
                                <label class="form-label">الحي (ar)</label>
                                <input type="text" class="form-control" name="address[district][ar]"
                                    value="{{ old('address.district.ar', isset($branch) ? $branch->address['district']['ar'] ?? '' : '') }}">
                            </div>

                            <div class="col-md-6">
                                <label class="form-label">الحي (en)</label>
                                <input type="text" class="form-control" name="address[district][en]"
                                    value="{{ old('address.district.en', isset($branch) ? $branch->address['district']['en'] ?? '' : '') }}">
                            </div>


                            <div class="col-md-6">
                                <label class="form-label">رقم المبنى</label>
                                <input type="text" class="form-control" name="address[building_no]"
                                    value="{{ old('address.building_no', isset($branch) ? $branch->address['building_no'] ?? '' : '') }}">
                            </div>
                            <div class="col-md-6">
                                <label class="form-label">الرمز البريدي</label>
                                <input type="text" class="form-control" name="address[postal_code]"
                                    value="{{ old('address.postal_code', isset($branch) ? $branch->address['postal_code'] ?? '' : '') }}">
                            </div>





                        </div>
                    </div>
                </div>

                {{-- تبويب:  الاعدادات --}}
                <div class="tab-pane fade" id="tab-setting">
                    <div class="card-section">
                        <div class="d-flex justify-content-between align-items-center mb-2">
                            <h6 class="mb-0"> اعدادات اخرى</h6>

                        </div>
                        <div class="card-section">
                            <div class="row g-3 align-items-end">
                                <div class="col-md-4">
                                    <label class="form-label">الحد الأدنى للعمر</label>
                                    <input type="number" class="form-control" name="min_age" min="0"
                                        max="120"
                                        value="{{ old('min_age', isset($branch) ? $branch->min_age : '') }}">
                                </div>
                                <div class="col-md-4">
                                    <label class="form-label">الحد الأقصى للخصم بالنسبة المئوية <span
                                            class="form-text text-danger mx-2">(أدخل قيمة من 0 إلى 100)</span></label>
                                    <input type="number" class="form-control" name="max_discount_percent"
                                        min="0" max="100" step="0.01"
                                        value="{{ old('max_discount_percent', isset($branch) ? $branch->max_discount_percent : '') }}">

                                </div>

                                <div class="col-md-4">
                                    <label class="form-label">الرقم الضريبى</label>
                                    <input type="text" class="form-control" name="address[tax_no]"
                                        value="{{ old('address.tax_no', isset($branch) ? $branch->address['tax_no'] ?? '' : '') }}">
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                {{-- تبويب: الأهداف الشهرية (6 شهور + 6 شهور جنب بعض) --}}
                <div class="tab-pane fade" id="tab-goals">
                    <div class="card-section">
                        <div class="row g-3 align-items-end">
                            <div class="col-md-3">
                                <label class="form-label">السنة</label>
                                <select id="goalsYear" name="goals[year]" class="form-select">
                                    @for ($y = now()->year - 2; $y <= now()->year + 2; $y++)
                                        <option value="{{ $y }}" @selected(old('goals.year', now()->year) == $y)>
                                            {{ $y }}</option>
                                    @endfor
                                </select>
                            </div>
                            <div class="col-md-9">

                            </div>
                        </div>

                        @php
                            $months = [
                                1 => 'يناير',
                                'فبراير',
                                'مارس',
                                'أبريل',
                                'مايو',
                                'يونيو',
                                'يوليو',
                                'أغسطس',
                                'سبتمبر',
                                'أكتوبر',
                                'نوفمبر',
                                'ديسمبر',
                            ];
                        @endphp

                        <div class="row goals-two-cols mt-3">
                            {{-- النصف الأول --}}
                            <div class="col-md-6">
                                <div class="table-responsive">
                                    <table class="table table-sm table-bordered align-middle text-center"
                                        id="goalsTableH1">
                                        <thead>
                                            <tr>
                                                <th style="width:120px">الشهر</th>
                                                <th>المستهدف</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @foreach (array_slice($months, 0, 6, true) as $m => $label)
                                                @php $i=$m-1; @endphp
                                                <tr data-month="{{ $m }}">
                                                    <td>{{ $label }}</td>
                                                    <td>
                                                        <input type="number" step="0.01" min="0"
                                                            class="form-control target-input"
                                                            name="goals[items][{{ $i }}][target]"
                                                            value="{{ old("goals.items.$i.target") }}">
                                                        <input type="hidden"
                                                            name="goals[items][{{ $i }}][actual]"
                                                            value="0">
                                                        <input type="hidden"
                                                            name="goals[items][{{ $i }}][month]"
                                                            value="{{ $m }}">
                                                    </td>
                                                </tr>
                                            @endforeach
                                        </tbody>
                                    </table>
                                </div>
                            </div>

                            {{-- النصف الثاني --}}
                            <div class="col-md-6">
                                <div class="table-responsive">
                                    <table class="table table-sm table-bordered align-middle text-center"
                                        id="goalsTableH2">
                                        <thead>
                                            <tr>
                                                <th style="width:120px">الشهر</th>
                                                <th>المستهدف</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @foreach (array_slice($months, 6, 6, true) as $m => $label)
                                                @php $i=$m-1; @endphp
                                                <tr data-month="{{ $m }}">
                                                    <td>{{ $label }}</td>
                                                    <td>
                                                        <input type="number" step="0.01" min="0"
                                                            class="form-control target-input"
                                                            name="goals[items][{{ $i }}][target]"
                                                            value="{{ old("goals.items.$i.target") }}">
                                                        <input type="hidden"
                                                            name="goals[items][{{ $i }}][actual]"
                                                            value="0">
                                                        <input type="hidden"
                                                            name="goals[items][{{ $i }}][month]"
                                                            value="{{ $m }}">
                                                    </td>
                                                </tr>
                                            @endforeach
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>

                    </div>
                </div>

            </div> {{-- /tab-content --}}
        </form>
    </div>
@endsection

@section('js')
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // حفظ آخر تاب
            const tabs = document.querySelectorAll('#branchTabs button[data-bs-toggle="tab"]');
            const key = 'branch_form_active_tab';
            const last = localStorage.getItem(key);
            if (last) {
                const triggerEl = document.querySelector(`#branchTabs button[data-bs-target="${last}"]`);
                if (triggerEl) new bootstrap.Tab(triggerEl).show();
            }
            tabs.forEach(btn => btn.addEventListener('shown.bs.tab', e => localStorage.setItem(key, e.target.dataset
                .bsTarget)));

            // تكرار الهواتف
            const wrapper = document.getElementById('phonesWrapper');
            const addBtn = document.getElementById('addPhone');
            addBtn?.addEventListener('click', function() {
                const index = wrapper.querySelectorAll('.phone-row').length;
                const html = `
      <div class="row g-2 phone-row align-items-end mb-2">
        <div class="col-md-3"><label class="form-label">مسمّى (ar)</label><input type="text" class="form-control" name="phones[${index}][label][ar]"></div>
        <div class="col-md-3"><label class="form-label">Label (en)</label><input type="text" class="form-control" name="phones[${index}][label][en]"></div>
        <div class="col-md-4"><label class="form-label">رقم الهاتف</label><input type="text" class="form-control" name="phones[${index}][number]"></div>
        <div class="col-md-2 d-grid"><button type="button" class="btn btn-danger remove-phone"><i class="fas fa-trash"></i></button></div>
      </div>`;
                wrapper.insertAdjacentHTML('beforeend', html);
            });
            wrapper?.addEventListener('click', e => {
                if (e.target.closest('.remove-phone')) e.target.closest('.phone-row').remove();
            });

            // تحميل الأهداف (وضع التعديل فقط)
            @if (isset($branch) && $branch->id)
                const goalsYear = document.getElementById('goalsYear');

                function clearTargets() {
                    document.querySelectorAll('#tab-goals .target-input').forEach(inp => inp.value = '');
                }

                function loadGoals() {
                    clearTargets();
                    const url = `{{ route('branches.goals', $branch) }}?year=${goalsYear.value}`;
                    fetch(url)
                        .then(r => r.json())
                        .then(res => {
                            res.items.forEach(item => {
                                const tr = document.querySelector(
                                    `#tab-goals tr[data-month="${item.month}"]`);
                                if (!tr) return;
                                const input = tr.querySelector('.target-input');
                                if (input) input.value = item.target ?? '';
                            });
                        });
                }
                goalsYear?.addEventListener('change', loadGoals);
                document.querySelector('[data-bs-target="#tab-goals"]')?.addEventListener('shown.bs.tab',
                    loadGoals);
                // أول تحميل
                loadGoals();
            @endif
        });
    </script>
@endsection
