@extends('layouts.master')

@section('title', 'العملاء')
@section('pages') {{ __('dashboard.home') }} @endsection

@section('css')
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css">
@endsection

@section('content')
    <div class="container-fluid">
        <div class="d-flex align-items-center justify-content-between mb-3 flex-wrap gap-2">
            <h5 class="mb-0">العملاء</h5>
            <a href="{{ route('customers.create') }}" class="btn btn-primary"><i class="fas fa-plus mx-2"></i>إضافة عميل</a>
        </div>

        <div class="card p-3 mb-3">
            <div class="row g-2">
                <div class="col-md-4">
                    <input type="text" id="f_name" class="form-control" placeholder="ابحث بالاسم...">
                </div>
                <div class="col-md-4">
                    <select id="f_branch" class="form-select">
                        <option value="">— كل الفروع —</option>
                        @foreach ($branches as $b)
                            <option value="{{ $b->id }}">
                                {{ method_exists($b, 'getTranslation') ? $b->getTranslation('name', app()->getLocale()) : (is_array($b->name) ? $b->name[app()->getLocale()] ?? ($b->name['en'] ?? '') : $b->name) }}
                            </option>
                        @endforeach
                    </select>
                </div>
                <div class="col-md-4 d-grid d-md-flex gap-2">
                    <button class="btn btn-secondary" id="f_reset">إعادة تعيين</button>
                </div>
            </div>
        </div>

        <div class="table-responsive">
            <table class="table table-bordered dataTable w-100 text-center" id="customers-table">
                <thead>
                    <tr>
                        <th>#</th>
                        <th>كود العميل</th>
                        <th>الاسم</th>
                        <th>الفرع</th>
                        <th>إجراءات</th>
                    </tr>
                </thead>
            </table>
        </div>
    </div>
@endsection

@section('js')
    <script>
        $(function() {
            const table = $('#customers-table').DataTable({
                processing: true,
                serverSide: true,
                ajax: {
                    url: "{{ route('customers.index') }}",
                    data: function(d) {
                        d.name = $('#f_name').val();
                        d.branch_id = $('#f_branch').val();
                    }
                },
                order: [
                    [4, 'desc']
                ],
                language: {!! json_encode(__('datatable')) !!},
                columns: [{
                        data: 'DT_RowIndex',
                        name: 'DT_RowIndex',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'customer_code',
                        name: 'customer_code'
                    },
                    {
                        data: 'name',
                        name: 'name'
                    },
                    {
                        data: 'branch_name',
                        name: 'branch.name',
                        orderable: false,
                        searchable: false
                    },

                    {
                        data: 'action',
                        name: 'action',
                        orderable: false,
                        searchable: false
                    },
                ]
            });

            $('#f_name,#f_branch').on('change keyup', () => table.ajax.reload());
            $('#f_reset').on('click', function() {
                $('#f_name').val('');
                $('#f_branch').val('');
                table.ajax.reload();
            });
        });
    </script>
@endsection
