@extends('layouts.master')
@section('title', 'الأعضاء')

@section('css')
    <style>
        /* حاوية الأزرار */
        .dt-actions {
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 8px;
        }

        /* أزرار الأيقونات */
        .dt-actions .btn-icon {
            width: 32px;
            height: 32px;
            padding: 0;
            border-radius: 8px;
            display: flex;
            align-items: center;
            justify-content: center;
            color: #fff;
            border: none;
        }

        /* زر عرض */
        .btn-view {
            background: #0d6efd;
        }

        /* زر تعديل */
        .btn-edit {
            background: #f59e0b;
        }

        /* ===================== */
        /* Switch مخصص أنيق */
        /* ===================== */

        .dt-switch {
            position: relative;
            width: 42px;
            height: 22px;
        }

        .dt-switch input {
            opacity: 0;
            width: 0;
            height: 0;
        }

        .dt-switch .slider {
            position: absolute;
            cursor: pointer;
            inset: 0;
            background-color: #6c757d;
            border-radius: 999px;
            transition: .25s;
        }

        .dt-switch .slider:before {
            content: "";
            position: absolute;
            height: 16px;
            width: 16px;
            left: 3px;
            top: 3px;
            background-color: white;
            border-radius: 50%;
            transition: .25s;
        }

        /* نشط */
        .dt-switch input:checked+.slider {
            background-color: #22c55e;
        }

        .dt-switch input:checked+.slider:before {
            transform: translateX(20px);
        }
    </style>
@endsection

@section('content')
    <div class="container-fluid">

        <div class="d-flex justify-content-between align-items-center mb-3">
            <h5>الأعضاء</h5>
            <a href="{{ route('members.create') }}" class="btn btn-primary">
                <i class="fas fa-user-plus mx-1"></i> إضافة عضو
            </a>
        </div>

        <!-- Filters -->
        <div class="card p-3 mb-3">
            <div class="row g-2">
                <div class="col-md-4">
                    <input id="filter-name" class="form-control" placeholder="ابحث بالاسم">
                </div>

                <div class="col-md-4">
                    <select id="filter-branch" class="form-select">
                        <option value="">— كل الفروع —</option>
                        @foreach ($branches as $b)
                            <option value="{{ $b->id }}">{{ $b->name }}</option>
                        @endforeach
                    </select>
                </div>

                <div class="col-md-4 d-grid">
                    <button id="filter-reset" class="btn btn-secondary">إعادة تعيين</button>
                </div>
            </div>
        </div>

        <!-- Table -->
        <div class="table-responsive">
            <table id="members-table" class="table table-bordered w-100">
                <thead>
                    <tr>
                        <th>#</th>
                        <th>كود العضو</th>
                        <th>الاسم</th>
                        <th>الفرع</th>
                        <th>الحالة</th>
                        <th>تاريخ الإنشاء</th>
                        <th>إجراءات</th>
                    </tr>
                </thead>
            </table>
        </div>

    </div>
@endsection
@section('js')
    <script>
        $(function() {

            let table = $('#members-table').DataTable({
                processing: true,
                serverSide: true,
                ajax: {
                    url: "{{ route('members.index') }}",
                    data: function(d) {
                        d.branch_id = $('#filter-branch').val() || '';
                        d.name = $('#filter-name').val() || '';
                    }
                },
                columns: [{
                        data: 'DT_RowIndex',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'member_code',
                        name: 'member_code'
                    },
                    {
                        data: 'name',
                        name: 'name'
                    },
                    {
                        data: 'branch_name',
                        orderable: false
                    },
                    {
                        data: 'status_badge',
                        orderable: false
                    },
                    {
                        data: 'created_at',
                        name: 'created_at'
                    },
                    {
                        data: 'action',
                        orderable: false,
                        searchable: false
                    },
                ],
                order: [
                    [5, 'desc']
                ],

                createdRow: function(row, data) {
                    if (data.status === 'inactive') {
                        $(row).addClass('table-danger');
                    }
                }

            });

            $('#filter-branch, #filter-name').on('change keyup', function() {
                table.ajax.reload();
            });

            $('#filter-reset').on('click', function() {
                $('#filter-branch').val('');
                $('#filter-name').val('');
                table.ajax.reload();
            });

        });
    </script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

    <script>
        $(document).on('change', '.toggle-status', function() {

            let sw = $(this);
            let checked = sw.is(':checked');
            let id = sw.data('id');
            let status = sw.data('status');

            let wasActive = (status === 'active' || status === 'new');

            Swal.fire({
                title: checked ? 'تفعيل العضو؟' : 'تعطيل العضو؟',
                icon: 'warning',
                showCancelButton: true,
                confirmButtonText: 'نعم',
                cancelButtonText: 'إلغاء'
            }).then(result => {

                if (!result.isConfirmed) {
                    sw.prop('checked', wasActive);
                    return;
                }

                $.post(`/members/${id}/toggle-status`, {
                    _token: $('meta[name="csrf-token"]').attr('content')
                }, () => {
                    $('#members-table').DataTable().ajax.reload(null, false);
                }).fail(() => {
                    sw.prop('checked', wasActive);
                    Swal.fire('خطأ', 'فشل تغيير الحالة', 'error');
                });

            });
        });
    </script>

@endsection
