@extends('layouts.master')
@section('title', 'تعديل عرض')

@section('css')
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css">
    <style>
        .shell {
            background: #0f1e2b;
            border-radius: 14px;
            padding: 14px
        }

        .block {
            background: #0b1621;
            border: 1px solid #203446;
            border-radius: 12px;
            padding: 12px
        }

        .muted {
            opacity: .85
        }

        .badge-soft {
            background: #13283a;
            border: 1px solid #254a65;
            border-radius: 999px;
            padding: 2px 10px;
            color: #d6f0ff
        }

        .table-offer th,
        .table-offer td {
            vertical-align: middle
        }

        .side-panel {
            min-height: 100%;
            display: flex;
            flex-direction: column;
            gap: 10px
        }

        .btn-circle {
            width: 38px;
            height: 38px;
            border-radius: 50%
        }

        .disabled-wrap {
            opacity: .55;
            pointer-events: none;
            filter: grayscale(.3)
        }

        .svc-name {
            white-space: normal;
            line-height: 1.35
        }

        .svc-meta {
            font-size: .85rem;
            opacity: .85
        }
    </style>
@endsection

@section('content')
    <div class="container-fluid">
        @if ($errors->any())
            <div class="alert alert-danger">
                <ul class="mb-0">
                    @foreach ($errors->all() as $e)
                        <li>{{ $e }}</li>
                    @endforeach
                </ul>
            </div>
        @endif

        <form action="{{ route('offers.update', $offer) }}" method="POST" id="offerForm">
            @csrf @method('PUT')

            <div id="itemsHidden"></div>
            <div id="couponsHidden"></div>

            <div class="d-flex align-items-center justify-content-between mb-3">
                <h5 class="mb-0">تعديل عرض #{{ $offer->offer_no }}</h5>
                <div class="d-flex gap-2">
                    <button class="btn btn-primary"><i class="fas fa-save me-2"></i>حفظ</button>
                    <a href="{{ route('offers.index') }}" class="btn btn-secondary">رجوع</a>
                </div>
            </div>

            <div class="row g-3">
                {{-- يسار --}}
                <div class="col-lg-12">
                    <div class="shell">
                        <div class="row g-3">
                            <div class="col-md-4">
                                <div class="block">
                                    <label class="form-label">اسم العرض (ar) <span class="text-danger">*</span></label>
                                    <input type="text" name="name[ar]" class="form-control"
                                        value="{{ old('name.ar', $offer->name['ar'] ?? '') }}" required>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="block">
                                    <label class="form-label">اسم العرض (en) <span class="text-danger">*</span></label>
                                    <input type="text" name="name[en]" class="form-control"
                                        value="{{ old('name.en', $offer->name['en'] ?? '') }}" required>
                                </div>
                            </div>

                            <div class="col-md-4">
                                <div class="block">
                                    <label class="form-label">الحالة</label>
                                    <select name="active" class="form-select">
                                        <option value="1" @selected(old('active', $offer->active))>نشط</option>
                                        <option value="0" @selected(!old('active', $offer->active))>مغلق</option>
                                    </select>
                                </div>
                            </div>

                            {{-- النطاق + التخصيص --}}
                            <div class="col-md-12">
                                <div class="block">
                                    <div class="row g-3">
                                        <div class="col-md-3">
                                            <label class="form-label">الفئة المستهدفة</label>
                                            <select name="scope" id="scope" class="form-select">
                                                <option value="members" @selected(old('scope', $offer->scope) === 'members')>الأعضاء</option>
                                                <option value="customers" @selected(old('scope', $offer->scope) === 'customers')>العملاء</option>
                                                <option value="coupons" @selected(old('scope', $offer->scope) === 'coupons')>كوبونات</option>
                                            </select>
                                        </div>

                                        <div class="col-md-9">
                                            <div id="scope_members"
                                                data-all-members="{{ is_null($offer->target_member_ids) ? '1' : '0' }}"
                                                class="{{ old('scope', $offer->scope) === 'members' ? '' : 'd-none' }}">
                                                <div class="form-check mb-2">
                                                    <input class="form-check-input" type="checkbox" id="all_members"
                                                        name="all_members" value="1" @checked(is_null($offer->target_member_ids) || old('all_members'))>
                                                    <label class="form-check-label" for="all_members">استهداف جميع
                                                        الأعضاء</label>
                                                </div>

                                            </div>

                                            <div id="scope_customers"
                                                data-all-customers="{{ is_null($offer->target_customer_ids) ? '1' : '0' }}"
                                                class="{{ old('scope', $offer->scope) === 'customers' ? '' : 'd-none' }}">
                                                <div class="form-check mb-2">
                                                    <input class="form-check-input" type="checkbox" id="all_customers"
                                                        name="all_customers" value="1" @checked(is_null($offer->target_customer_ids) || old('all_customers'))>
                                                    <label class="form-check-label" for="all_customers">استهداف جميع
                                                        العملاء</label>
                                                </div>
                                                <div id="customers_box"
                                                    class="{{ is_null($offer->target_customer_ids) ? 'disabled-wrap' : '' }}">
                                                    <label class="form-label">تخصيص للعملاء</label>
                                                    <select class="form-select" name="target_customer_ids[]" multiple
                                                        {{ is_null($offer->target_customer_ids) ? 'disabled' : '' }}>
                                                        @foreach ($customers as $c)
                                                            <option value="{{ $c->id }}"
                                                                @selected(in_array($c->id, old('target_customer_ids', $offer->target_customer_ids ?? [])))>
                                                                {{ $c->name }} — {{ $c->customer_code ?? $c->id }}
                                                            </option>
                                                        @endforeach
                                                    </select>
                                                    <div class="form-text muted">عند تفعيل “جميع العملاء” سيتم تجاهل هذه
                                                        القائمة.</div>
                                                </div>
                                            </div>

                                            <div id="scope_coupons"
                                                class="{{ old('scope', $offer->scope) === 'coupons' ? '' : 'd-none' }}">
                                                <label class="form-label">أكواد الكوبونات</label>
                                                <input type="text" class="form-control" id="coupon_inline"
                                                    name="coupon_inline"
                                                    value="{{ old('coupon_inline', is_array($offer->coupon_codes) ? implode(', ', $offer->coupon_codes) : '') }}"
                                                    placeholder="ABC123, XYZ50">
                                                <div class="form-text muted">اكتب الأكواد مفصولة بفواصل؛ سنفككها قبل الحفظ.
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>


                            {{-- التواريخ --}}
                            <div class="col-md-12">
                                <div class="block">
                                    <div class="row g-3 align-items-end">
                                        <div class="col-md-3">
                                            <label class="form-label">تاريخ البداية (ميلادي)</label>
                                            <input type="date" class="form-control" name="start_date_g"
                                                id="start_g"
                                                value="{{ old('start_date_g', $offer->start_date_g)->format('Y-m-d') }}"
                                                required>
                                        </div>
                                        <div class="col-md-3">
                                            <label class="form-label">تاريخ النهاية (ميلادي)</label>
                                            <input type="date" class="form-control" name="end_date_g" id="end_g"
                                                value="{{ old('end_date_g', $offer->end_date_g)->format('Y-m-d') }}"
                                                required>
                                        </div>
                                        <div class="col-md-3">
                                            <label class="form-label">تاريخ البداية (هجري)</label>
                                            <input type="text" class="form-control" name="start_date_h"
                                                id="start_h" value="{{ old('start_date_h', $offer->start_date_h) }}"
                                                readonly>
                                        </div>
                                        <div class="col-md-3">
                                            <label class="form-label">تاريخ النهاية (هجري)</label>
                                            <input type="text" class="form-control" name="end_date_h" id="end_h"
                                                value="{{ old('end_date_h', $offer->end_date_h) }}" readonly>
                                        </div>
                                        <div class="col-md-3">
                                            <label class="form-label">المدّة (أيام)</label>
                                            <input type="text" class="form-control" id="duration_days"
                                                value="{{ $offer->duration_days }}" readonly>
                                        </div>
                                    </div>
                                </div>
                            </div>



                        </div>
                    </div>
                </div>

                {{-- يمين --}}
                <div class="col-lg-12">
                    <div class="shell side-panel">
                        <div class="block">
                            <label class="form-label">الخصم العام</label>
                            <div class="input-group">
                                @php $dt = old('discount_type',$offer->discount_type); @endphp
                                <select class="form-select" name="discount_type" id="g_discount_type"
                                    style="max-width:110px">
                                    <option value="percent" @selected($dt === 'percent')>%</option>
                                    <option value="amount" @selected($dt === 'amount')>مبلغ</option>
                                </select>
                                <input type="number" step="0.01" min="0" class="form-control"
                                    name="discount_value" id="g_discount_value"
                                    value="{{ old('discount_value', $offer->discount_value) }}">
                            </div>
                            <div class="form-text muted">يُطبّق تلقائيًا على كل الخدمات (لا تعديل صفّي).</div>
                        </div>

                        <div class="block">
                            <label class="form-label">أيام إضافية (لجميع الخدمات)</label>
                            <input type="number" class="form-control" name="extra_days" id="g_extra_days"
                                min="0" value="{{ old('extra_days', $offer->extra_days) }}">
                        </div>

                        {{-- الحقول الجديدة لوقت الإيقاف --}}
                        <div class="block">
                            <label class="form-label">عدد أيام الإيقاف</label>
                            <input type="number" class="form-control" name="stop_days" id="g_stop_days" min="0"
                                value="{{ old('stop_days', $offer->stop_days ?? '') }}">
                        </div>

                        <div class="block">
                            <label class="form-label">عدد مرات الإيقاف</label>
                            <input type="number" class="form-control" name="stop_times" id="g_stop_times"
                                min="0" value="{{ old('stop_times', $offer->stop_times ?? '') }}">
                            <div class="form-text muted">تُرسل هذه القيم مع النموذج (ليست مطلوبة لإضافة الخدمة، إذا أردت
                                جعلها إلزامية أخبرني).</div>
                        </div>
                    </div>
                </div>

                {{-- قائمة العروض (الخدمات) --}}
                <div class="col-md-12">
                    <div class="block">
                        <div class="d-flex align-items-center justify-content-between mb-2">
                            <span class="badge-soft">قائمة العروض</span>
                            <div class="d-flex gap-2">
                                <select id="service_select" class="form-select" style="min-width:320px">
                                    <option value="">— اختر خدمة لإضافتها —</option>
                                    @foreach ($services as $s)
                                        <option value="{{ $s->id }}">
                                            {{ $s->getTranslation('name', app()->getLocale()) }}</option>
                                    @endforeach
                                </select>
                                <button type="button" class="btn btn-success btn-circle" id="addServiceBtn">
                                    <i class="fas fa-plus"></i>
                                </button>
                            </div>
                        </div>

                        <div class="table-responsive">
                            <table class="table table-sm table-bordered table-offer align-middle" id="itemsTable">
                                <thead>
                                    <tr class="text-center">
                                        <th style="width:26px">#</th>
                                        <th>الخدمة</th>
                                        <th>السعر الأساسي</th>
                                        <th>المدة الأساسية</th>
                                        <th>السعر النهائي</th>
                                        <th>المدة النهائية</th>
                                        <th style="width:54px">حذف</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @php $locale = app()->getLocale(); @endphp
                                    @foreach ($offer->items as $i => $it)
                                        @php
                                            $n =
                                                $it->service?->getTranslation('name', $locale) ??
                                                ($it->service_name[$locale] ?? ($it->service_name['en'] ?? ''));
                                        @endphp
                                        <tr data-id="{{ $it->service_id }}">
                                            <td class="text-center">{{ $i + 1 }}</td>
                                            <td>
                                                <div class="svc-name fw-bold" title="{{ $n }}">
                                                    {{ $n }}</div>
                                                <div class="svc-meta text-muted">النوع/المدة الأساسية:
                                                    {{ $it->base_duration_value }} {{ $it->base_duration_unit }}</div>
                                                <input type="hidden" class="svc-id" value="{{ $it->service_id }}">
                                            </td>
                                            <td class="text-center"><span
                                                    class="base-price">{{ number_format($it->base_price, 2, '.', '') }}</span>
                                            </td>
                                            <td class="text-center">
                                                <span class="base-dur">{{ $it->base_duration_value }}</span>
                                                <span class="badge bg-dark ms-1">{{ $it->base_duration_unit }}</span>
                                            </td>
                                            <td class="text-center"><span class="final-price fw-bold">0.00</span></td>
                                            <td class="text-center">
                                                <span class="final-dur fw-bold">0</span>
                                                <span class="badge bg-secondary ms-1">{{ $it->base_duration_unit }}</span>
                                            </td>
                                            <td class="text-center">
                                                <button type="button" class="btn btn-sm btn-danger remove-row"><i
                                                        class="fas fa-trash"></i></button>
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>

                    </div>
                </div>

                {{-- hidden fields --}}
                <div id="itemsHidden"></div>
                <div id="couponsHidden"></div>

            </div>
        </form>
    </div>
@endsection

@section('js')
    <script src="https://cdn.jsdelivr.net/npm/moment@2.29.4/moment.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/moment-hijri@2.2.0/moment-hijri.min.js"></script>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const scopeEl = document.getElementById('scope');

            const scopeMembers = document.getElementById('scope_members');
            const allMembers = document.getElementById('all_members');
            const membersBox = document.getElementById('members_box');
            const membersSelect = membersBox ? membersBox.querySelector('select') : null;

            const scopeCustomers = document.getElementById('scope_customers');
            const allCustomers = document.getElementById('all_customers');
            const customersBox = document.getElementById('customers_box');
            const customersSelect = customersBox ? customersBox.querySelector('select') : null;

            const scopeCoupons = document.getElementById('scope_coupons');
            const couponInline = document.getElementById('coupon_inline');

            // helper: apply disabled-wrap class and disabled attribute on select
            function applyBoxState(boxEl, selectEl, disabled) {
                if (!boxEl) return;
                boxEl.classList.toggle('disabled-wrap', disabled);
                if (selectEl) selectEl.disabled = disabled;
            }

            // switchScope مع احترام initial (true عند التحميل الأولي)
            function switchScope(initial = false) {
                const v = scopeEl.value;

                // members
                const membersDefaultAll = scopeMembers?.dataset?.allMembers === '1'; // من server
                if (v === 'members') {
                    scopeMembers.classList.remove('d-none');

                    if (initial) {
                        // عند التحميل: احترم حالة العرض الحالي (data-all-members) أو old()
                        allMembers.checked = membersDefaultAll || !!allMembers.checked;
                    } else {
                        // عند تغيير المستخدم إلى members: افعل "الكل" تلقائيًا (سلوك الإضافة)
                        allMembers.checked = true;
                    }
                    applyBoxState(membersBox, membersSelect, allMembers.checked);
                } else {
                    scopeMembers.classList.add('d-none');
                    applyBoxState(membersBox, membersSelect, true);
                }

                // customers
                const customersDefaultAll = scopeCustomers?.dataset?.allCustomers === '1';
                if (v === 'customers') {
                    scopeCustomers.classList.remove('d-none');

                    if (initial) {
                        allCustomers.checked = customersDefaultAll || !!allCustomers.checked;
                    } else {
                        // عند تغيير المستخدم إلى customers: لا نفعل all_customers افتراضياً،
                        // اترك القيمة كما هي (أو ضع false إذا تريد سلوكًا مختلفًا)
                        allCustomers.checked = allCustomers.checked && initial; // يحاول الحفاظ على القديم
                    }
                    applyBoxState(customersBox, customersSelect, allCustomers.checked);
                } else {
                    scopeCustomers.classList.add('d-none');
                    applyBoxState(customersBox, customersSelect, true);
                }

                // coupons
                if (v === 'coupons') {
                    scopeCoupons.classList.remove('d-none');
                    if (couponInline) couponInline.disabled = false;
                } else {
                    scopeCoupons.classList.add('d-none');
                    if (couponInline) couponInline.disabled = true;
                }
            }

            // مستمع لتغيير النطاق => تغيير بواسطة المستخدم (initial=false)
            scopeEl.addEventListener('change', function() {
                switchScope(false);
            });

            // عند تغيير checkbox "الكل" نطبق القفل/فتح مباشرة
            allMembers?.addEventListener('change', function() {
                applyBoxState(membersBox, membersSelect, this.checked);
            });
            allCustomers?.addEventListener('change', function() {
                applyBoxState(customersBox, customersSelect, this.checked);
            });

            // تهيئة أولية تحترم بيانات الـ offer (initial = true)
            switchScope(true);
        });



        // تواريخ: ميلادي → هجري + مدة
        function gToH(iso) {
            if (!iso) return '';
            if (typeof moment.fn.iYear === 'function') {
                const m = moment(iso, 'YYYY-MM-DD', true);
                return m.isValid() ? m.format('iYYYY-iMM-iDD') : '';
            }
            try {
                const dt = new Date(iso + 'T00:00:00');
                const fmt = new Intl.DateTimeFormat('en-u-ca-islamic', {
                    year: 'numeric',
                    month: '2-digit',
                    day: '2-digit'
                });
                const p = Object.fromEntries(fmt.formatToParts(dt).map(x => [x.type, x.value]));
                return `${p.year}-${p.month}-${p.day}`;
            } catch (e) {
                return '';
            }
        }

        function refreshDates() {
            const s = document.getElementById('start_g').value,
                e = document.getElementById('end_g').value;
            document.getElementById('start_h').value = gToH(s);
            document.getElementById('end_h').value = gToH(e);
            if (s && e) {
                const d = moment(e, 'YYYY-MM-DD', true).diff(moment(s, 'YYYY-MM-DD', true), 'days') + 1;
                document.getElementById('duration_days').value = d > 0 ? d : 0;
            } else document.getElementById('duration_days').value = '';
        }
        document.getElementById('start_g').addEventListener('change', refreshDates);
        document.getElementById('end_g').addEventListener('change', refreshDates);
        refreshDates();

        document.addEventListener('DOMContentLoaded', function() {
            const tbody = document.querySelector('#itemsTable tbody');
            // مجموعة الـ ids المضافة مسبقاً (مهمة لعدم التكرار)
            const chosen = new Set(Array.from(tbody.querySelectorAll('tr')).map(tr => tr.dataset.id));

            function rowTpl(idx, svc) {
                return `<tr data-id="${svc.id}">
            <td class="text-center">${idx}</td>
            <td>
                <div class="svc-name fw-bold" title="${escapeHtml(svc.name)}">${escapeHtml(svc.name)}</div>
                <div class="svc-meta text-muted">النوع/المدة الأساسية: ${svc.duration_value} ${svc.duration_unit}</div>
                <input type="hidden" class="svc-id" value="${svc.id}">
            </td>
            <td class="text-center"><span class="base-price">${Number(svc.price).toFixed(2)}</span></td>
            <td class="text-center"><span class="base-dur">${svc.duration_value}</span>
                <span class="badge bg-dark ms-1">${svc.duration_unit}</span></td>
            <td class="text-center"><span class="final-price fw-bold">0.00</span></td>
            <td class="text-center"><span class="final-dur fw-bold">0</span>
                <span class="badge bg-secondary ms-1">${svc.duration_unit}</span></td>
            <td class="text-center"><button type="button" class="btn btn-sm btn-danger remove-row"><i class="fas fa-trash"></i></button></td>
        </tr>`;
            }

            function escapeHtml(s) {
                if (!s) return '';
                return String(s).replace(/&/g, '&amp;').replace(/</g, '&lt;').replace(/>/g, '&gt;').replace(/"/g,
                    '&quot;').replace(/'/g, '&#039;');
            }

            function recalcRow(tr) {
                const price = parseFloat(tr.querySelector('.base-price').textContent) || 0;
                const dur = parseInt(tr.querySelector('.base-dur').textContent) || 0;
                const gType = document.getElementById('g_discount_type').value;
                const gVal = parseFloat(document.getElementById('g_discount_value').value) || 0;
                const gExt = parseInt(document.getElementById('g_extra_days').value) || 0;

                let final = price;
                if (gType === 'percent') final = Math.max(0, price - price * (gVal / 100));
                else final = Math.max(0, price - gVal);

                tr.querySelector('.final-price').textContent = final.toFixed(2);
                tr.querySelector('.final-dur').textContent = dur + (isNaN(gExt) ? 0 : gExt);
            }

            function recalcAll() {
                tbody.querySelectorAll('tr').forEach(recalcRow);
            }

            // استمع لتغيّر الحقول الثلاثة وأعد الحساب
            ['g_discount_type', 'g_discount_value', 'g_extra_days'].forEach(id => {
                const el = document.getElementById(id);
                if (!el) return;
                el.addEventListener('input', recalcAll);
                el.addEventListener('change', recalcAll);
            });

            // حساب مبدئي عند التحميل
            recalcAll();

            // حذف صف
            tbody.addEventListener('click', e => {
                const btn = e.target.closest('.remove-row');
                if (!btn) return;
                const tr = btn.closest('tr');
                chosen.delete(tr.dataset.id);
                tr.remove();
                reindex();
            });

            function reindex() {
                let i = 1;
                tbody.querySelectorAll('tr').forEach(tr => tr.children[0].textContent = i++);
                recalcAll();
            }

            // إضافة خدمة - تحقق صارم: discount_value > 0 و extra_days > 0
            document.getElementById('addServiceBtn').addEventListener('click', async () => {
                const sel = document.getElementById('service_select');
                if (!sel.value) return;

                const gValRaw = (document.getElementById('g_discount_value')?.value || '').toString()
                    .trim();
                const gExtRaw = (document.getElementById('g_extra_days')?.value || '').toString()
                    .trim();

                const gVal = Number(gValRaw);
                const gExt = Number(gExtRaw);

                if (gValRaw === '' || !isFinite(gVal) || gVal <= 0) {
                    return (window.toastr ? toastr.error('قيمة الخصم يجب أن تكون رقمًا أكبر من صفر') :
                        alert('قيمة الخصم يجب أن تكون رقمًا أكبر من صفر'));
                }
                if (gExtRaw === '' || !isFinite(gExt) || gExt <= 0) {
                    return (window.toastr ? toastr.error(
                        'عدد الأيام الإضافية يجب أن يكون رقمًا أكبر من صفر') : alert(
                        'عدد الأيام الإضافية يجب أن يكون رقمًا أكبر من صفر'));
                }

                if (chosen.has(sel.value)) {
                    return (window.toastr ? toastr.info('تمت إضافة هذه الخدمة مسبقًا') : alert(
                        'مكررة'));
                }

                try {
                    const res = await fetch(`{{ route('offers.service-info', 0) }}`.replace('/0', '/' +
                        sel.value), {
                        headers: {
                            'Accept': 'application/json'
                        }
                    });
                    if (!res.ok) throw new Error('fetch failed');
                    const j = await res.json();
                    const svc = {
                        id: j.id,
                        name: j.name["{{ app()->getLocale() }}"] ?? (j.name.en ?? Object.values(j
                            .name)[0] ?? ''),
                        price: j.price,
                        duration_value: j.duration_value,
                        duration_unit: j.duration_unit
                    };
                    chosen.add(String(svc.id));
                    tbody.insertAdjacentHTML('beforeend', rowTpl(tbody.children.length + 1, svc));
                    recalcAll();
                    sel.value = '';
                } catch (err) {
                    (window.toastr ? toastr.error('حدث خطأ أثناء جلب بيانات الخدمة') : alert(
                        'خطأ في جلب بيانات الخدمة'));
                    console.error(err);
                }
            });

            // عند الحفظ: جهّز عناصر الخدمات + الكوبونات
            document.getElementById('offerForm').addEventListener('submit', (e) => {
                const rows = [...tbody.querySelectorAll('tr')];
                if (rows.length === 0) {
                    e.preventDefault();
                    alert('يجب إضافة خدمة واحدة على الأقل.');
                    return;
                }
                const box = document.getElementById('itemsHidden');
                box.innerHTML = '';
                rows.forEach((tr, i) => {
                    const sid = parseInt(tr.querySelector('.svc-id').value);
                    box.insertAdjacentHTML('beforeend',
                        `<input type="hidden" name="items[${i}][service_id]" value="${sid}">`);
                });

                const inline = document.getElementById('coupon_inline')?.value || '';
                const coupons = document.getElementById('couponsHidden');
                coupons.innerHTML = '';
                if (inline) {
                    inline.split(',').map(s => s.trim()).filter(Boolean).forEach(code => {
                        coupons.insertAdjacentHTML('beforeend',
                            `<input type="hidden" name="coupon_codes[]" value="${escapeHtml(code)}">`
                        );
                    });
                }

                // ملاحظة: حقول stop_days و stop_times تُرسل لأنها inputs في الفورم (ليست مضمنة هنا كـ items)
            });

            // helper escape (مكرر عند الحاجة)
            function escapeHtml(s) {
                if (!s) return '';
                return String(s).replace(/&/g, '&amp;').replace(/</g, '&lt;').replace(/>/g, '&gt;').replace(/"/g,
                    '&quot;').replace(/'/g, '&#039;');
            }
        });
    </script>
@endsection
