@extends('layouts.master')
@section('title', 'تفاصيل العرض')

@section('css')
    <style>
        .shell {
            background: #0f1e2b;
            border-radius: 14px;
            padding: 14px
        }

        .kpi {
            background: #0b1621;
            border: 1px solid #203446;
            border-radius: 12px;
            padding: 12px;
            height: 100%
        }

        .kpi .label {
            opacity: .7;
            font-size: .85rem
        }

        .kpi .value {
            font-weight: 700;
            font-size: 1.05rem
        }

        .chip {
            background: #13283a;
            border: 1px solid #254a65;
            border-radius: 999px;
            padding: 4px 10px;
            margin-left: 6px;
            display: inline-flex;
            gap: 6px;
            align-items: center
        }

        .badge-soft {
            background: #13283a;
            border: 1px solid #254a65;
            border-radius: 999px;
            padding: 2px 10px;
            color: #d6f0ff
        }

        .table-offer th,
        .table-offer td {
            vertical-align: middle
        }
    </style>
@endsection

@section('content')
    @php $loc = app()->getLocale(); @endphp
    <div class="d-flex align-items-center justify-content-between mb-3">
        <div>
            <h5 class="mb-1">{{ $offer->name[$loc] ?? ($offer->name['en'] ?? '—') }}</h5>
            <div class="d-flex align-items-center flex-wrap gap-2">
                <span class="chip"><i class="fas fa-hashtag"></i> {{ $offer->offer_no }}</span>
                <span class="chip"><i class="fas fa-layer-group"></i>
                    @switch($offer->scope)
                        @case('members')
                            الأعضاء
                        @break

                        @case('customers')
                            العملاء
                        @break

                        @case('coupons')
                            كوبونات
                        @break

                        @default
                            جميع الأعضاء/العملاء
                    @endswitch
                </span>
                <span class="chip">
                    {!! $offer->active
                        ? '<i class="fas fa-check-circle text-success"></i> نشط'
                        : '<i class="fas fa-ban text-secondary"></i> غير نشط' !!}
                </span>
            </div>
        </div>
        <div class="d-flex gap-2">
            <a href="{{ route('offers.edit', $offer) }}" class="btn btn-warning"><i class="fas fa-edit me-1"></i> تعديل</a>
            <a href="{{ route('offers.index') }}" class="btn btn-secondary">رجوع</a>
        </div>
    </div>

    <div class="shell mb-3">
        <div class="row g-3">
            <div class="col-md-3">
                <div class="kpi">
                    <div class="label mb-1">الفترة (ميلادي)</div>
                    <div class="value">{{ $offer->start_date_g }} → {{ $offer->end_date_g }}</div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="kpi">
                    <div class="label mb-1">الفترة (هجري)</div>
                    <div class="value">{{ $offer->start_date_h ?? '—' }} → {{ $offer->end_date_h ?? '—' }}</div>
                </div>
            </div>
            <div class="col-md-2">
                <div class="kpi">
                    <div class="label mb-1">المدّة بالأيام</div>
                    <div class="value">{{ $offer->duration_days }}</div>
                </div>
            </div>
            <div class="col-md-2">
                <div class="kpi">
                    <div class="label mb-1">خصم عام</div>
                    <div class="value">
                        @if ($offer->discount_type === 'percent')
                            {{ number_format($offer->discount_value, 2) }}%
                        @else
                            {{ number_format($offer->discount_value, 2) }}
                        @endif
                    </div>
                </div>
            </div>
            <div class="col-md-2">
                <div class="kpi">
                    <div class="label mb-1">أيام إضافية للخدمات</div>
                    <div class="value">{{ (int) $offer->extra_days }}</div>
                </div>
            </div>
        </div>
    </div>

    <div class="shell">
        <div class="d-flex align-items-center justify-content-between mb-2">
            <span class="badge-soft">خدمات العرض</span>
            <span class="text-muted">عدد الخدمات: {{ $offer->items->count() }}</span>
        </div>

        <div class="table-responsive">
            <table class="table table-sm table-bordered table-offer align-middle">
                <thead>
                    <tr class="text-center">
                        <th style="width:26px">#</th>
                        <th>الخدمة</th>
                        <th>السعر الأساسي</th>
                        <th>المدة الأساسية</th>
                        <th>السعر النهائي</th>
                        <th>المدة النهائية</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($offer->items as $i => $it)
                        @php
                            $name =
                                $it->service?->getTranslation('name', $loc) ??
                                ($it->service_name[$loc] ?? ($it->service_name['en'] ?? ''));
                        @endphp
                        <tr>
                            <td class="text-center">{{ $i + 1 }}</td>
                            <td>
                                <div class="fw-bold" title="{{ $name }}">{{ $name }}</div>
                            </td>
                            <td class="text-center">{{ number_format($it->base_price, 2) }}</td>
                            <td class="text-center">{{ $it->base_duration_value }} <span
                                    class="badge bg-dark ms-1">{{ $it->base_duration_unit }}</span></td>
                            <td class="text-center fw-bold">{{ number_format($it->final_price, 2) }}</td>
                            <td class="text-center fw-bold">{{ $it->final_duration_value }} <span
                                    class="badge bg-secondary ms-1">{{ $it->final_duration_unit }}</span></td>
                        </tr>
                    @endforeach
                    @if ($offer->items->isEmpty())
                        <tr>
                            <td colspan="6" class="text-center text-muted">لا توجد خدمات مرتبطة بهذا العرض.</td>
                        </tr>
                    @endif
                </tbody>
            </table>
        </div>
    </div>
@endsection
