@extends('layouts.master')

@section('pages')
    {{ __('dashboard.home') }}
@endsection
@section('title')
    {{ __('dashboard.categories') }}
@endsection

@section('btn')
    <button class="btn btn-outline-success" type="button" data-bs-toggle="modal" data-bs-target="#categoryAdd">
        <i class="fas fa-plus-circle mx-2"></i> {{ __('dashboard.addCategory') }}
    </button>
@endsection

@section('css')
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css">
    <style>
        #categories-table th,
        #categories-table td {
            text-align: center;
            vertical-align: middle;
        }

        .dataTables_processing {
            background: none !important;
            color: teal !important;
            font-weight: bold;
        }

        .btn {
            width: 100% !important;
            padding: 6px !important;
        }
    </style>
@endsection

@section('content')
    <div class="row">
        <div class="col-xl-12">
            <div class="table-responsive">
                <table class="table table-bordered dataTable" id="categories-table">
                    <thead>
                        <tr>
                            <th>#</th>
                            <th>{{ __('dashboard.name') }}</th>
                            <th>{{ __('dashboard.action') }}</th>
                        </tr>
                    </thead>
                </table>
            </div>
        </div>
    </div>

    {{-- Add Modal --}}
    <div class="modal fade" id="categoryAdd" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog modal-lg modal-fullscreen-md-down">
            <div class="modal-content">
                <div class="modal-header">
                    <h3 class="modal-title fs-5">{{ __('dashboard.addCategory') }}</h3>
                    <button class="btn-close" type="button" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <form id="categoryCreateForm" class="needs-validation" novalidate>
                    @csrf
                    <div class="modal-body">
                        <div id="categoryRepeater">
                            <div class="row g-3 align-items-end">
                                <div class="col-md-6">
                                    <label class="form-label">{{ __('dashboard.name_ar') }}</label>
                                    <input class="form-control" type="text" name="name[ar]" required>
                                    <div class="invalid-feedback">{{ __('dashboard.name_ar_required') }}</div>
                                </div>
                                <div class="col-md-6">
                                    <label class="form-label">{{ __('dashboard.name_en') }}</label>
                                    <input class="form-control" type="text" name="name[en]" required>
                                    <div class="invalid-feedback">{{ __('dashboard.name_en_required') }}</div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button class="btn btn-secondary" type="button" data-bs-dismiss="modal">
                            <i class="fas fa-times-circle mx-2"></i>{{ __('dashboard.close') }}
                        </button>
                        <button class="btn btn-primary" type="submit">
                            <i class="fas fa-save mx-2"></i>{{ __('dashboard.save') }}
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    {{-- Show Modal --}}
    <div class="modal fade" id="showCategoryModal" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog modal-fullscreen-md-down">
            <div class="modal-content">
                <div class="modal-header">
                    <h3 class="modal-title fs-5">{{ __('dashboard.showCategory') }}</h3>
                    <button class="btn-close" type="button" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <dl class="row">
                        <dt class="col-sm-3">ID</dt>
                        <dd class="col-sm-9" id="show_id">—</dd>
                        <dt class="col-sm-3">{{ __('dashboard.name_ar') }}</dt>
                        <dd class="col-sm-9" id="show_name_ar">—</dd>
                        <dt class="col-sm-3">{{ __('dashboard.name_en') }}</dt>
                        <dd class="col-sm-9" id="show_name_en">—</dd>
                    </dl>
                </div>
                <div class="modal-footer">
                    <button class="btn btn-secondary" data-bs-dismiss="modal">{{ __('dashboard.close') }}</button>
                </div>
            </div>
        </div>
    </div>

    {{-- Edit Modal --}}
    <div class="modal fade" id="editCategoryModal" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog modal-fullscreen-md-down">
            <div class="modal-content">
                <div class="modal-header">
                    <h3 class="modal-title fs-5">{{ __('dashboard.editCategory') }}</h3>
                    <button class="btn-close" type="button" data-bs-dismiss="modal"></button>
                </div>
                <form id="categoryEditForm" class="needs-validation" novalidate>
                    @csrf
                    <input type="hidden" id="edit_id">
                    <div class="modal-body">
                        <div class="row">
                            <div class="col-12 mb-3">
                                <label class="form-label">{{ __('dashboard.name_ar') }}</label>
                                <input class="form-control" id="edit_name_ar" type="text" required>
                                <div class="invalid-feedback">{{ __('dashboard.name_ar_required') }}</div>
                            </div>
                            <div class="col-12 mb-3">
                                <label class="form-label">{{ __('dashboard.name_en') }}</label>
                                <input class="form-control" id="edit_name_en" type="text" required>
                                <div class="invalid-feedback">{{ __('dashboard.name_en_required') }}</div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button class="btn btn-secondary" type="button" data-bs-dismiss="modal">
                            <i class="fas fa-times-circle mx-2"></i>{{ __('dashboard.close') }}
                        </button>
                        <button class="btn btn-primary" type="submit">
                            <i class="fas fa-save mx-2"></i>{{ __('dashboard.update') }}
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
@endsection

@section('js')
    <script>
        $(function() {
            // جدول AJAX
            const table = $('#categories-table').DataTable({
                processing: true,
                serverSide: true,
                ajax: "{{ route('branch-categories.index') }}",
                language: {!! json_encode(__('datatable')) !!},
                columns: [{
                        data: 'DT_RowIndex',
                        name: 'DT_RowIndex',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'translated_name',
                        name: 'translated_name'
                    },
                    {
                        data: 'action',
                        name: 'action',
                        orderable: false,
                        searchable: false
                    }
                ]
            });

            // إضافة (AJAX)
            $('#categoryCreateForm').on('submit', function(e) {
                e.preventDefault();
                $.ajax({
                    url: "{{ route('branch-categories.store') }}",
                    type: "POST",
                    data: $(this).serialize(),
                    success: function(res) {
                        toastr.success(res.message);
                        $('#categoryCreateForm')[0].reset();
                        $('#categoryAdd').modal('hide');
                        table.ajax.reload();
                    },
                    error: function(xhr) {
                        const msg = xhr.responseJSON?.message ||
                            "{{ __('dashboard.create_failed') }}";
                        toastr.error(msg);
                    }
                });
            });

            // فتح Show
            $(document).on('click', '.show-btn', function() {
                const id = $(this).data('id');
                $.get("{{ url('branch-categories') }}/" + id, function(res) {
                    $('#show_id').text(res.id);
                    $('#show_name_ar').text(res.name?.ar ?? '—');
                    $('#show_name_en').text(res.name?.en ?? '—');
                    $('#showCategoryModal').modal('show');
                });
            });

            // فتح Edit
            $(document).on('click', '.edit-btn', function() {
                $('#edit_id').val($(this).data('id'));
                $('#edit_name_ar').val($(this).data('name_ar'));
                $('#edit_name_en').val($(this).data('name_en'));
                $('#editCategoryModal').modal('show');
            });

            // حفظ Edit (AJAX)
            $('#categoryEditForm').on('submit', function(e) {
                e.preventDefault();
                const id = $('#edit_id').val();
                const payload = {
                    _token: "{{ csrf_token() }}",
                    _method: "PUT",
                    'name[ar]': $('#edit_name_ar').val(),
                    'name[en]': $('#edit_name_en').val(),
                };

                $.ajax({
                    url: "{{ url('branch-categories') }}/" + id,
                    type: "POST", // نستخدم POST مع _method=PUT
                    data: payload,
                    success: function(res) {
                        toastr.success(res.message);
                        $('#editCategoryModal').modal('hide');
                        table.ajax.reload();
                    },
                    error: function(xhr) {
                        const msg = xhr.responseJSON?.message ||
                            "{{ __('dashboard.update_failed') }}";
                        toastr.error(msg);
                    }
                });
            });
        });
    </script>
@endsection
