@extends('layouts.master')

@section('pages')
    {{ __('dashboard.home') }}
@endsection
@section('title')
    {{ __('dashboard.grades') }}
@endsection

@section('btn')
    <button class="btn btn-outline-success" type="button" data-bs-toggle="modal" data-bs-target="#gradeAdd"><i
            class="fas fa-plus-circle mx-2"></i> {{ __('dashboard.addGrade') }} </button>
@endsection
@section('css')
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css">
    <style>
        /* Center align text in the table header and rows */
        #grades-table th,
        #grades-table td {
            text-align: center;
            vertical-align: middle;
        }

        .dataTables_processing {
            background: none !important;
            color: teal !important;
            /* Ensures the text is visible */
            font-size: 16px;
            /* Adjust text size */
            font-weight: bold;
            /* Makes text bold */
            border: none !important;
            /* Removes any border */
            box-shadow: none !important;
            /* Removes shadow */
        }

        .btn {
            width: 100% !important;
            padding: 5px !important;
        }
    </style>
@endsection
@section('content')
    <div class="row">
        <div class="col-xl-12">
            <div class="table-responsive">
                <table class="table table-bordered dataTable" id="grades-table">
                    <thead>
                        <tr>
                            <th>#</th>
                            <th>{{ __('dashboard.name') }}</th>
                            <th>{{ __('dashboard.classroom') }}</th>
                            <th>{{ __('dashboard.action') }}</th>
                        </tr>
                    </thead>
                </table>
            </div>

        </div>
    </div>


    <!-- Grade Add -->
    <div class="modal fade" id="gradeAdd" tabindex="-1" aria-labelledby="mdModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg modal-fullscreen-md-down">
            <div class="modal-content">
                <div class="modal-header">
                    <h3 class="modal-title fs-5" id="mdModalLabel">{{ __('dashboard.addGrade') }}</h3>
                    <button class="btn-close" type="button" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <form class=" needs-validation custom-input validation-forms" novalidate=""
                    action="{{ route('grades.store') }}" method="POST">
                    @csrf
                    <div class="modal-body dark-modal">

                        <div id="gradeRepeater">
                            <div class="row grade-item">
                                <div class="col-12 col-xl-5 col-lg-5 col-md-10 col-sm-12 mb-2">
                                    <label class="col-form-label">{{ __('dashboard.name_ar') }}</label>
                                    <input class="form-control" type="text" name="grades[0][name_ar]" required = "">
                                    <div class="invalid-feedback">{{ __('dashboard.name_ar_required') }}</div>
                                </div>
                                <div class="col-10 col-xl-5 col-lg-5 col-md-10 col-sm-10 mb-2">
                                    <label class="col-form-label">{{ __('dashboard.name_en') }}</label>
                                    <input class="form-control" type="text" name="grades[0][name_en]" required = "">
                                    <div class="invalid-feedback">{{ __('dashboard.name_en_required') }}</div>
                                </div>
                                <div class="col-2 col-xl-2 col-lg-2 col-md-12 col-sm-2 mb-2 d-flex align-items-end">
                                    <button type="button" class="btn btn-info mt-3" id="addGrade">
                                        <i class="fas fa-plus-square"></i></button>

                                </div>
                            </div>
                        </div>


                    </div>
                    <div class="modal-footer">
                        <button class="btn btn-secondary" type="button" data-bs-dismiss="modal"> <i
                                class="fas fa-times-circle mx-2"></i>{{ __('dashboard.close') }}</button>
                        <button class="btn btn-primary" type="submit"> <i
                                class="fas fa-save mx-2"></i>{{ __('dashboard.save') }} </button>
                    </div>
                </form>
            </div>
        </div>
    </div>


    <!-- Grade Edit -->
    <div class="modal fade" id="editGradeModal" tabindex="-1" aria-labelledby="mdModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-fullscreen-md-down">
            <div class="modal-content">
                <div class="modal-header">
                    <h3 class="modal-title fs-5" id="mdModalLabel">{{ __('dashboard.editGrade') }}</h3>
                    <button class="btn-close" type="button" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>

                <form id="gradeEdit" class=" needs-validation custom-input validation-forms" novalidate="">
                    @csrf
                    <div class="modal-body dark-modal">
                        <div class="row">
                            <input type="hidden" id="grade_id">
                            <div class="col-12">
                                <label class="col-sm-12 col-form-label"
                                    for="name_ar">{{ __('dashboard.name_ar') }}</label>
                                <input class="form-control" id="name_ar" type="text" required="">
                                <div class="invalid-feedback">{{ __('dashboard.name_ar_required') }}</div>
                            </div>

                            <div class="col-12">
                                <label class="col-sm-12 col-form-label"
                                    for="name_en">{{ __('dashboard.name_en') }}</label>
                                <input class="form-control" id="name_en" type="text" required="">
                                <div class="invalid-feedback">{{ __('dashboard.name_en_required') }}</div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button class="btn btn-secondary" type="button" data-bs-dismiss="modal"> <i
                                class="fas fa-times-circle mx-2"></i>{{ __('dashboard.close') }}</button>
                        <button class="btn btn-primary" type="submit"> <i
                                class="fas fa-save mx-2"></i>{{ __('dashboard.update') }} </button>
                    </div>
                </form>
            </div>
        </div>
    </div>


    <!-- Add Class To grade  -->
    <div class="modal fade" id="addClassToGrade" tabindex="-1" aria-labelledby="mdModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg modal-fullscreen-md-down">
            <div class="modal-content">
                <div class="modal-header">
                    <h3 class="modal-title fs-5" id="mdModalLabel">{{ __('dashboard.addClass') }}</h3>
                    <button class="btn-close" type="button" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <form class=" needs-validation custom-input validation-forms" novalidate=""
                    action="{{ route('class.store') }}" method="POST">
                    @csrf
                    <div class="modal-body dark-modal">
                        <input type="hidden" name="grade_id" id="class_grade_id">
                        <div id="classRepeater">
                            <div class="row class-item">
                                <div class="col-12 col-xl-5 col-lg-5 col-md-10 col-sm-12 mb-2">
                                    <label class="col-form-label">{{ __('dashboard.name_ar') }}</label>
                                    <input class="form-control" type="text" name="class[0][name_ar]" required = "">
                                    <div class="invalid-feedback">{{ __('dashboard.name_ar_required') }}</div>
                                </div>
                                <div class="col-10 col-xl-5 col-lg-5 col-md-10 col-sm-10 mb-2">
                                    <label class="col-form-label">{{ __('dashboard.name_en') }}</label>
                                    <input class="form-control" type="text" name="class[0][name_en]" required = "">
                                    <div class="invalid-feedback">{{ __('dashboard.name_en_required') }}</div>
                                </div>
                                <div class="col-2 col-xl-2 col-lg-2 col-md-12 col-sm-2 mb-2 d-flex align-items-end">
                                    <button type="button" class="btn btn-info mt-3" id="addClass">
                                        <i class="fas fa-plus-square"></i></button>

                                </div>
                            </div>
                        </div>


                    </div>
                    <div class="modal-footer">
                        <button class="btn btn-secondary" type="button" data-bs-dismiss="modal"> <i
                                class="fas fa-times-circle mx-2"></i>{{ __('dashboard.close') }}</button>
                        <button class="btn btn-primary" type="submit"> <i
                                class="fas fa-save mx-2"></i>{{ __('dashboard.save') }} </button>
                    </div>
                </form>
            </div>
        </div>
    </div>


    <!-- Edit Class Modal -->
    <div class="modal fade" id="editClassModal" tabindex="-1" aria-labelledby="editClassModalLabel"
        aria-hidden="true">
        <div class="modal-dialog modal-fullscreen-md-down modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h3 class="modal-title" id="editClassModalLabel">{{ __('dashboard.editClass') }}</h3>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <form id="editClassForm">
                    @csrf
                    <input type="hidden" name="id" id="editClassId">

                    <div class="modal-body">
                        <div class="row">
                            <div class="mb-3 col-12 col-xl-6 col-lg-6 col-md-12 col-sm-12">
                                <label class="form-label">{{ __('dashboard.name_ar') }}</label>
                                <input type="text" name="name_ar" id="editClassNameAr" class="form-control" required>
                            </div>

                            <div class="mb-3 col-12 col-xl-6 col-lg-6 col-md-12 col-sm-12">
                                <label class="form-label">{{ __('dashboard.name_en') }}</label>
                                <input type="text" name="name_en" id="editClassNameEn" class="form-control" required>
                            </div>
                        </div>
                    </div>

                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">
                            <i class="fas fa-times-circle mx-2"></i> {{ __('dashboard.close') }}
                        </button>
                        <button type="submit" class="btn btn-primary">
                            <i class="fas fa-save mx-2"></i> {{ __('dashboard.save') }}
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
@endsection
@section('js')
    <script>
        $(document).ready(function() {
            var table = $('#grades-table').DataTable({
                processing: true,
                serverSide: true,
                ajax: "{{ route('grades.index') }}",
                language: {!! json_encode(__('datatable')) !!},
                columns: [{
                        data: 'id',
                        name: 'id'
                    },
                    {
                        data: 'translated_name',
                        name: 'translated_name',
                        orderable: true,
                        searchable: true
                    },
                    {
                        data: "classrooms",
                        name: "classrooms",
                        orderable: false,
                        searchable: true
                    },
                    {
                        data: 'action',
                        name: 'action',
                        orderable: false,
                        searchable: false
                    }
                ]
            });

            var gradeIndex = 1;
            // Add a new grade input
            $('#addGrade').click(function() {
                $('#gradeRepeater').append(`
                <div class="row grade-item">
                    <div class="col-12 col-xl-5 col-lg-5 col-md-10 col-sm-12 mb-2">
                        <label class="col-form-label">{{ __('dashboard.name_ar') }}</label>
                        <input class="form-control" type="text" name="grades[${gradeIndex}][name_ar]" required>
                        <div class="invalid-feedback">{{ __('dashboard.name_ar_required') }}</div>
                    </div>
                    <div class="col-10 col-xl-5 col-lg-5 col-md-10 col-sm-10 mb-2">
                        <label class="col-form-label">{{ __('dashboard.name_en') }}</label>
                        <input class="form-control" type="text" name="grades[${gradeIndex}][name_en]" required>
                        <div class="invalid-feedback">{{ __('dashboard.name_en_required') }}</div>
                    </div>
                    <div class="col-2 col-xl-2 col-lg-2 col-md-12 col-sm-2 mb-2 d-flex align-items-end">
                        <button type="button" class="btn btn-danger remove-grade"><i class="fas fa-trash"></i></button>
                    </div>
                </div>`);

                gradeIndex++;
            });

            // Remove grade input
            $(document).on('click', '.remove-grade', function() {
                $(this).closest('.grade-item').remove();
            });

            $(document).on('click', '.edit-btn', function() {
                let gradeId = $(this).data('id');
                let nameAr = $(this).data('name_ar');
                let nameEn = $(this).data('name_en');

                $('#grade_id').val(gradeId);
                $('#name_ar').val(nameAr);
                $('#name_en').val(nameEn);
            });

            // Handle form submission for editing
            $('#gradeEdit').on('submit', function(e) {
                e.preventDefault();
                let gradeId = $('#grade_id').val();
                let nameAr = $('#name_ar').val();
                let nameEn = $('#name_en').val();

                $.ajax({
                    url: "grades/" + gradeId,
                    type: "PUT",
                    data: {
                        _token: "{{ csrf_token() }}",
                        name: {
                            ar: nameAr,
                            en: nameEn
                        }
                    },
                    success: function(response) {
                        if (response.success) {
                            toastr.success(response.message); // Show Toastr success message
                        } else {
                            toastr.error(
                                "{{ __('dashboard.update_failed') }}"); // Fallback message
                        }
                        $('#editGradeModal').modal('hide'); // Close modal after success
                        $('#grades-table').DataTable().ajax.reload(); // Reload DataTable
                    },
                    error: function(xhr) {
                        toastr.error("{{ __('dashboard.update_failed') }}");
                    }
                });
            });


            $(document).on('click', '.add-repeater-btn', function() {
                let gradeId = $(this).data('grade_id');
                $('#class_grade_id').val(gradeId);
            });


            var classIndex = 1;
            // Add a new grade input
            $('#addClass').click(function() {
                $('#classRepeater').append(`
                <div class="row class-item">
                    <div class="col-12 col-xl-5 col-lg-5 col-md-10 col-sm-12 mb-2">
                        <label class="col-form-label">{{ __('dashboard.name_ar') }}</label>
                        <input class="form-control" type="text" name="class[${classIndex}][name_ar]" required>
                        <div class="invalid-feedback">{{ __('dashboard.name_ar_required') }}</div>
                    </div>
                    <div class="col-10 col-xl-5 col-lg-5 col-md-10 col-sm-10 mb-2">
                        <label class="col-form-label">{{ __('dashboard.name_en') }}</label>
                        <input class="form-control" type="text" name="class[${classIndex}][name_en]" required>
                        <div class="invalid-feedback">{{ __('dashboard.name_en_required') }}</div>
                    </div>
                    <div class="col-2 col-xl-2 col-lg-2 col-md-12 col-sm-2 mb-2 d-flex align-items-end">
                        <button type="button" class="btn btn-danger remove-class"><i class="fas fa-trash"></i></button>
                    </div>
                </div>`);

                classIndex++;
            });

            // Remove grade input
            $(document).on('click', '.remove-class', function() {
                $(this).closest('.class-item').remove();
            });

            $(document).on("click", ".edit-class-btn", function() {
                let classId = $(this).data("id");
                let nameAr = $(this).data("name_ar");
                let nameEn = $(this).data("name_en");

                $("#editClassId").val(classId);
                $("#editClassNameAr").val(nameAr);
                $("#editClassNameEn").val(nameEn);
            });

            $("#editClassForm").on("submit", function(e) {
                e.preventDefault();

                let classId = $("#editClassId").val();
                let formData = $(this).serialize();

                $.ajax({
                    url: "/classes/update/" + classId,
                    type: "PUT",
                    data: formData,
                    success: function(response) {
                        toastr.success(response.message);
                        $("#editClassModal").modal("hide");
                        $("#grades-table").DataTable().ajax.reload();
                    },
                    error: function(xhr) {
                        toastr.error(xhr.responseJSON.message);
                    }
                });
            });





        });
    </script>
@endsection
