@extends('layouts.master')

@section('title', __('dashboard.exam_questions'))

@section('content')
    <div class="row">
        <div class="col-xl-12">
            <div class="card">
                <div class="card-header">
                    <h3>{{ __('dashboard.exam_questions') }} - {{ $exam->title }}</h3>
                </div>
                <div class="card-body">
                    @foreach($groupedQuestions as $groupId => $questions)
                        <div class="mb-4">
                            <h4 class="text-primary">{{ __('dashboard.qui_group') }}: {{ $questions->first()->group->name }}</h4>
                            <hr>

                            @foreach($questions as $question)
                                <div class="mb-3 border p-3 rounded">
                                    <h5><strong>{{ __('dashboard.Qui_text_ar') }}:</strong> {{ $question->question_text }}</h5>
                      
                                    <h5><strong>{{ __('dashboard.marks') }}:</strong> {{ $question->marks }}</h5>
                                    <h5><strong>{{ __('dashboard.Qui_type') }}:</strong> 
                                        {{ $question->question_type == 1 ? __('dashboard.Qui_multi') : __('dashboard.Qui_essay') }}
                                    </h5>

                                    @if ($question->video)
                                        <div class="mb-3">
                                            <h5><strong>{{ __('dashboard.Qui_video') }}:</strong></h5>
                                            <video width="50%" controls>
                                                <source src="{{ asset('storage/' . $question->video) }}" type="video/mp4">
                                                {{ __('dashboard.video_not_supported') }}
                                            </video>
                                        </div>
                                    @endif

                                    @if ($question->question_type == 1)
                                        <h5><strong>{{ __('dashboard.Qui_options') }}:</strong></h5>
                                        <ul class="list-group">
                                            @foreach ($question->choices as $choice)
                                                <li class="list-group-item {{ $choice->is_correct ? 'list-group-item-success' : '' }}">
                                                    {{ $choice->choice_text }}  / {{ $choice->is_correct }}
                                                    @if ($choice->is_correct == 1)
                                                        <span class="badge bg-success">{{ __('dashboard.Qui_correct_option') }}</span>
                                                    @endif
                                                </li>
                                            @endforeach
                                        </ul>
                                    @endif

                                    @if ($question->question_type == 2)
                                        <h5><strong>{{ __('dashboard.Qui_correct_answer') }}:</strong></h5>
                                        <ul class="list-group">
                                            @foreach ($question->essayAnswers as $answer)
                                            <li class="list-group-item">
                                              {{ $answer->user_answer }} ----  {{ $answer->correct_answer }} 
                                          </li>
                                                
                                            @endforeach
                                        </ul>
                                    @endif
                                </div>
                            @endforeach
                        </div>
                    @endforeach

                
                </div>
            </div>
        </div>
    </div>
@endsection
