@extends('layouts.master')

@section('pages')
    {{ __('dashboard.home') }}
@endsection
@section('title')
    {{ __('dashboard.students') }}
@endsection

@section('btn')
    <button class="btn btn-outline-success" type="button" data-bs-toggle="modal" data-bs-target="#userAdd"><i
            class="fas fa-plus-circle mx-2"></i> {{ __('dashboard.addStudent') }} </button>

@endsection
@section('css')
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css">
    <style>
        /* Center align text in the table header and rows */
        #students-table th,
        #students-table td {
            text-align: center;
            /* Center text horizontally */
            vertical-align: middle;
            /* Center text vertically */
        }

        /* Remove background from the DataTables processing overlay */
        .dataTables_processing {
            background: none !important;
            /* Removes background */
            color: teal !important;
            /* Ensures the text is visible */
            font-size: 16px;
            /* Adjust text size */
            font-weight: bold;
            /* Makes text bold */
            border: none !important;
            /* Removes any border */
            box-shadow: none !important;
            /* Removes shadow */
        }
    </style>
@endsection
@section('content')
<div class="container">
    <table class="table table-bordered dataTable" id="students-table">
        <thead>
            <tr>
                <th>#</th>
                <th>{{ __('dashboard.name') }}</th>
                <th>{{__('dashboard.email')}}</th>
                <th>{{__('dashboard.phone')}}</th>
                <th>{{__('dashboard.grade')}}</th>
                <th>{{__('dashboard.country')}}</th>
                <th>{{__('dashboard.state')}}</th>
                <th>{{__('dashboard.city')}}</th>

                <th>{{__('dashboard.action')}}</th>
            </tr>
        </thead>
    </table>
</div>

@endsection

@section('js')
<script>
    $(function () {
        $('#students-table').DataTable({
            processing: true,
            serverSide: true,
            ajax: '{{ route("students.data") }}',
            language: {!! json_encode(__('datatable')) !!},

            columns: [
                { data: 'id', name: 'id' },
                { data: 'name', name: 'name' },
                { data: 'email', name: 'email' },
                { data: 'phone_number', name: 'phone_number' },
                { data: 'grade_name', name: 'grade_name' },
                { data: 'country_name', name: 'country_name' },
                { data: 'state_name', name: 'state_name' },
                { data: 'city_name', name: 'city_name' },
                { data: 'action', name: 'action', orderable: false, searchable: false }
            ]
        });
    });
</script>

@endsection