@extends('layouts.master')

@section('pages')
    {{ __('dashboard.home') }}
@endsection

@section('title')
    {{ __('dashboard.addQui') }}
@endsection

@section('btn')
    <a href="{{ route('questions.show', 1) }}">Show</a>
@endsection
@section('css')
@endsection

@section('content')
    <div class="row">
        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12 mb-2">
            <div class="card">
                <div class="card-header card-no-border pb-0">
                    <h3>{{ __('dashboard.addQui') }}</h3>
                </div>
                <div class="card-body">
                    <form id="questionForm" class="row g-3 needs-validation custom-input validation-forms" novalidate=""
                        method="post" action="{{ route('question.store') }}" enctype="multipart/form-data">
                        @csrf
                        <div class="col-12 col-xl-6 col-lg-6 col-md-12 col-sm-12 mb-2">
                            <label class="form-label" for="exams">{{ __('dashboard.exams') }}</label>
                            <select class="form-select" id="exams" required="" name="exams">
                                <option selected="" disabled="" value="">{{ __('dashboard.Choose..') }}</option>
                                @foreach ($exams as $exam)
                                    <option value="{{ $exam->id }}" {{ old('exams') == $exam->id ? 'selected' : '' }}>
                                        {{ $exam->title }}</option>
                                @endforeach
                            </select>
                            <div class="invalid-feedback">{{ __('dashboard.select_required') }}</div>
                        </div>

                        <div class="col-12 col-xl-6 col-lg-6 col-md-12 col-sm-12 mb-2">
                            <label class="form-label" for="groups">{{ __('dashboard.qui_group') }}</label>
                            <select class="form-select" id="groups" required="" name="groups">
                                <option selected="" disabled="" value="">{{ __('dashboard.Choose..') }}
                                </option>
                                @foreach ($groups as $group)
                                    <option value="{{ $group->id }}"
                                        {{ old('groups') == $group->id ? 'selected' : '' }}>{{ $group->name }}</option>
                                @endforeach
                            </select>
                            <div class="invalid-feedback">{{ __('dashboard.select_required') }}</div>
                        </div>

                        <!-- Question Text Fields -->
                        <div class="col-12 col-xl-6 col-lg-6 col-md-12 col-sm-12 mb-2">
                            <label class="form-label" for="question_text_ar">{{ __('dashboard.Qui_text_ar') }}</label>
                            <input class="form-control" id="question_text_ar" type="text" name="question_text_ar"
                                required="" value="{{ old('question_text_ar') }}">
                            <div class="invalid-feedback">{{ __('dashboard.question_text_ar_required') }}</div>
                        </div>
                        <div class="col-12 col-xl-6 col-lg-6 col-md-12 col-sm-12 mb-2">
                            <label class="form-label" for="question_text_en">{{ __('dashboard.Qui_text_en') }}</label>
                            <input class="form-control" id="question_text_en" type="text" name="question_text_en"
                                required="" value="{{ old('question_text_en') }}">
                            <div class="invalid-feedback">{{ __('dashboard.question_text_en_required') }}</div>
                        </div>

                        <!-- Marks -->
                        <div class="col-12 col-xl-6 col-lg-6 col-md-12 col-sm-12 mb-2">
                            <label class="form-label" for="marks">{{ __('dashboard.marks') }}</label>
                            <input class="form-control" id="marks" type="number" name="marks" required=""
                                value="{{ old('marks') }}">
                            <div class="invalid-feedback">{{ __('dashboard.marks_required') }}</div>
                        </div>

                        <!-- video -->
                        <div class="col-12 col-xl-6 col-lg-6 col-md-12 col-sm-12 mb-2">
                            <label class="form-label" for="video">{{ __('dashboard.Qui_video') }}</label>
                            <input class="form-control" id="video" type="file" name="video"
                                accept="video/mp4,video/x-m4v,video/*">
                            <div id="video-progress" style="display: none;">
                                <progress id="upload-progress" value="0" max="100"></progress>
                                <span id="progress-text">0%</span>
                            </div>
                            <input type="hidden" name="uploaded_video" id="uploaded_video">
                        </div>


                        <!-- Question Type Selection -->
                        <div class="col-12 col-xl-12 col-lg-12 col-md-12 col-sm-12 mb-2 text-center">
                            <div class="card-wrapper border rounded-3 checkbox-checked">
                                <h6 class="sub-title">{{ __('dashboard.Qui_type') }}</h6>
                                <div class="radio-form d-flex align-items-center justify-content-around g-3 my-3">
                                    <div class="form-check">
                                        <input class="form-check-input p-3" id="choice" type="radio" value="1"
                                            name="question_type" required=""
                                            {{ old('question_type') == 1 ? 'checked' : '' }}>
                                        <label class="form-check-label badge"
                                            for="choice">{{ __('dashboard.Qui_multi') }}</label>
                                    </div>
                                    <div class="form-check">
                                        <input class="form-check-input p-3" id="essay" type="radio" value="2"
                                            {{ old('question_type') == 2 ? 'checked' : '' }} name="question_type"
                                            required="">
                                        <label class="form-check-label badge"
                                            for="essay">{{ __('dashboard.Qui_essay') }}</label>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Multiple Choice Fields (Dynamic Add/Remove) -->
                        <div id="ChoiceRepeater" class="multi-choice-area" style="display:none;">
                            <div class="row choice-item">
                                <div class="col-12 col-xl-4 col-lg-4 col-md-10 col-sm-12 mb-2">
                                    <label class="col-form-label">{{ __('dashboard.Qui_option_ar') }}</label>
                                    <input class="form-control" type="text" name="choices[0][name_ar]"
                                        required="">
                                </div>
                                <div class="col-12 col-xl-4 col-lg-4 col-md-10 col-sm-12 mb-2">
                                    <label class="col-form-label">{{ __('dashboard.Qui_option_en') }}</label>
                                    <input class="form-control" type="text" name="choices[0][name_en]"
                                        required="">
                                </div>
                                <div class="col-12 col-xl-2 col-lg-2 col-md-10 col-sm-12 mb-2">
                                    <div class="form-check py-4 my-3">
                                        <input class="form-check-input correct-checkbox" type="checkbox"
                                            data-hidden-input="choices[0][correct]" id="choices[0][correct]">
                                        <input type="hidden" name="choices[0][correct]" value="0">
                                        <label class="form-check-label"
                                            for="choices[0][correct]">{{ __('dashboard.Qui_correct_option') }}</label>
                                    </div>
                                </div>

                                <div class="col-2 col-xl-2 col-lg-2 col-md-12 col-sm-2 mb-2 mt-4">
                                    <button type="button" class="btn btn-info mt-1" id="addChoice">
                                        <i class="fas fa-plus-square"></i>
                                    </button>
                                </div>
                            </div>
                        </div>

                        <!-- Essay Fields with Correct Answer Input (Dynamic Add/Remove) -->
                        <div id="EssayRepeater" class="essay-area" style="display:none;">
                            <div class="row essay-item">
                                <div class="col-12 col-xl-4 col-lg-4 col-md-10 col-sm-12 mb-2">
                                    <label class="col-form-label">{{ __('dashboard.Qui_part_ar') }}</label>
                                    <input class="form-control" type="text" name="essay[0][answer_ar]"
                                        required="">
                                </div>
                                <div class="col-12 col-xl-4 col-lg-4 col-md-10 col-sm-12 mb-2">
                                    <label class="col-form-label">{{ __('dashboard.Qui_part_en') }}</label>
                                    <input class="form-control" type="text" name="essay[0][answer_en]"
                                        required="">
                                </div>
                                <div class="col-12 col-xl-2 col-lg-2 col-md-10 col-sm-12 mb-2">
                                    <label class="col-form-label">{{ __('dashboard.Qui_correct_answer') }}</label>
                                    <input class="form-control" type="text" name="essay[0][correct_answer]"
                                        required="">
                                    <div class="invalid-feedback">{{ __('dashboard.correct_answer_required') }}</div>
                                </div>
                                <div class="col-2 col-xl-2 col-lg-2 col-md-12 col-sm-2 mb-2 d-flex align-items-end">
                                    <button type="button" class="btn btn-info mt-1" id="addEssay">
                                        <i class="fas fa-plus-square"></i>
                                    </button>
                                </div>
                            </div>
                        </div>

                        <!-- Submit Button -->
                        <div class="col-12 mt-2">
                            <button class="btn btn-primary" type="submit">{{ __('dashboard.save') }}</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('js')
    <script>
        var choiceIndex = 1;
        // Add a new grade input
        $('#addChoice').click(function() {
            $('#ChoiceRepeater').append(`
              <div class="row choice-item">
                  <div class="col-12 col-xl-4 col-lg-4 col-md-10 col-sm-12 mb-2">
                      <label class="col-form-label">{{ __('dashboard.Qui_option_ar') }}</label>
                      <input class="form-control" type="text" name="choices[${choiceIndex}][name_ar]" required="">
                  </div>
                  <div class="col-12 col-xl-4 col-lg-4 col-md-10 col-sm-12 mb-2">
                      <label class="col-form-label">{{ __('dashboard.Qui_option_en') }}</label>
                      <input class="form-control" type="text" name="choices[${choiceIndex}][name_en]" required="">
                  </div>
                  <div class="col-12 col-xl-2 col-lg-2 col-md-10 col-sm-12 mb-2">
                      <div class="form-check py-4 my-3">
                          <input class="form-check-input correct-checkbox" type="checkbox"
                                data-hidden-input="choices[${choiceIndex}][correct]"
                                id="choices[${choiceIndex}][correct]">
                          <input type="hidden" name="choices[${choiceIndex}][correct]" value="0">
                          <label class="form-check-label" for="choices[${choiceIndex}][correct]">
                              {{ __('dashboard.Qui_correct_option') }}
                          </label>
                      </div>
                  </div>
                  <div class="col-2 col-xl-2 col-lg-2 col-md-12 col-sm-2 mb-2 mt-4">
                      <button type="button" class="btn btn-danger remove-choice">
                          <i class="fas fa-trash"></i>
                      </button>
                  </div>
              </div>
          `);
            choiceIndex++;

        });

        // Remove grade input
        $(document).on('click', '.remove-choice', function() {
            $(this).closest('.choice-item').remove();
        });

        var essayIndex = 1;
        // Add a new essay input
        $('#addEssay').click(function() {
            $('#EssayRepeater').append(` 
                <div class="row essay-item">
                    <div class="col-12 col-xl-4 col-lg-4 col-md-10 col-sm-12 mb-2">
                        <label class="col-form-label">{{ __('dashboard.Qui_part_ar') }}</label>
                        <input class="form-control" type="text" name="essay[${essayIndex}][answer_ar]" required="">
                    </div>
                    <div class="col-12 col-xl-4 col-lg-4 col-md-10 col-sm-12 mb-2">
                        <label class="col-form-label">{{ __('dashboard.Qui_part_en') }}</label>
                        <input class="form-control" type="text" name="essay[${essayIndex}][answer_en]" required="">
                    </div>
                    <div class="col-12 col-xl-2 col-lg-2 col-md-10 col-sm-12 mb-2">
                        <label class="col-form-label">{{ __('dashboard.Qui_correct_answer') }}</label>
                        <input class="form-control" type="text" name="essay[${essayIndex}][correct_answer]" required="">
                    </div>
                    <div class="col-2 col-xl-2 col-lg-2 col-md-12 col-sm-2 mb-2 mt-4 d-flex align-items-end">
                        <button type="button" class="btn btn-danger remove-essay">
                            <i class="fas fa-trash"></i>
                        </button>
                    </div>
                </div>`);
            essayIndex++;
        });


        $(document).on('change', '.correct-checkbox', function() {

            let hiddenInputName = $(this).data("hidden-input");

            let hiddenInput = $("input[name='" + hiddenInputName + "']");


            if ($(this).is(":checked")) {
                $(".correct-checkbox").not(this).prop("checked", false);
                $(".correct-checkbox").not(this).each(function() {
                    let otherHiddenInputName = $(this).data("hidden-input");
                    $("input[name='" + otherHiddenInputName + "']").val("0");
                });
                hiddenInput.val("1");
            } else {
                hiddenInput.val("0");
            }

        
        });


        // Remove essay input
        $(document).on('click', '.remove-essay', function() {
            $(this).closest('.essay-item').remove();
        });

        // Switch to show MCQ or Essay fields dynamically
        $('input[name="question_type"]').change(function() {
            if ($('#choice').is(':checked')) {
                // Show multiple choice fields and hide essay fields
                $('#ChoiceRepeater').show();
                $('#EssayRepeater').hide();

                // Add 'required' attribute to the choice inputs and remove from essay
                $('input[name^="choices"][name$="[name_ar]"]').attr('required', true);
                $('input[name^="choices"][name$="[name_en]"]').attr('required', true);
                $('input[name^="choices"][name$="[correct]"]').attr('required', false);

                // Clear essay fields
                $('input[name^="essay"][name$="[answer_ar]"]').val('').attr('required', false);
                $('input[name^="essay"][name$="[answer_en]"]').val('').attr('required', false);
                $('input[name^="essay"][name$="[correct_answer]"]').val('').attr('required', false);

                // Clear choices if any existing values
                $('input[name^="choices"][name$="[name_ar]"]').val('');
                $('input[name^="choices"][name$="[name_en]"]').val('');
                $('input[name^="choices"][name$="[correct]"]').prop('checked', false);

            } else if ($('#essay').is(':checked')) {
                // Show essay fields and hide multiple choice fields
                $('#EssayRepeater').show();
                $('#ChoiceRepeater').hide();

                // Add 'required' attribute to essay inputs and remove from choices
                $('input[name^="essay"][name$="[answer_ar]"]').attr('required', true);
                $('input[name^="essay"][name$="[answer_en]"]').attr('required', true);
                $('input[name^="essay"][name$="[correct_answer]"]').attr('required', true);

                // Clear choice fields
                $('input[name^="choices"][name$="[name_ar]"]').val('').attr('required', false);
                $('input[name^="choices"][name$="[name_en]"]').val('').attr('required', false);
                $('input[name^="choices"][name$="[correct]"]').prop('checked', false);
            }
        });
    </script>

    <script>
        $(document).ready(function() {
            $("#video").change(function(event) {
                let file = event.target.files[0];
                let formData = new FormData();
                formData.append("video", file);
                formData.append("_token", "{{ csrf_token() }}");

                // Show progress bar
                $("#video-progress").show();

                $.ajax({
                    url: "{{ route('upload.video') }}", // Laravel route for handling video upload
                    type: "POST",
                    data: formData,
                    contentType: false,
                    processData: false,
                    xhr: function() {
                        var xhr = new window.XMLHttpRequest();
                        xhr.upload.addEventListener("progress", function(evt) {
                            if (evt.lengthComputable) {
                                var percentComplete = (evt.loaded / evt.total) * 100;
                                $("#upload-progress").val(percentComplete);
                                $("#progress-text").text(Math.round(percentComplete) +
                                    "%");
                            }
                        }, false);
                        return xhr;
                    },
                    success: function(response) {
                        $("#uploaded_video").val(response
                            .filepath); // Store the uploaded file path
                        $("#video-progress").hide();
                        // alert("Video uploaded successfully!");
                    },
                    error: function(xhr, status, error) {
                        alert("Video upload failed! " + xhr.responseText);
                    }
                });
            });
        });
    </script>
@endsection
