@extends('layouts.master')

@section('pages')
    {{ __('dashboard.home') }}
@endsection
@section('title')
    {{ __('dashboard.users') }}
@endsection

@section('btn')
    <button class="btn btn-outline-success" type="button" data-bs-toggle="modal" data-bs-target="#userAdd"><i
            class="fas fa-plus-circle mx-2"></i> {{ __('dashboard.addUser') }} </button>
@endsection
@section('css')
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css">
    <style>
        /* Center align text in the table header and rows */
        #users-table th,
        #users-table td {
            text-align: center;
            /* Center text horizontally */
            vertical-align: middle;
            /* Center text vertically */
        }

        /* Remove background from the DataTables processing overlay */
        .dataTables_processing {
            background: none !important;
            /* Removes background */
            color: teal !important;
            /* Ensures the text is visible */
            font-size: 16px;
            /* Adjust text size */
            font-weight: bold;
            /* Makes text bold */
            border: none !important;
            /* Removes any border */
            box-shadow: none !important;
            /* Removes shadow */
        }
    </style>
@endsection
@section('content')
    <div class="row">
        <div class="col-xl-12">
            <div class="table-responsive">
                <table class="table table-bordered dataTable" id="users-table">
                    <thead>
                        <tr>
                            <th>#</th>
                            <th>{{ __('dashboard.name') }}</th>
                            <th>{{ __('messages.username') }}</th>
                            <th>{{ __('dashboard.action') }}</th>
                        </tr>
                    </thead>
                </table>
            </div>
        </div>
    </div>


    <!-- Country Add -->
    <div class="modal fade" id="userAdd" tabindex="-1" aria-labelledby="mdModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg modal-fullscreen-md-down">
            <div class="modal-content">
                <div class="modal-header">
                    <h3 class="modal-title fs-5" id="mdModalLabel">{{ __('dashboard.addUser') }}</h3>
                    <button class="btn-close" type="button" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <form class=" needs-validation custom-input validation-forms" novalidate=""
                    action="{{ route('users.store') }}" method="POST">
                    @csrf
                    <div class="modal-body dark-modal">
                        <div class="row mb-2">
                            <div class="col-6">
                                <label class="col-sm-12 col-form-label"
                                    for="countryName_ar">{{ __('dashboard.name_ar') }}</label>
                                <input class="form-control" id="countryName_ar" type="text" required=""
                                    name="name_ar">
                                <div class="invalid-feedback">{{ __('dashboard.name_ar_required') }}</div>
                            </div>

                            <div class="col-6">
                                <label class="col-sm-12 col-form-label"
                                    for="countryName_en">{{ __('dashboard.name_en') }}</label>
                                <input class="form-control" id="countryName_en" type="text" required=""
                                    name="name_en">
                                <div class="invalid-feedback">{{ __('dashboard.name_en_required') }}</div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-12 mb-2">
                                <label class="col-sm-12 col-form-label"
                                    for="email">{{ __('messages.username') }}</label>
                                <input class="form-control" id="email" type="email" required="" name="email">
                                <div class="invalid-feedback">{{ __('dashboard.email_required') }}</div>
                            </div>

                            <div class="col-6">
                                <label class="col-sm-12 col-form-label"
                                    for="password">{{ __('messages.password') }}</label>
                                <input class="form-control" id="password" type="text" required="" name="password">
                                <div class="invalid-feedback">{{ __('dashboard.password_required') }}</div>
                            </div>

                            <div class="col-6">
                                <label class="col-sm-12 col-form-label"
                                    for="password_confirmation">{{ __('dashboard.password_conformid') }}</label>
                                <input class="form-control" id="password_confirmation" type="text" required=""
                                    name="password_confirmation">
                                <div class="invalid-feedback">{{ __('dashboard.password_required') }}</div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button class="btn btn-secondary" type="button" data-bs-dismiss="modal"> <i
                                class="fas fa-times-circle mx-2"></i>{{ __('dashboard.close') }}</button>
                        <button class="btn btn-primary" type="submit"> <i
                                class="fas fa-save mx-2"></i>{{ __('dashboard.save') }} </button>
                    </div>
                </form>
            </div>
        </div>
    </div>


    <!-- User Edit -->
    <div class="modal fade" id="editUserModal" tabindex="-1" aria-labelledby="mdModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-fullscreen-md-down">
            <div class="modal-content">
                <div class="modal-header">
                    <h3 class="modal-title fs-5" id="mdModalLabel">{{ __('dashboard.editUser') }}</h3>
                    <button class="btn-close" type="button" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>

                <form id="editUserForm" class=" needs-validation custom-input validation-forms" novalidate="">
                    @csrf
                    <div class="modal-body dark-modal">
                        <div class="row">
                            <input type="hidden" id="user_id">
                            <div class="col-12">
                                <label class="col-sm-12 col-form-label"
                                    for="name_ar">{{ __('dashboard.name_ar') }}</label>
                                <input class="form-control" id="name_ar" type="text" required="">
                                <div class="invalid-feedback">{{ __('dashboard.name_ar_required') }}</div>
                            </div>

                            <div class="col-12">
                                <label class="col-sm-12 col-form-label"
                                    for="name_en">{{ __('dashboard.name_en') }}</label>
                                <input class="form-control" id="name_en" type="text" required="">
                                <div class="invalid-feedback">{{ __('dashboard.name_en_required') }}</div>
                            </div>

                            <div class="col-12">
                                <label class="col-sm-12 col-form-label"
                                    for="edit_email">{{ __('messages.username') }}</label>
                                <input class="form-control" id="edit_email" type="email" required="">
                                <div class="invalid-feedback">{{ __('dashboard.email_required') }}</div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button class="btn btn-secondary" type="button" data-bs-dismiss="modal"> <i
                                class="fas fa-times-circle mx-2"></i>{{ __('dashboard.close') }}</button>
                        <button class="btn btn-primary" type="submit"> <i
                                class="fas fa-save mx-2"></i>{{ __('dashboard.update') }} </button>
                    </div>
                </form>
            </div>
        </div>
    </div>


    <!-- Edit Password Modal -->
    <div class="modal fade" id="editPasswordModal" tabindex="-1" aria-labelledby="editPasswordLabel"
        aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">{{ __('dashboard.editPassword') }}</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <form id="editPasswordForm" class=" needs-validation custom-input validation-forms" novalidate="">
                    @csrf
                    <div class="modal-body">

                        <div class="row">
                            <input type="hidden" id="password_user_id">

                            <div class="mb-3 col-12 col-lg-12 col-xl-12 col-md-12 col-sm-12 ">
                                <label>{{ __('messages.username') }}</label>
                                <input type="email" id="password_email" class="form-control" readonly>
                            </div>

                            <div class="mb-3 col-12 col-lg-12 col-xl-12 col-md-12 col-sm-12 ">
                                <label>{{ __('dashboard.newPassword') }}</label>
                                <input type="text" id="new_password" class="form-control" required = "">
                                <div class="invalid-feedback">{{ __('dashboard.password_required') }}</div>
                            </div>

                            <div class="mb-3 col-12 col-lg-12 col-xl-12 col-md-12 col-sm-12 ">
                                <label>{{ __('dashboard.password_conformid') }}</label>
                                <input type="text" id="confirm_password" class="form-control" required = "">
                                <div class="invalid-feedback">{{ __('dashboard.password_required') }}</div>
                            </div>
                        </div>

                    </div>
                    <div class="modal-footer">
                        <button class="btn btn-secondary" type="button" data-bs-dismiss="modal"> <i
                                class="fas fa-times-circle mx-2"></i>{{ __('dashboard.close') }}</button>
                        <button class="btn btn-primary" type="submit"> <i
                                class="fas fa-save mx-2"></i>{{ __('dashboard.update') }} </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
@endsection
@section('js')
    <script>
        $(document).ready(function() {
            var table = $('#users-table').DataTable({
                processing: true,
                serverSide: true,
                ajax: "{{ route('users.index') }}",
                language: {!! json_encode(__('datatable')) !!},
                columns: [{
                        data: 'id',
                        name: 'id'
                    },
                    {
                        data: 'translated_name',
                        name: 'translated_name',
                        orderable: true,
                        searchable: true
                    },

                    {
                        data: 'email',
                        name: 'email',
                        orderable: true,
                        searchable: true
                    },
                    {
                        data: 'action',
                        name: 'action',
                        orderable: false,
                        searchable: false
                    }
                ]
            });

            $(document).on("click", ".edit-user-btn", function() {
                let userId = $(this).attr("data-id");
                let nameAr = $(this).attr("data-name_ar");
                let nameEn = $(this).attr("data-name_en");
                let email = $(this).attr("data-email");

                $("#user_id").val(userId);
                $("#name_ar").val(nameAr);
                $("#name_en").val(nameEn);
                $("#edit_email").val(email);
            });

            $("#editUserForm").on("submit", function(e) {
                e.preventDefault();

                let userId = $("#user_id").val();
                let formData = {
                    _token: $('meta[name="csrf-token"]').attr("content"), // Include CSRF token
                    _method: "PUT", // Add method spoofing if needed
                    name_ar: $("#name_ar").val(),
                    name_en: $("#name_en").val(),
                    email: $("#edit_email").val(),
                };

                $.ajax({
                    url: "/users/update/" + userId, // Use the correct route for update
                    type: "POST", // POST request (to handle the PUT method)
                    data: formData, // Pass the data with the CSRF token
                    success: function(response) {
                        toastr.success(response.message);
                        $("#editUserModal").modal("hide");
                        $("#users-table").DataTable().ajax.reload();
                    },
                    error: function(xhr) {
                        toastr.error(xhr.responseJSON.message);
                    },
                });
            });


            // Handle "Edit Password" Click
            $(document).on('click', '.edit-password-btn', function() {
                let pass_userId = $(this).data('id');
                let pass_email = $(this).data('email');

                $('#password_user_id').val(pass_userId);
                $('#password_email').val(pass_email);
            });

            $('#editPasswordForm').submit(function(e) {
                e.preventDefault();

                let pass_userId = $('#password_user_id').val();
                let newPassword = $('#new_password').val();
                let confirmPassword = $('#confirm_password').val();

                if (newPassword !== confirmPassword) {
                    alert("{{ __('dashboard.passwordMismatch') }}");
                    return;
                }

                $.ajax({
                    url: "/users/update-password/" + pass_userId,
                    type: "POST",
                    data: {
                        "_token": "{{ csrf_token() }}",
                        new_password: newPassword,
                        new_password_confirmation: confirmPassword
                    },
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    },
                    success: function(response) {
                        if (response.success) {
                            toastr.success(response.message);
                            $('#editPasswordModal').modal('hide');
                        } else {
                            toastr.error("{{ __('flasher::messages.error') }}");

                        }
                    },
                    error: function() {
                        toastr.error("{{ __('flasher::messages.error') }}");
                    }
                });
            });



        });
    </script>
@endsection
